/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime.misc;

import java.util.Arrays;

public abstract class IntegerList {
    private static int[] EMPTY_DATA = new int[0];
    private int[] _data = EMPTY_DATA;
    private int _size;

    private void ensureCapacity(int n) {
        if (n >= 0 && n <= 0x7FFFFFF7) {
            int[] nArray = this._data;
            int n2 = this._data.length == 0 ? 4 : nArray.length;
            while (n2 < n) {
                if ((n2 *= 2) >= 0 && n2 <= 0x7FFFFFF7) continue;
                n2 = 0x7FFFFFF7;
            }
            this._data = Arrays.copyOf(this._data, n2);
            return;
        }
        throw new OutOfMemoryError();
    }

    public final void add(int n) {
        int n2 = ((IntegerList)object)._size;
        if (((IntegerList)object)._data.length == n2) {
            ((IntegerList)object).ensureCapacity(n2 + 1);
        }
        IntegerList integerList = object;
        Object object = integerList._data;
        int n3 = integerList._size;
        object[n3] = n;
        integerList._size = n3 + 1;
    }

    public final int get(int n) {
        if (n >= 0 && n < this._size) {
            return this._data[n];
        }
        throw new IndexOutOfBoundsException();
    }

    public final int removeAt(int n) {
        int n2 = ((IntegerList)object).get(n);
        IntegerList integerList = object;
        System.arraycopy(integerList._data, n + 1, integerList._data, n, ((IntegerList)object)._size - n - 1);
        Object object = integerList._data;
        int n3 = integerList._size;
        object[n3 - 1] = false;
        integerList._size = n3 - 1;
        return n2;
    }

    public final boolean isEmpty() {
        return this._size == 0;
    }

    public final int size() {
        return this._size;
    }

    public final void clear() {
        Arrays.fill(this._data, 0, this._size, 0);
        this._size = 0;
    }

    public final int[] toArray() {
        int n = this._size;
        if (n == 0) {
            return EMPTY_DATA;
        }
        return Arrays.copyOf(this._data, n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegerList)) {
            return false;
        }
        object = (IntegerList)object;
        if (this._size != ((IntegerList)object)._size) {
            return false;
        }
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i] == ((IntegerList)object)._data[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this._size; ++i) {
            n = n * 31 + this._data[i];
        }
        return n;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

