/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.OutputStream;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Timeout;
import okio._UtilKt;

final class OutputStreamSink
implements Sink {
    private final OutputStream out;
    private final Timeout timeout;

    public OutputStreamSink(OutputStream outputStream, Timeout timeout2) {
        Intrinsics.checkNotNullParameter(outputStream, "out");
        Intrinsics.checkNotNullParameter(timeout2, "timeout");
        this.out = outputStream;
        this.timeout = timeout2;
    }

    @Override
    public void write(Buffer buffer, long l) {
        Buffer buffer2 = buffer;
        Intrinsics.checkNotNullParameter(buffer2, "source");
        _UtilKt.checkOffsetAndCount(buffer2.size(), 0L, l);
        while (l > 0L) {
            Buffer buffer3 = buffer;
            long l2 = l;
            this.timeout.throwIfReached();
            Segment segment = buffer.head;
            Intrinsics.checkNotNull(segment);
            int n = (int)Math.min(l2, (long)(segment.limit - segment.pos));
            Segment segment2 = segment;
            byte[] byArray = segment2.data;
            this.out.write(byArray, segment2.pos, n);
            segment.pos += n;
            long l3 = n;
            long l4 = l2 - l3;
            buffer3.setSize$okio(buffer3.size() - l3);
            if (segment.pos == segment.limit) {
                buffer.head = segment.pop();
                SegmentPool.recycle(segment);
            }
            l = l4;
        }
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
    }

    @Override
    public Timeout timeout() {
        return this.timeout;
    }

    public String toString() {
        return "sink(" + this.out + ')';
    }
}

