/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.security.MessageDigest;
import javax.crypto.Mac;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSink;
import okio.HashingSink$Companion;
import okio.Segment;
import okio.Sink;
import okio._UtilKt;

public final class HashingSink
extends ForwardingSink {
    public static final HashingSink$Companion Companion = new HashingSink$Companion(null);
    private final MessageDigest messageDigest;
    private final Mac mac;

    public HashingSink(Sink sink2, MessageDigest messageDigest) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        Intrinsics.checkNotNullParameter(messageDigest, "digest");
        super(sink2);
        this.messageDigest = messageDigest;
        this.mac = null;
    }

    public HashingSink(Sink sink2, String string) {
        HashingSink hashingSink = messageDigest;
        String string2 = string;
        Intrinsics.checkNotNullParameter(sink2, "sink");
        Intrinsics.checkNotNullParameter(string2, "algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance(string2);
        Intrinsics.checkNotNullExpressionValue(messageDigest, "getInstance(algorithm)");
        hashingSink(sink2, messageDigest);
    }

    @Override
    public void write(Buffer buffer, long l) {
        int n;
        Buffer buffer2 = buffer;
        Intrinsics.checkNotNullParameter(buffer2, "source");
        _UtilKt.checkOffsetAndCount(buffer2.size(), 0L, l);
        Segment segment = buffer2.head;
        Intrinsics.checkNotNull(segment);
        for (long i = 0L; i < l; i += (long)n) {
            n = (int)Math.min(l - i, (long)(segment.limit - segment.pos));
            Object object = this.messageDigest;
            if (object != null) {
                MessageDigest messageDigest = object;
                Segment segment2 = segment;
                object = segment2.data;
                messageDigest.update((byte[])object, segment2.pos, n);
            } else {
                Mac mac = this.mac;
                object = mac;
                Segment segment3 = segment;
                Intrinsics.checkNotNull(object);
                object = segment3.data;
                mac.update((byte[])object, segment3.pos, n);
            }
            segment = segment.next;
            Intrinsics.checkNotNull(segment);
        }
        super.write(buffer, l);
    }

    public final ByteString hash() {
        Object object;
        MessageDigest messageDigest = ((HashingSink)object).messageDigest;
        if (messageDigest != null) {
            object = messageDigest.digest();
        } else {
            Mac mac = ((HashingSink)object).mac;
            Intrinsics.checkNotNull(mac);
            object = mac.doFinal();
        }
        Intrinsics.checkNotNullExpressionValue(object, "result");
        return new ByteString((byte[])object);
    }
}

