/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.util.logging.Level;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.http2.Http2;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Reader$Companion;
import okio.Buffer;
import okio.BufferedSource;
import okio.Source;
import okio.Timeout;

public final class Http2Reader$ContinuationSource
implements Source {
    private final BufferedSource source;
    private int length;
    private int flags;
    private int streamId;
    private int left;
    private int padding;

    public Http2Reader$ContinuationSource(BufferedSource bufferedSource) {
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        this.source = bufferedSource;
    }

    private final void readContinuationHeader() {
        int n;
        int n2;
        Http2Reader$ContinuationSource http2Reader$ContinuationSource = this;
        int n3 = http2Reader$ContinuationSource.streamId;
        http2Reader$ContinuationSource.left = n2 = Util.readMedium(http2Reader$ContinuationSource.source);
        http2Reader$ContinuationSource.length = n2;
        n2 = Util.and(http2Reader$ContinuationSource.source.readByte(), 255);
        http2Reader$ContinuationSource.flags = Util.and(http2Reader$ContinuationSource.source.readByte(), 255);
        Http2Reader$Companion http2Reader$Companion = Http2Reader.Companion;
        if (http2Reader$Companion.getLogger().isLoggable(Level.FINE)) {
            Http2Reader$ContinuationSource http2Reader$ContinuationSource2 = this;
            int n4 = http2Reader$ContinuationSource2.streamId;
            int n5 = http2Reader$ContinuationSource2.length;
            int n6 = http2Reader$ContinuationSource2.flags;
            http2Reader$Companion.getLogger().fine(Http2.INSTANCE.frameLog(true, n4, n5, n2, n6));
        }
        this.streamId = n = this.source.readInt() & Integer.MAX_VALUE;
        if (n2 == 9) {
            if (n == n3) {
                return;
            }
            throw new IOException("TYPE_CONTINUATION streamId changed");
        }
        throw new IOException(n2 + " != TYPE_CONTINUATION");
    }

    public final void setLength(int n) {
        this.length = n;
    }

    public final void setFlags(int n) {
        this.flags = n;
    }

    public final void setStreamId(int n) {
        this.streamId = n;
    }

    public final int getLeft() {
        return this.left;
    }

    public final void setLeft(int n) {
        this.left = n;
    }

    public final void setPadding(int n) {
        this.padding = n;
    }

    @Override
    public long read(Buffer buffer, long l) {
        int n;
        Intrinsics.checkNotNullParameter(buffer, "sink");
        while ((n = this.left) == 0) {
            Http2Reader$ContinuationSource http2Reader$ContinuationSource = this;
            http2Reader$ContinuationSource.source.skip(this.padding);
            http2Reader$ContinuationSource.padding = 0;
            if ((http2Reader$ContinuationSource.flags & 4) != 0) {
                return -1L;
            }
            this.readContinuationHeader();
        }
        long l2 = this.source.read(buffer, Math.min(l, (long)n));
        if (l2 == -1L) {
            return -1L;
        }
        this.left -= (int)l2;
        return l2;
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    @Override
    public void close() {
    }
}

