/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.net.Socket;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2Connection$Listener;
import okhttp3.internal.http2.PushObserver;
import okio.BufferedSink;
import okio.BufferedSource;

public final class Http2Connection$Builder {
    private boolean client;
    private final TaskRunner taskRunner;
    public Socket socket;
    public String connectionName;
    public BufferedSource source;
    public BufferedSink sink;
    private Http2Connection$Listener listener;
    private PushObserver pushObserver;
    private int pingIntervalMillis;

    public Http2Connection$Builder(boolean bl, TaskRunner taskRunner) {
        Http2Connection$Builder http2Connection$Builder = this;
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        this.client = bl;
        http2Connection$Builder.taskRunner = taskRunner;
        http2Connection$Builder.listener = Http2Connection$Listener.REFUSE_INCOMING_STREAMS;
        http2Connection$Builder.pushObserver = PushObserver.CANCEL;
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    public final TaskRunner getTaskRunner$okhttp() {
        return this.taskRunner;
    }

    public final Socket getSocket$okhttp() {
        Socket socket = ((Http2Connection$Builder)((Object)socket)).socket;
        if (socket != null) {
            return socket;
        }
        Intrinsics.throwUninitializedPropertyAccessException("socket");
        return null;
    }

    public final void setSocket$okhttp(Socket socket) {
        Intrinsics.checkNotNullParameter(socket, "<set-?>");
        this.socket = socket;
    }

    public final String getConnectionName$okhttp() {
        String string = ((Http2Connection$Builder)((Object)string)).connectionName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException("connectionName");
        return null;
    }

    public final void setConnectionName$okhttp(String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.connectionName = string;
    }

    public final BufferedSource getSource$okhttp() {
        BufferedSource bufferedSource = ((Http2Connection$Builder)((Object)bufferedSource)).source;
        if (bufferedSource != null) {
            return bufferedSource;
        }
        Intrinsics.throwUninitializedPropertyAccessException("source");
        return null;
    }

    public final void setSource$okhttp(BufferedSource bufferedSource) {
        Intrinsics.checkNotNullParameter(bufferedSource, "<set-?>");
        this.source = bufferedSource;
    }

    public final BufferedSink getSink$okhttp() {
        BufferedSink bufferedSink = ((Http2Connection$Builder)((Object)bufferedSink)).sink;
        if (bufferedSink != null) {
            return bufferedSink;
        }
        Intrinsics.throwUninitializedPropertyAccessException("sink");
        return null;
    }

    public final void setSink$okhttp(BufferedSink bufferedSink) {
        Intrinsics.checkNotNullParameter(bufferedSink, "<set-?>");
        this.sink = bufferedSink;
    }

    public final Http2Connection$Listener getListener$okhttp() {
        return this.listener;
    }

    public final void setListener$okhttp(Http2Connection$Listener http2Connection$Listener) {
        Intrinsics.checkNotNullParameter(http2Connection$Listener, "<set-?>");
        this.listener = http2Connection$Listener;
    }

    public final PushObserver getPushObserver$okhttp() {
        return this.pushObserver;
    }

    public final int getPingIntervalMillis$okhttp() {
        return this.pingIntervalMillis;
    }

    public final void setPingIntervalMillis$okhttp(int n) {
        this.pingIntervalMillis = n;
    }

    public final Http2Connection$Builder socket(Socket object, String string, BufferedSource bufferedSource, BufferedSink bufferedSink) {
        Http2Connection$Builder http2Connection$Builder = this;
        Intrinsics.checkNotNullParameter(object, "socket");
        Intrinsics.checkNotNullParameter(string, "peerName");
        Intrinsics.checkNotNullParameter(bufferedSource, "source");
        Intrinsics.checkNotNullParameter(bufferedSink, "sink");
        http2Connection$Builder.setSocket$okhttp((Socket)object);
        object = http2Connection$Builder.getClient$okhttp() ? Util.okHttpName + ' ' + string : Intrinsics.stringPlus("MockWebServer ", string);
        Http2Connection$Builder http2Connection$Builder2 = this;
        http2Connection$Builder2.setConnectionName$okhttp((String)object);
        http2Connection$Builder2.setSource$okhttp(bufferedSource);
        http2Connection$Builder2.setSink$okhttp(bufferedSink);
        return http2Connection$Builder2;
    }

    public final Http2Connection$Builder listener(Http2Connection$Listener http2Connection$Listener) {
        Http2Connection$Builder http2Connection$Builder = this;
        Intrinsics.checkNotNullParameter(http2Connection$Listener, "listener");
        http2Connection$Builder.setListener$okhttp(http2Connection$Listener);
        return http2Connection$Builder;
    }

    public final Http2Connection$Builder pingIntervalMillis(int n) {
        Http2Connection$Builder http2Connection$Builder = this;
        http2Connection$Builder.setPingIntervalMillis$okhttp(n);
        return http2Connection$Builder;
    }

    public final Http2Connection build() {
        return new Http2Connection(this);
    }
}

