/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.internal.Util;
import okio.ByteString;

public final class Http2 {
    public static final Http2 INSTANCE;
    public static final ByteString CONNECTION_PREFACE;
    private static final String[] FRAME_NAMES;
    private static final String[] FLAGS;
    private static final String[] BINARY;

    private Http2() {
    }

    static {
        int n;
        int n2;
        INSTANCE = new Http2();
        CONNECTION_PREFACE = ByteString.Companion.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
        FRAME_NAMES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
        FLAGS = new String[64];
        Object[] objectArray = new String[256];
        for (n2 = 0; n2 < 256; ++n2) {
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            String string = Integer.toBinaryString(n2);
            Intrinsics.checkNotNullExpressionValue(string, "toBinaryString(it)");
            objectArray2[0] = string;
            objectArray[n2] = StringsKt.replace$default(Util.format("%8s", objectArray3), ' ', '0', false, 4, null);
        }
        BINARY = objectArray;
        String[] stringArray = FLAGS;
        stringArray[0] = "";
        stringArray[1] = "END_STREAM";
        n2 = 1;
        int[] nArray = new int[1];
        objectArray = nArray;
        nArray[0] = 1;
        Http2.FLAGS[8] = "PADDED";
        for (n = 0; n < n2; ++n) {
            Object object = objectArray[n];
            String string = object;
            object = string | 8;
            FLAGS[object] = Intrinsics.stringPlus(FLAGS[string], "|PADDED");
        }
        String[] stringArray2 = FLAGS;
        stringArray2[4] = "END_HEADERS";
        stringArray2[32] = "PRIORITY";
        Http2.FLAGS[36] = "END_HEADERS|PRIORITY";
        n = 3;
        int[] nArray2 = new int[3];
        Object[] objectArray4 = nArray2;
        nArray2[0] = 4;
        nArray2[1] = 32;
        nArray2[2] = 36;
        int n3 = 0;
        while (n3 < n) {
            int n4 = objectArray4[n3];
            ++n3;
            for (int i = 0; i < n2; ++i) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2;
                String string = objectArray[i];
                String[] stringArray3 = FLAGS;
                int n5 = string | n4;
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3();
                stringArray3[n5] = stringBuilder2.append((Object)stringArray3[string]).append('|').append((Object)stringArray3[n4]).toString();
                stringBuilder3 = stringBuilder;
                stringBuilder3();
                FLAGS[n5 | 8] = stringBuilder.append((Object)stringArray3[string]).append('|').append((Object)stringArray3[n4]).append("|PADDED").toString();
            }
        }
        n2 = 0;
        int n6 = FLAGS.length;
        while (n2 < n6) {
            n = n2 + 1;
            objectArray4 = FLAGS;
            if (FLAGS[n2] == null) {
                objectArray4[n2] = (int)BINARY[n2];
            }
            n2 = n;
        }
    }

    public final String frameLog(boolean bl, int n, int n2, int n3, int n4) {
        Http2 http2 = string;
        String string = http2.formattedType$okhttp(n3);
        String string2 = http2.formatFlags(n3, n4);
        String string3 = bl ? "<<" : ">>";
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = string3;
        objectArray2[1] = n;
        objectArray[2] = n2;
        objectArray[3] = string;
        objectArray[4] = string2;
        return Util.format("%s 0x%08x %5d %-13s %s", objectArray2);
    }

    public final String formattedType$okhttp(int n) {
        String string;
        Object[] objectArray = FRAME_NAMES;
        if (n < FRAME_NAMES.length) {
            string = objectArray[n];
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = n;
            string = Util.format("0x%02x", objectArray);
        }
        return string;
    }

    public final String formatFlags(int n, int n2) {
        Object object;
        block8: {
            if (n2 == 0) {
                return "";
            }
            switch (n) {
                default: {
                    object = FLAGS;
                    if (n2 >= FLAGS.length) break;
                    object = object[n2];
                    Intrinsics.checkNotNull(object);
                    break block8;
                }
                case 4: 
                case 6: {
                    return n2 == 1 ? "ACK" : BINARY[n2];
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    return BINARY[n2];
                }
            }
            object = BINARY[n2];
        }
        if (n == 5 && (n2 & 4) != 0) {
            object = StringsKt.replace$default((String)object, "HEADERS", "PUSH_PROMISE", false, 4, null);
        } else if (n == 0 && (n2 & 0x20) != 0) {
            object = StringsKt.replace$default((String)object, "PRIORITY", "COMPRESSED", false, 4, null);
        }
        return object;
    }
}

