/*
 * Decompiled with CFR 0.152.
 */
package link.infra.packwiz.installer.deps.commons-cli;

abstract class OptionValidator {
    private static boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    private static boolean isValidOpt(char c) {
        return OptionValidator.isValidChar(c) || c == '?' || c == '@';
    }

    static String validate(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (!OptionValidator.isValidOpt(c)) {
                throw new IllegalArgumentException("Illegal option name '" + c + "'");
            }
        } else {
            for (char c : string.toCharArray()) {
                if (OptionValidator.isValidChar(c)) {
                    continue;
                }
                throw new IllegalArgumentException("The option '" + string + "' contains an illegal character : '" + c + "'");
            }
        }
        return string;
    }
}

