/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.UnsignedTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor$Kind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithSource;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorWithVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertySetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceFile;
import kotlin.reflect.jvm.internal.impl.descriptors.VariableDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public abstract class DescriptorUtils {
    public static final FqName JVM_NAME;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ReceiverParameterDescriptor getDispatchReceiverParameterIfNeeded(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(0);
        }
        if (declarationDescriptor instanceof ClassDescriptor) {
            return ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
        }
        return null;
    }

    public static boolean isLocal(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(1);
        }
        while (declarationDescriptor != null) {
            if (!DescriptorUtils.isAnonymousObject(declarationDescriptor) && !DescriptorUtils.isDescriptorWithLocalVisibility(declarationDescriptor)) {
                declarationDescriptor = declarationDescriptor.getContainingDeclaration();
                continue;
            }
            return true;
        }
        return false;
    }

    public static boolean isDescriptorWithLocalVisibility(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor instanceof DeclarationDescriptorWithVisibility && ((DeclarationDescriptorWithVisibility)declarationDescriptor).getVisibility() == DescriptorVisibilities.LOCAL;
    }

    public static FqNameUnsafe getFqName(DeclarationDescriptor declarationDescriptor) {
        FqName fqName2;
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(2);
        }
        return (fqName2 = DescriptorUtils.getFqNameSafeIfPossible(declarationDescriptor)) != null ? fqName2.toUnsafe() : DescriptorUtils.getFqNameUnsafe(declarationDescriptor);
    }

    public static FqName getFqNameSafe(DeclarationDescriptor declarationDescriptor) {
        FqName fqName2;
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(3);
        }
        if ((fqName2 = DescriptorUtils.getFqNameSafeIfPossible(declarationDescriptor)) == null) {
            fqName2 = DescriptorUtils.getFqNameUnsafe(declarationDescriptor).toSafe();
        }
        if (fqName2 == null) {
            DescriptorUtils.$$$reportNull$$$0(4);
        }
        return fqName2;
    }

    private static FqName getFqNameSafeIfPossible(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(5);
        }
        if (!(declarationDescriptor instanceof ModuleDescriptor) && !ErrorUtils.isError(declarationDescriptor)) {
            if (declarationDescriptor instanceof PackageViewDescriptor) {
                return ((PackageViewDescriptor)declarationDescriptor).getFqName();
            }
            if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                return ((PackageFragmentDescriptor)declarationDescriptor).getFqName();
            }
            return null;
        }
        return FqName.ROOT;
    }

    private static FqNameUnsafe getFqNameUnsafe(DeclarationDescriptor object) {
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(6);
        }
        DeclarationDescriptor declarationDescriptor = object.getContainingDeclaration();
        if (!$assertionsDisabled && declarationDescriptor == null) {
            throw new AssertionError((Object)("Not package/module descriptor doesn't have containing declaration: " + object));
        }
        object = DescriptorUtils.getFqName(declarationDescriptor).child(object.getName());
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(7);
        }
        return object;
    }

    public static boolean isTopLevelDeclaration(DeclarationDescriptor declarationDescriptor) {
        return declarationDescriptor != null && declarationDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor;
    }

    public static boolean areInSameModule(DeclarationDescriptor declarationDescriptor, DeclarationDescriptor declarationDescriptor2) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(16);
        }
        if (declarationDescriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(17);
        }
        return DescriptorUtils.getContainingModule(declarationDescriptor).equals(DescriptorUtils.getContainingModule(declarationDescriptor2));
    }

    public static DeclarationDescriptor getParentOfType(DeclarationDescriptor declarationDescriptor, Class clazz) {
        if (clazz == null) {
            DescriptorUtils.$$$reportNull$$$0(18);
        }
        return DescriptorUtils.getParentOfType(declarationDescriptor, clazz, true);
    }

    public static DeclarationDescriptor getParentOfType(DeclarationDescriptor declarationDescriptor, Class clazz, boolean bl) {
        if (clazz == null) {
            DescriptorUtils.$$$reportNull$$$0(19);
        }
        if (declarationDescriptor == null) {
            return null;
        }
        if (bl) {
            declarationDescriptor = declarationDescriptor.getContainingDeclaration();
        }
        while (declarationDescriptor != null) {
            if (clazz.isInstance(declarationDescriptor)) {
                return declarationDescriptor;
            }
            declarationDescriptor = declarationDescriptor.getContainingDeclaration();
        }
        return null;
    }

    public static ModuleDescriptor getContainingModuleOrNull(KotlinType annotated) {
        if (annotated == null) {
            DescriptorUtils.$$$reportNull$$$0(20);
        }
        if ((annotated = annotated.getConstructor().getDeclarationDescriptor()) == null) {
            return null;
        }
        return DescriptorUtils.getContainingModuleOrNull((DeclarationDescriptor)annotated);
    }

    public static ModuleDescriptor getContainingModule(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(21);
        }
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModuleOrNull(declarationDescriptor);
        if (!$assertionsDisabled && moduleDescriptor == null) {
            throw new AssertionError((Object)("Descriptor without a containing module: " + declarationDescriptor));
        }
        if (moduleDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(22);
        }
        return moduleDescriptor;
    }

    public static ModuleDescriptor getContainingModuleOrNull(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(23);
        }
        while (declarationDescriptor != null) {
            if (declarationDescriptor instanceof ModuleDescriptor) {
                return (ModuleDescriptor)declarationDescriptor;
            }
            if (declarationDescriptor instanceof PackageViewDescriptor) {
                return ((PackageViewDescriptor)declarationDescriptor).getModule();
            }
            declarationDescriptor = declarationDescriptor.getContainingDeclaration();
        }
        return null;
    }

    public static boolean isDirectSubclass(ClassDescriptor object, ClassDescriptor classDescriptor) {
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(26);
        }
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(27);
        }
        object = object.getTypeConstructor().getSupertypes().iterator();
        while (object.hasNext()) {
            if (!DescriptorUtils.isSameClass((KotlinType)object.next(), classDescriptor.getOriginal())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubclass(ClassDescriptor classDescriptor, ClassDescriptor classDescriptor2) {
        if (classDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(28);
        }
        if (classDescriptor2 == null) {
            DescriptorUtils.$$$reportNull$$$0(29);
        }
        return DescriptorUtils.isSubtypeOfClass(classDescriptor.getDefaultType(), classDescriptor2.getOriginal());
    }

    private static boolean isSameClass(KotlinType annotated, DeclarationDescriptor declarationDescriptor) {
        if (annotated == null) {
            DescriptorUtils.$$$reportNull$$$0(30);
        }
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(31);
        }
        return (annotated = ((KotlinType)annotated).getConstructor().getDeclarationDescriptor()) != null && (annotated = annotated.getOriginal()) instanceof ClassifierDescriptor && declarationDescriptor instanceof ClassifierDescriptor && ((ClassifierDescriptor)declarationDescriptor).getTypeConstructor().equals(((ClassifierDescriptor)annotated).getTypeConstructor());
    }

    public static boolean isSubtypeOfClass(KotlinType object, DeclarationDescriptor declarationDescriptor) {
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(32);
        }
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(33);
        }
        if (DescriptorUtils.isSameClass((KotlinType)object, declarationDescriptor)) {
            return true;
        }
        object = ((KotlinType)object).getConstructor().getSupertypes().iterator();
        while (object.hasNext()) {
            if (!DescriptorUtils.isSubtypeOfClass((KotlinType)object.next(), declarationDescriptor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompanionObject(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.OBJECT) && ((ClassDescriptor)declarationDescriptor).isCompanionObject();
    }

    public static boolean isSealedClass(DeclarationDescriptor declarationDescriptor) {
        return (DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.CLASS) || DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.INTERFACE)) && ((ClassDescriptor)declarationDescriptor).getModality() == Modality.SEALED;
    }

    public static boolean isAnonymousObject(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(34);
        }
        return DescriptorUtils.isClass(declarationDescriptor) && declarationDescriptor.getName().equals(SpecialNames.NO_NAME_PROVIDED);
    }

    public static boolean isEnumEntry(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(36);
        }
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.ENUM_ENTRY);
    }

    public static boolean isEnumClass(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.ENUM_CLASS);
    }

    public static boolean isAnnotationClass(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.ANNOTATION_CLASS);
    }

    public static boolean isInterface(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.INTERFACE);
    }

    public static boolean isClass(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isKindOf(declarationDescriptor, ClassKind.CLASS);
    }

    public static boolean isClassOrEnumClass(DeclarationDescriptor declarationDescriptor) {
        return DescriptorUtils.isClass(declarationDescriptor) || DescriptorUtils.isEnumClass(declarationDescriptor);
    }

    private static boolean isKindOf(DeclarationDescriptor declarationDescriptor, ClassKind classKind) {
        if (classKind == null) {
            DescriptorUtils.$$$reportNull$$$0(37);
        }
        return declarationDescriptor instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).getKind() == classKind;
    }

    public static ClassDescriptor getSuperClassDescriptor(ClassDescriptor object) {
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(44);
        }
        object = object.getTypeConstructor().getSupertypes().iterator();
        while (object.hasNext()) {
            ClassDescriptor classDescriptor = DescriptorUtils.getClassDescriptorForType((KotlinType)object.next());
            if (classDescriptor.getKind() == ClassKind.INTERFACE) continue;
            return classDescriptor;
        }
        return null;
    }

    public static ClassDescriptor getClassDescriptorForType(KotlinType kotlinType) {
        if (kotlinType == null) {
            DescriptorUtils.$$$reportNull$$$0(45);
        }
        return DescriptorUtils.getClassDescriptorForTypeConstructor(kotlinType.getConstructor());
    }

    public static ClassDescriptor getClassDescriptorForTypeConstructor(TypeConstructor object) {
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(46);
        }
        ClassifierDescriptor classifierDescriptor = object.getDeclarationDescriptor();
        if (!$assertionsDisabled && !(classifierDescriptor instanceof ClassDescriptor)) {
            throw new AssertionError((Object)("Classifier descriptor of a type should be of type ClassDescriptor: " + object));
        }
        object = (ClassDescriptor)classifierDescriptor;
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(47);
        }
        return object;
    }

    public static DescriptorVisibility getDefaultConstructorVisibility(ClassDescriptor object, boolean bl) {
        ClassKind classKind;
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(48);
        }
        if ((classKind = object.getKind()) != ClassKind.ENUM_CLASS && !classKind.isSingleton()) {
            if (DescriptorUtils.isSealedClass((DeclarationDescriptor)object)) {
                if (bl) {
                    object = DescriptorVisibilities.PROTECTED;
                    if (object == null) {
                        DescriptorUtils.$$$reportNull$$$0(50);
                    }
                    return object;
                }
                object = DescriptorVisibilities.PRIVATE;
                if (object == null) {
                    DescriptorUtils.$$$reportNull$$$0(51);
                }
                return object;
            }
            if (DescriptorUtils.isAnonymousObject((DeclarationDescriptor)object)) {
                object = DescriptorVisibilities.DEFAULT_VISIBILITY;
                if (object == null) {
                    DescriptorUtils.$$$reportNull$$$0(52);
                }
                return object;
            }
            if (!$assertionsDisabled && classKind != ClassKind.CLASS && classKind != ClassKind.INTERFACE && classKind != ClassKind.ANNOTATION_CLASS) {
                throw new AssertionError();
            }
            object = DescriptorVisibilities.PUBLIC;
            if (object == null) {
                DescriptorUtils.$$$reportNull$$$0(53);
            }
            return object;
        }
        object = DescriptorVisibilities.PRIVATE;
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(49);
        }
        return object;
    }

    public static CallableMemberDescriptor unwrapFakeOverride(CallableMemberDescriptor callableMemberDescriptor) {
        if (callableMemberDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(59);
        }
        while (callableMemberDescriptor.getKind() == CallableMemberDescriptor$Kind.FAKE_OVERRIDE) {
            Collection collection = callableMemberDescriptor.getOverriddenDescriptors();
            if (!collection.isEmpty()) {
                callableMemberDescriptor = (CallableMemberDescriptor)collection.iterator().next();
                continue;
            }
            throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + callableMemberDescriptor);
        }
        return callableMemberDescriptor;
    }

    public static DeclarationDescriptorWithVisibility unwrapFakeOverrideToAnyDeclaration(DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility) {
        if (declarationDescriptorWithVisibility == null) {
            DescriptorUtils.$$$reportNull$$$0(61);
        }
        if (declarationDescriptorWithVisibility instanceof CallableMemberDescriptor) {
            return DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)declarationDescriptorWithVisibility);
        }
        if (declarationDescriptorWithVisibility == null) {
            DescriptorUtils.$$$reportNull$$$0(62);
        }
        return declarationDescriptorWithVisibility;
    }

    public static boolean shouldRecordInitializerForProperty(VariableDescriptor object, KotlinType kotlinType) {
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(63);
        }
        if (kotlinType == null) {
            DescriptorUtils.$$$reportNull$$$0(64);
        }
        if (!object.isVar() && !KotlinTypeKt.isError(kotlinType)) {
            KotlinTypeChecker kotlinTypeChecker;
            if (TypeUtils.acceptsNullable(kotlinType)) {
                return true;
            }
            object = DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)object);
            return KotlinBuiltIns.isPrimitiveType(kotlinType) || (kotlinTypeChecker = KotlinTypeChecker.DEFAULT).equalTypes(((KotlinBuiltIns)object).getStringType(), kotlinType) || kotlinTypeChecker.equalTypes(((KotlinBuiltIns)object).getNumber().getDefaultType(), kotlinType) || kotlinTypeChecker.equalTypes(((KotlinBuiltIns)object).getAnyType(), kotlinType) || UnsignedTypes.isUnsignedType(kotlinType);
        }
        return false;
    }

    public static Set getAllOverriddenDescriptors(CallableDescriptor callableDescriptor) {
        LinkedHashSet linkedHashSet;
        if (callableDescriptor == null) {
            DescriptorUtils.$$$reportNull$$$0(68);
        }
        LinkedHashSet linkedHashSet2 = linkedHashSet;
        linkedHashSet2();
        DescriptorUtils.collectAllOverriddenDescriptors(callableDescriptor.getOriginal(), linkedHashSet2);
        return linkedHashSet;
    }

    private static void collectAllOverriddenDescriptors(CallableDescriptor object, Set set) {
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(70);
        }
        if (set == null) {
            DescriptorUtils.$$$reportNull$$$0(71);
        }
        if (set.contains(object)) {
            return;
        }
        object = object.getOriginal().getOverriddenDescriptors().iterator();
        while (object.hasNext()) {
            CallableDescriptor callableDescriptor = ((CallableDescriptor)object.next()).getOriginal();
            DescriptorUtils.collectAllOverriddenDescriptors(callableDescriptor, set);
            set.add(callableDescriptor);
        }
    }

    public static SourceFile getContainingSourceFile(DeclarationDescriptor object) {
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(79);
        }
        if (object instanceof PropertySetterDescriptor) {
            object = ((PropertySetterDescriptor)object).getCorrespondingProperty();
        }
        if (object instanceof DeclarationDescriptorWithSource) {
            if ((object = ((DeclarationDescriptorWithSource)object).getSource().getContainingFile()) == null) {
                DescriptorUtils.$$$reportNull$$$0(80);
            }
            return object;
        }
        object = SourceFile.NO_SOURCE_FILE;
        if (object == null) {
            DescriptorUtils.$$$reportNull$$$0(81);
        }
        return object;
    }

    static {
        $assertionsDisabled = DescriptorUtils.class.desiredAssertionStatus() ^ true;
        JVM_NAME = new FqName("kotlin.jvm.JvmName");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        int n2;
        Object object;
        switch (n) {
            default: {
                object = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 69: 
            case 73: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 91: 
            case 93: {
                object = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 69: 
            case 73: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 91: 
            case 93: {
                n2 = 2;
            }
        }
        Object[] objectArray = new Object[n2];
        switch (n) {
            default: {
                objectArray[0] = "containingDeclaration";
                break;
            }
            case 85: 
            case 88: 
            case 90: {
                objectArray[0] = "name";
                break;
            }
            case 82: 
            case 84: 
            case 87: 
            case 89: {
                objectArray[0] = "scope";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray[0] = "annotated";
                break;
            }
            case 72: {
                objectArray[0] = "memberDescriptor";
                break;
            }
            case 71: {
                objectArray[0] = "result";
                break;
            }
            case 70: {
                objectArray[0] = "current";
                break;
            }
            case 68: {
                objectArray[0] = "f";
                break;
            }
            case 63: {
                objectArray[0] = "variable";
                break;
            }
            case 56: {
                objectArray[0] = "location";
                break;
            }
            case 55: {
                objectArray[0] = "innerClassName";
                break;
            }
            case 46: {
                objectArray[0] = "typeConstructor";
                break;
            }
            case 38: 
            case 39: 
            case 41: 
            case 44: 
            case 48: 
            case 54: 
            case 65: 
            case 66: 
            case 67: 
            case 74: 
            case 75: {
                objectArray[0] = "classDescriptor";
                break;
            }
            case 37: {
                objectArray[0] = "classKind";
                break;
            }
            case 31: {
                objectArray[0] = "other";
                break;
            }
            case 30: 
            case 32: 
            case 45: 
            case 64: {
                objectArray[0] = "type";
                break;
            }
            case 27: 
            case 29: 
            case 33: {
                objectArray[0] = "superClass";
                break;
            }
            case 26: 
            case 28: {
                objectArray[0] = "subClass";
                break;
            }
            case 25: {
                objectArray[0] = "declarationDescriptor";
                break;
            }
            case 20: {
                objectArray[0] = "kotlinType";
                break;
            }
            case 18: 
            case 19: {
                objectArray[0] = "aClass";
                break;
            }
            case 17: {
                objectArray[0] = "second";
                break;
            }
            case 16: {
                objectArray[0] = "first";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 69: 
            case 73: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 91: 
            case 93: {
                objectArray[0] = "kotlin/reflect/jvm/internal/impl/resolve/DescriptorUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 34: 
            case 35: 
            case 36: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 79: 
            case 92: 
            case 94: {
                objectArray[0] = "descriptor";
            }
        }
        switch (n) {
            default: {
                objectArray[1] = "kotlin/reflect/jvm/internal/impl/resolve/DescriptorUtils";
                break;
            }
            case 93: {
                objectArray[1] = "getDirectMember";
                break;
            }
            case 91: {
                objectArray[1] = "getPropertyByName";
                break;
            }
            case 86: {
                objectArray[1] = "getFunctionByName";
                break;
            }
            case 83: {
                objectArray[1] = "getAllDescriptors";
                break;
            }
            case 80: 
            case 81: {
                objectArray[1] = "getContainingSourceFile";
                break;
            }
            case 73: {
                objectArray[1] = "getAllOverriddenDeclarations";
                break;
            }
            case 69: {
                objectArray[1] = "getAllOverriddenDescriptors";
                break;
            }
            case 62: {
                objectArray[1] = "unwrapFakeOverrideToAnyDeclaration";
                break;
            }
            case 60: {
                objectArray[1] = "unwrapFakeOverride";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray[1] = "getDefaultConstructorVisibility";
                break;
            }
            case 47: {
                objectArray[1] = "getClassDescriptorForTypeConstructor";
                break;
            }
            case 42: 
            case 43: {
                objectArray[1] = "getSuperClassType";
                break;
            }
            case 40: {
                objectArray[1] = "getSuperclassDescriptors";
                break;
            }
            case 22: {
                objectArray[1] = "getContainingModule";
                break;
            }
            case 12: {
                objectArray[1] = "getClassIdForNonLocalClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray[1] = "getFqNameFromTopLevelClass";
                break;
            }
            case 7: {
                objectArray[1] = "getFqNameUnsafe";
                break;
            }
            case 4: {
                objectArray[1] = "getFqNameSafe";
            }
        }
        switch (n) {
            default: {
                objectArray[2] = "getDispatchReceiverParameterIfNeeded";
                break;
            }
            case 94: {
                objectArray[2] = "isMethodOfAny";
                break;
            }
            case 92: {
                objectArray[2] = "getDirectMember";
                break;
            }
            case 89: 
            case 90: {
                objectArray[2] = "getPropertyByName";
                break;
            }
            case 87: 
            case 88: {
                objectArray[2] = "getFunctionByNameOrNull";
                break;
            }
            case 84: 
            case 85: {
                objectArray[2] = "getFunctionByName";
                break;
            }
            case 82: {
                objectArray[2] = "getAllDescriptors";
                break;
            }
            case 79: {
                objectArray[2] = "getContainingSourceFile";
                break;
            }
            case 78: {
                objectArray[2] = "hasJvmNameAnnotation";
                break;
            }
            case 77: {
                objectArray[2] = "findJvmNameAnnotation";
                break;
            }
            case 76: {
                objectArray[2] = "getJvmName";
                break;
            }
            case 75: {
                objectArray[2] = "canHaveDeclaredConstructors";
                break;
            }
            case 74: {
                objectArray[2] = "isSingletonOrAnonymousObject";
                break;
            }
            case 72: {
                objectArray[2] = "getAllOverriddenDeclarations";
                break;
            }
            case 70: 
            case 71: {
                objectArray[2] = "collectAllOverriddenDescriptors";
                break;
            }
            case 68: {
                objectArray[2] = "getAllOverriddenDescriptors";
                break;
            }
            case 67: {
                objectArray[2] = "classCanHaveOpenMembers";
                break;
            }
            case 66: {
                objectArray[2] = "classCanHaveAbstractDeclaration";
                break;
            }
            case 65: {
                objectArray[2] = "classCanHaveAbstractFakeOverride";
                break;
            }
            case 63: 
            case 64: {
                objectArray[2] = "shouldRecordInitializerForProperty";
                break;
            }
            case 61: {
                objectArray[2] = "unwrapFakeOverrideToAnyDeclaration";
                break;
            }
            case 59: {
                objectArray[2] = "unwrapFakeOverride";
                break;
            }
            case 58: {
                objectArray[2] = "isTopLevelOrInnerClass";
                break;
            }
            case 57: {
                objectArray[2] = "isStaticNestedClass";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray[2] = "getInnerClassByName";
                break;
            }
            case 48: {
                objectArray[2] = "getDefaultConstructorVisibility";
                break;
            }
            case 46: {
                objectArray[2] = "getClassDescriptorForTypeConstructor";
                break;
            }
            case 45: {
                objectArray[2] = "getClassDescriptorForType";
                break;
            }
            case 44: {
                objectArray[2] = "getSuperClassDescriptor";
                break;
            }
            case 41: {
                objectArray[2] = "getSuperClassType";
                break;
            }
            case 39: {
                objectArray[2] = "getSuperclassDescriptors";
                break;
            }
            case 38: {
                objectArray[2] = "hasAbstractMembers";
                break;
            }
            case 37: {
                objectArray[2] = "isKindOf";
                break;
            }
            case 36: {
                objectArray[2] = "isEnumEntry";
                break;
            }
            case 35: {
                objectArray[2] = "isAnonymousFunction";
                break;
            }
            case 34: {
                objectArray[2] = "isAnonymousObject";
                break;
            }
            case 32: 
            case 33: {
                objectArray[2] = "isSubtypeOfClass";
                break;
            }
            case 30: 
            case 31: {
                objectArray[2] = "isSameClass";
                break;
            }
            case 28: 
            case 29: {
                objectArray[2] = "isSubclass";
                break;
            }
            case 26: 
            case 27: {
                objectArray[2] = "isDirectSubclass";
                break;
            }
            case 25: {
                objectArray[2] = "isAncestor";
                break;
            }
            case 24: {
                objectArray[2] = "getContainingClass";
                break;
            }
            case 21: {
                objectArray[2] = "getContainingModule";
                break;
            }
            case 20: 
            case 23: {
                objectArray[2] = "getContainingModuleOrNull";
                break;
            }
            case 18: 
            case 19: {
                objectArray[2] = "getParentOfType";
                break;
            }
            case 16: 
            case 17: {
                objectArray[2] = "areInSameModule";
                break;
            }
            case 15: {
                objectArray[2] = "isStaticDeclaration";
                break;
            }
            case 14: {
                objectArray[2] = "isOverride";
                break;
            }
            case 13: {
                objectArray[2] = "isExtension";
                break;
            }
            case 11: {
                objectArray[2] = "getClassIdForNonLocalClass";
                break;
            }
            case 8: {
                objectArray[2] = "getFqNameFromTopLevelClass";
                break;
            }
            case 6: {
                objectArray[2] = "getFqNameUnsafe";
                break;
            }
            case 5: {
                objectArray[2] = "getFqNameSafeIfPossible";
                break;
            }
            case 3: {
                objectArray[2] = "getFqNameSafe";
                break;
            }
            case 2: {
                objectArray[2] = "getFqName";
                break;
            }
            case 1: {
                objectArray[2] = "isLocal";
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 69: 
            case 73: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 91: 
            case 93: 
        }
        String string = String.format((String)object, objectArray);
        switch (n) {
            default: {
                IllegalArgumentException illegalArgumentException;
                object = illegalArgumentException;
                illegalArgumentException = new IllegalArgumentException(string);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 40: 
            case 42: 
            case 43: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 60: 
            case 62: 
            case 69: 
            case 73: 
            case 80: 
            case 81: 
            case 83: 
            case 86: 
            case 91: 
            case 93: {
                IllegalStateException illegalStateException;
                object = illegalStateException;
                illegalStateException = new IllegalStateException(string);
            }
        }
        throw object;
    }
}

