/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.JvmAbi;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;
import kotlin.text.StringsKt;

public abstract class PropertiesConventionUtilKt {
    public static final Name propertyNameByGetMethodName(Name name) {
        Name name2 = name;
        Intrinsics.checkNotNullParameter(name2, "methodName");
        Name name3 = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(name2, "get", false, null, 12, null);
        if (name3 == null) {
            name3 = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(name, "is", false, null, 8, null);
        }
        return name3;
    }

    public static final Name propertyNameBySetMethodName(Name name, boolean bl) {
        Intrinsics.checkNotNullParameter(name, "methodName");
        String string = "set";
        boolean bl2 = false;
        String string2 = bl ? "is" : null;
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(name, string, bl2, string2, 4, null);
    }

    public static final List propertyNamesBySetMethodName(Name name) {
        Intrinsics.checkNotNullParameter(name, "methodName");
        return CollectionsKt.listOfNotNull(PropertiesConventionUtilKt.propertyNameBySetMethodName(name, false), PropertiesConventionUtilKt.propertyNameBySetMethodName(name, true));
    }

    private static final Name propertyNameFromAccessorMethodName(Name object, String string, boolean bl, String string2) {
        if (((Name)object).isSpecial()) {
            return null;
        }
        String string3 = ((Name)object).getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string3, "methodName.identifier");
        if (!StringsKt.startsWith$default(string3, string, false, 2, null)) {
            return null;
        }
        if (string3.length() == string.length()) {
            return null;
        }
        char c = string3.charAt(string.length());
        if ('a' <= c && c < '{') {
            return null;
        }
        if (string2 != null) {
            if (_Assertions.ENABLED && !bl) {
                throw new AssertionError((Object)"Assertion failed");
            }
            return Name.identifier(string2 + StringsKt.removePrefix(string3, string));
        }
        if (!bl) {
            return object;
        }
        object = CapitalizeDecapitalizeKt.decapitalizeSmartForCompiler(StringsKt.removePrefix(string3, string), true);
        if (!Name.isValidIdentifier((String)object)) {
            return null;
        }
        return Name.identifier((String)object);
    }

    static /* synthetic */ Name propertyNameFromAccessorMethodName$default(Name name, String string, boolean bl, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName(name, string, bl, string2);
    }

    public static final List getPropertyNamesCandidatesByAccessorName(Name name) {
        Name name2 = name;
        Intrinsics.checkNotNullParameter(name2, "name");
        String string = name2.asString();
        Intrinsics.checkNotNullExpressionValue(string, "name.asString()");
        if (JvmAbi.isGetterName(string)) {
            return CollectionsKt.listOfNotNull((Object)PropertiesConventionUtilKt.propertyNameByGetMethodName(name));
        }
        if (JvmAbi.isSetterName(string)) {
            return PropertiesConventionUtilKt.propertyNamesBySetMethodName(name);
        }
        return BuiltinSpecialProperties.INSTANCE.getPropertyNameCandidatesBySpecialGetterName(name);
    }
}

