/*
 * Decompiled with CFR 0.152.
 */
package kotlin.ranges;

import kotlin.collections.IntIterator;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntProgression$Companion;
import kotlin.ranges.IntProgressionIterator;

public class IntProgression
implements Iterable,
KMappedMarker {
    public static final IntProgression$Companion Companion = new IntProgression$Companion(null);
    private final int first;
    private final int last;
    private final int step;

    public IntProgression(int n, int n2, int n3) {
        if (n3 != 0) {
            if (n3 != Integer.MIN_VALUE) {
                this.first = n;
                this.last = ProgressionUtilKt.getProgressionLastElement(n, n2, n3);
                this.step = n3;
                return;
            }
            throw new IllegalArgumentException("Step must be greater than Int.MIN_VALUE to avoid overflow on negation.");
        }
        throw new IllegalArgumentException("Step must be non-zero.");
    }

    public final int getFirst() {
        return this.first;
    }

    public final int getLast() {
        return this.last;
    }

    public final int getStep() {
        return this.step;
    }

    public IntIterator iterator() {
        IntProgression intProgression = this;
        int n = intProgression.first;
        int n2 = intProgression.last;
        int n3 = intProgression.step;
        return new IntProgressionIterator(n, n2, n3);
    }

    public boolean isEmpty() {
        return this.step > 0 ? this.first > this.last : this.first < this.last;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof IntProgression)) return false;
        if (this.isEmpty()) {
            if (((IntProgression)object).isEmpty()) return true;
        }
        object = (IntProgression)object;
        if (this.first != ((IntProgression)object).first) return false;
        if (this.last != ((IntProgression)object).last) return false;
        if (this.step != ((IntProgression)object).step) return false;
        return true;
    }

    public int hashCode() {
        return this.isEmpty() ? -1 : (this.first * 31 + this.last) * 31 + this.step;
    }

    public String toString() {
        return this.step > 0 ? this.first + ".." + this.last + " step " + this.step : this.first + " downTo " + this.last + " step " + -this.step;
    }
}

