/*
 * Decompiled with CFR 0.152.
 */
package kotlin;

import kotlin.KotlinVersion$Companion;
import kotlin.KotlinVersionCurrentValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;

public final class KotlinVersion
implements Comparable {
    public static final KotlinVersion$Companion Companion = new KotlinVersion$Companion(null);
    public static final KotlinVersion CURRENT = KotlinVersionCurrentValue.get();
    private final int major;
    private final int minor;
    private final int patch;
    private final int version;

    public KotlinVersion(int n, int n2, int n3) {
        this.major = n;
        this.minor = n2;
        this.patch = n3;
        this.version = this.versionOf(n, n2, n3);
    }

    public KotlinVersion(int n, int n2) {
        this(n, n2, 0);
    }

    private final int versionOf(int n, int n2, int n3) {
        if (new IntRange(0, 255).contains(n) && new IntRange(0, 255).contains(n2) && new IntRange(0, 255).contains(n3)) {
            return (n << 16) + (n2 << 8) + n3;
        }
        String string = "Version components are out of range: " + n + '.' + n2 + '.' + n3;
        throw new IllegalArgumentException(string.toString());
    }

    public String toString() {
        return "" + this.major + '.' + this.minor + '.' + this.patch;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if ((object = object instanceof KotlinVersion ? (KotlinVersion)object : null) == null) {
            return false;
        }
        return this.version == ((KotlinVersion)object).version;
    }

    public int hashCode() {
        return this.version;
    }

    public int compareTo(KotlinVersion kotlinVersion) {
        Intrinsics.checkNotNullParameter(kotlinVersion, "other");
        return this.version - kotlinVersion.version;
    }
}

