/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.sql;

import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.sql.SqlTimeTypeAdapter$1;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

final class SqlTimeTypeAdapter
extends TypeAdapter {
    static final TypeAdapterFactory FACTORY = new SqlTimeTypeAdapter$1();
    private final DateFormat format;

    private SqlTimeTypeAdapter() {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        simpleDateFormat = new SimpleDateFormat("hh:mm:ss a");
        v1.format = simpleDateFormat2;
    }

    /* synthetic */ SqlTimeTypeAdapter(SqlTimeTypeAdapter$1 sqlTimeTypeAdapter$1) {
        this();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Time read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        try {
            Date date = this.format.parse(string);
            // MONITOREXIT : this
            return new Time(date.getTime());
        }
        catch (Throwable throwable) {
            // MONITOREXIT : this
            try {
                throw throwable;
            }
            catch (ParseException parseException) {
                throw new JsonSyntaxException("Failed parsing '" + string + "' as SQL Time; at path " + jsonReader.getPreviousPath(), parseException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(JsonWriter object, Time time) {
        if (time == null) {
            ((JsonWriter)object).nullValue();
            return;
        }
        Object object2 = object;
        SqlTimeTypeAdapter sqlTimeTypeAdapter = this;
        synchronized (sqlTimeTypeAdapter) {
            object = sqlTimeTypeAdapter.format.format(time);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : v45040
            ((JsonWriter)object2).value((String)object);
            return;
        }
    }
}

