/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$1;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$Adapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory$BoundField;
import com.google.gson.internal.reflect.ReflectionHelper;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;
    private final FieldNamingStrategy fieldNamingPolicy;
    private final Excluder excluder;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingStrategy, Excluder excluder, JsonAdapterAnnotationTypeAdapterFactory jsonAdapterAnnotationTypeAdapterFactory) {
        this.constructorConstructor = constructorConstructor;
        this.fieldNamingPolicy = fieldNamingStrategy;
        this.excluder = excluder;
        this.jsonAdapterFactory = jsonAdapterAnnotationTypeAdapterFactory;
    }

    static boolean excludeField(Field field, boolean bl, Excluder excluder) {
        return !excluder.excludeClass(field.getType(), bl) && !excluder.excludeField(field, bl);
    }

    private List getFieldNames(Field stringArray) {
        ArrayList arrayList;
        Object object = stringArray.getAnnotation(SerializedName.class);
        if (object == null) {
            return Collections.singletonList(((ReflectiveTypeAdapterFactory)((Object)string)).fieldNamingPolicy.translateName((Field)stringArray));
        }
        SerializedName serializedName = object;
        String string = serializedName.value();
        stringArray = serializedName.alternate();
        if (stringArray.length == 0) {
            return Collections.singletonList(string);
        }
        object = arrayList;
        ((ArrayList)object)(stringArray.length + 1);
        arrayList.add(string);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            object.add(stringArray[i]);
        }
        return object;
    }

    private ReflectiveTypeAdapterFactory$BoundField createBoundField(Gson gson, Field field, String string, TypeToken typeToken, boolean bl, boolean bl2) {
        boolean bl3 = Primitives.isPrimitive(typeToken.getRawType());
        JsonAdapter jsonAdapter = field.getAnnotation(JsonAdapter.class);
        TypeAdapter typeAdapter = null;
        if (jsonAdapter != null) {
            typeAdapter = this.jsonAdapterFactory.getTypeAdapter(this.constructorConstructor, gson, typeToken, jsonAdapter);
        }
        boolean bl4 = typeAdapter != null;
        if (typeAdapter == null) {
            typeAdapter = gson.getAdapter(typeToken);
        }
        return new ReflectiveTypeAdapterFactory$1(this, string, bl, bl2, field, bl4, typeAdapter, gson, typeToken, bl3);
    }

    private Map getBoundFields(Gson gson, TypeToken typeToken, Class clazz) {
        LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField> linkedHashMap;
        LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<String, ReflectiveTypeAdapterFactory$BoundField>();
        if (clazz.isInterface()) {
            return linkedHashMap2;
        }
        Type type2 = typeToken.getType();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                boolean bl = this.excludeField(field, true);
                boolean bl2 = this.excludeField(field, false);
                if (!bl && !bl2) continue;
                ReflectionHelper.makeAccessible(field);
                Type type3 = $Gson$Types.resolve(typeToken.getType(), clazz, field.getGenericType());
                List list = this.getFieldNames(field);
                Object object = null;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    Object object2 = (String)list.get(i);
                    if (i != 0) {
                        bl = false;
                    }
                    object2 = linkedHashMap2.put((String)object2, this.createBoundField(gson, field, (String)object2, TypeToken.get(type3), bl, bl2));
                    if (object != null) continue;
                    object = object2;
                }
                if (object == null) {
                    continue;
                }
                throw new IllegalArgumentException(type2 + " declares multiple JSON fields named " + ((ReflectiveTypeAdapterFactory$BoundField)object).name);
            }
            Class<?> clazz2 = clazz;
            typeToken = TypeToken.get($Gson$Types.resolve(typeToken.getType(), clazz2, clazz2.getGenericSuperclass()));
            clazz = typeToken.getRawType();
        }
        return linkedHashMap2;
    }

    public boolean excludeField(Field field, boolean bl) {
        return ReflectiveTypeAdapterFactory.excludeField(field, bl, this.excluder);
    }

    @Override
    public TypeAdapter create(Gson gson, TypeToken typeToken) {
        Class clazz = typeToken.getRawType();
        if (!Object.class.isAssignableFrom(clazz)) {
            return null;
        }
        ObjectConstructor objectConstructor = this.constructorConstructor.get(typeToken);
        return new ReflectiveTypeAdapterFactory$Adapter(objectConstructor, this.getBoundFields(gson, typeToken, clazz));
    }
}

