/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.bind.TreeTypeAdapter;
import com.google.gson.reflect.TypeToken;

public final class JsonAdapterAnnotationTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public JsonAdapterAnnotationTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public TypeAdapter create(Gson gson, TypeToken typeToken) {
        JsonAdapter jsonAdapter = typeToken.getRawType().getAnnotation(JsonAdapter.class);
        if (jsonAdapter == null) {
            return null;
        }
        JsonAdapterAnnotationTypeAdapterFactory jsonAdapterAnnotationTypeAdapterFactory = this;
        return jsonAdapterAnnotationTypeAdapterFactory.getTypeAdapter(jsonAdapterAnnotationTypeAdapterFactory.constructorConstructor, gson, typeToken, jsonAdapter);
    }

    TypeAdapter getTypeAdapter(ConstructorConstructor constructorConstructor, Gson gson, TypeToken typeToken, JsonAdapter jsonAdapter) {
        Object object = constructorConstructor.get(TypeToken.get(jsonAdapter.value())).construct();
        if (object instanceof TypeAdapter) {
            object = (TypeAdapter)object;
        } else if (object instanceof TypeAdapterFactory) {
            object = ((TypeAdapterFactory)object).create(gson, typeToken);
        } else {
            TreeTypeAdapter treeTypeAdapter;
            boolean bl = object instanceof JsonSerializer;
            if (!bl && !(object instanceof JsonDeserializer)) {
                throw new IllegalArgumentException("Invalid attempt to bind an instance of " + object.getClass().getName() + " as a @JsonAdapter for " + typeToken.toString() + ". @JsonAdapter value must be a TypeAdapter, TypeAdapterFactory, JsonSerializer or JsonDeserializer.");
            }
            JsonSerializer jsonSerializer = bl ? (JsonSerializer)object : null;
            object = object instanceof JsonDeserializer ? (JsonDeserializer)object : null;
            TreeTypeAdapter treeTypeAdapter2 = treeTypeAdapter;
            treeTypeAdapter = new TreeTypeAdapter(jsonSerializer, (JsonDeserializer)object, gson, typeToken, null);
            object = treeTypeAdapter2;
        }
        if (object != null && jsonAdapter.nullSafe()) {
            object = ((TypeAdapter)object).nullSafe();
        }
        return object;
    }
}

