/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.network;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.function.Supplier;
import net.mcreator.ars_technica.client.events.ModParticles;
import net.mcreator.ars_technica.client.particles.SpiralDustParticleTypeData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3f;

public class ParticleEffectPacket {
    private final Vec3 position;
    private final ParticleType<?> particleType;
    private final ParticleColor particleColor;

    public ParticleEffectPacket(Vec3 position, ParticleType<?> particleType) {
        this.position = position;
        this.particleType = particleType;
        this.particleColor = ParticleColor.WHITE;
    }

    public ParticleEffectPacket(Vec3 position, ParticleType<?> particleType, ParticleColor particleColor) {
        this.position = position;
        this.particleType = particleType;
        this.particleColor = particleColor;
    }

    public static void encode(ParticleEffectPacket packet, FriendlyByteBuf buf) {
        buf.writeDouble(packet.position.f_82479_);
        buf.writeDouble(packet.position.f_82480_);
        buf.writeDouble(packet.position.f_82481_);
        buf.writeFloat(packet.particleColor.getRed());
        buf.writeFloat(packet.particleColor.getGreen());
        buf.writeFloat(packet.particleColor.getBlue());
        buf.m_130085_(ForgeRegistries.PARTICLE_TYPES.getKey(packet.particleType));
    }

    public static ParticleEffectPacket decode(FriendlyByteBuf buf) {
        Vec3 position = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        int r = Math.round(buf.readFloat() * 255.0f);
        int g = Math.round(buf.readFloat() * 255.0f);
        int b = Math.round(buf.readFloat() * 255.0f);
        ParticleColor color = new ParticleColor(r, g, b);
        ResourceLocation particleId = buf.m_130281_();
        ParticleType particleType = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(particleId);
        return new ParticleEffectPacket(position, particleType, color);
    }

    public static void handle(final ParticleEffectPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection().getReceptionSide().isServer()) {
            ctx.get().setPacketHandled(true);
            return;
        }
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.m_91087_();
                ClientLevel clientWorld = mc.f_91073_;
                if (clientWorld != null && packet.particleType != null) {
                    if (packet.particleType == ParticleTypes.f_123805_) {
                        DustParticleOptions dustOptions = new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f);
                        clientWorld.m_7106_((ParticleOptions)dustOptions, packet.position.f_82479_, packet.position.f_82480_, packet.position.f_82481_, 0.0, 0.0, 0.0);
                    } else if (packet.particleType == ParticleTypes.f_123745_) {
                        clientWorld.m_7106_((ParticleOptions)ParticleTypes.f_123745_, packet.position.f_82479_, packet.position.f_82480_ + (double)0.45f, packet.position.f_82481_, 0.0, 0.0, 0.0);
                    } else if (packet.particleType == ParticleTypes.f_123762_) {
                        clientWorld.m_7106_((ParticleOptions)ParticleTypes.f_123762_, packet.position.f_82479_, packet.position.f_82480_ + 0.25, packet.position.f_82481_, 0.0, 0.0625, 0.0);
                    } else if (packet.particleType == ParticleTypes.f_123759_) {
                        clientWorld.m_7106_((ParticleOptions)ParticleTypes.f_123759_, packet.position.f_82479_, packet.position.f_82480_ + 0.25, packet.position.f_82481_, 0.0, 0.0625, 0.0);
                    } else if (packet.particleType == ModParticles.SPIRAL_DUST_TYPE.get()) {
                        SpiralDustParticleTypeData data = new SpiralDustParticleTypeData((ParticleType<? extends SpiralDustParticleTypeData>)((ParticleType)ModParticles.SPIRAL_DUST_TYPE.get()), packet.particleColor, false);
                        clientWorld.m_7106_((ParticleOptions)data, packet.position.f_82479_, packet.position.f_82480_ + 0.25, packet.position.f_82481_, 0.0, 0.0, 0.0);
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

