/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.registry.PerkRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.datagen.PatchouliProvider;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ApparatusPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.GlyphScribePage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.IPatchouliPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.ImbuementPage;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.PatchouliBuilder;
import com.hollingsworth.arsnouveau.common.datagen.patchouli.TextPage;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import net.mcreator.ars_technica.common.items.threads.PressurePerk;
import net.mcreator.ars_technica.setup.GlyphsRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class ATPatchouliProvider
extends PatchouliProvider {
    public ATPatchouliProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput cache) {
        for (AbstractSpellPart spell : GlyphsRegistry.registeredSpells) {
            this.addGlyphPage(spell);
        }
        this.addPerkPage((IPerk)PressurePerk.INSTANCE);
        for (PatchouliProvider.PatchouliPage patchouliPage : this.pages) {
            this.saveStable(cache, (JsonElement)patchouliPage.build(), patchouliPage.path());
        }
    }

    public void addPerkPage(IPerk perk) {
        PerkItem perkItem = (PerkItem)PerkRegistry.getPerkItemMap().get(perk.getRegistryName());
        PatchouliBuilder builder = new PatchouliBuilder(ARMOR, (ItemLike)perkItem).withIcon((ItemLike)perkItem).withTextPage(perk.getDescriptionKey()).withPage((IPatchouliPage)new ApparatusPage((ItemLike)perkItem)).withSortNum(99);
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(ARMOR, perk.getRegistryName().m_135815_())));
    }

    public PatchouliProvider.PatchouliPage addBasicItem(ItemLike item, ResourceLocation category, IPatchouliPage recipePage) {
        PatchouliBuilder builder = new PatchouliBuilder(category, item.m_5456_().m_5524_()).withIcon((ItemLike)item.m_5456_()).withPage((IPatchouliPage)new TextPage("ars_technica.page." + this.getRegistryName(item.m_5456_()).m_135815_())).withPage(recipePage);
        PatchouliProvider.PatchouliPage page = new PatchouliProvider.PatchouliPage(builder, this.getPath(category, this.getRegistryName(item.m_5456_()).m_135815_()));
        this.pages.add(page);
        return page;
    }

    public void addGlyphPage(AbstractSpellPart spellPart) {
        ResourceLocation category = switch (spellPart.defaultTier().value) {
            case 1 -> GLYPHS_1;
            case 2 -> GLYPHS_2;
            default -> GLYPHS_3;
        };
        PatchouliBuilder builder = new PatchouliBuilder(category, spellPart.getName()).withName("ars_technica.glyph_name." + spellPart.getRegistryName().m_135815_()).withIcon(spellPart.getRegistryName().toString()).withSortNum(spellPart instanceof AbstractCastMethod ? 1 : (spellPart instanceof AbstractEffect ? 2 : 3)).withPage((IPatchouliPage)new TextPage("ars_technica.glyph_desc." + spellPart.getRegistryName().m_135815_())).withPage((IPatchouliPage)new GlyphScribePage(spellPart));
        this.pages.add(new PatchouliProvider.PatchouliPage(builder, this.getPath(category, spellPart.getRegistryName().m_135815_())));
    }

    public String m_6055_() {
        return "Ars Technica Patchouli Datagen";
    }

    ImbuementPage ImbuementPage(ItemLike item) {
        return new ImbuementPage("ars_technica:imbuement_" + this.getRegistryName(item.m_5456_()).m_135815_());
    }

    private ResourceLocation getRegistryName(Item asItem) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)asItem);
    }
}

