/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.packets;

import java.util.function.Supplier;
import net.mcreator.ars_technica.common.api.IModifiableCooldown;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class CustomCooldownPacket {
    private final int cooldownTicks;
    private final BlockPos blockPos;

    public CustomCooldownPacket(int cooldownTicks, BlockPos blockPos) {
        this.cooldownTicks = cooldownTicks;
        this.blockPos = blockPos;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.cooldownTicks);
        buffer.m_130064_(this.blockPos);
    }

    public static CustomCooldownPacket decode(FriendlyByteBuf buffer) {
        int ticks = buffer.readInt();
        BlockPos pos = buffer.m_130135_();
        return new CustomCooldownPacket(ticks, pos);
    }

    public static void handle(CustomCooldownPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            BlockEntity blockEntity = level.m_7702_(packet.blockPos);
            if (blockEntity instanceof IModifiableCooldown) {
                IModifiableCooldown customizable = (IModifiableCooldown)blockEntity;
                customizable.setCooldownTicks(packet.cooldownTicks);
                blockEntity.m_6596_();
            }
        });
        context.setPacketHandled(true);
    }
}

