/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.mcreator.ars_technica.ConfigHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidHelper {
    public static int BLOCK_MAX_FLUID_LEVEL = 8;
    public static int FLUID_MB_MAX_IN_BLOCK = 1000;
    public static int FLUID_TO_MB_MULTIPLIER = FLUID_MB_MAX_IN_BLOCK / BLOCK_MAX_FLUID_LEVEL;

    public static void dumpFluid(FluidStack stack, Level world, Vec3 position, int expansion) {
        AtomicInteger remainingAmount = new AtomicInteger(stack.getAmount());
        AABB searchArea = new AABB(position.f_82479_ - (double)expansion, position.f_82480_ - (double)expansion, position.f_82481_ - (double)expansion, position.f_82479_ + (double)expansion, position.f_82480_ + (double)expansion, position.f_82481_ + (double)expansion);
        FluidHelper.getNearbyFluidTanks(world, searchArea, position).forEach(tank -> {
            int filled = tank.fill(new FluidStack(stack.getFluid(), Math.min(tank.getTankCapacity(0) - tank.getFluidInTank(0).getAmount(), remainingAmount.get())), IFluidHandler.FluidAction.EXECUTE);
            remainingAmount.addAndGet(-filled);
        });
        boolean canPlaceFluids = (Boolean)ConfigHandler.Common.FLUID_CAN_BE_PLACED.get();
        boolean canPlaceSources = (Boolean)ConfigHandler.Common.FLUID_SOURCES_CAN_BE_PLACED.get();
        int maxFluidsToPlace = (Integer)ConfigHandler.Common.FLUID_MAX_PLACEMENTS_PER_FUSE.get();
        if (!canPlaceFluids) {
            return;
        }
        int fluidsPlaced = 0;
        if (remainingAmount.get() > 0) {
            List<BlockPos> airBlocks = FluidHelper.getNearbyAirBlocks(world, searchArea, position);
            for (int i = 0; i < airBlocks.size(); ++i) {
                BlockPos airPos = airBlocks.get(i);
                if (remainingAmount.get() <= 0 || fluidsPlaced >= maxFluidsToPlace) break;
                if (!world.m_8055_(airPos).m_60795_()) continue;
                int amountToPlace = Math.min(remainingAmount.get(), FLUID_MB_MAX_IN_BLOCK);
                int blockStateAmount = amountToPlace / FLUID_TO_MB_MULTIPLIER;
                boolean shouldPlaceSource = amountToPlace == FLUID_MB_MAX_IN_BLOCK;
                Fluid fluid = canPlaceSources && shouldPlaceSource ? com.simibubi.create.foundation.fluid.FluidHelper.convertToStill((Fluid)stack.getFluid()) : stack.getFluid();
                BlockState fluidBlockState = fluid.m_76145_().m_76188_();
                if (!shouldPlaceSource && fluidBlockState.m_61138_((Property)BlockStateProperties.f_61422_)) {
                    fluidBlockState = (BlockState)fluidBlockState.m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(blockStateAmount));
                }
                world.m_7731_(airPos, fluidBlockState, 18);
                ++fluidsPlaced;
                remainingAmount.addAndGet(-amountToPlace);
            }
        }
    }

    private static Stream<IFluidHandler> getNearbyFluidTanks(Level world, AABB searchArea, Vec3 position) {
        ArrayList handlers = new ArrayList();
        BlockPos.m_121921_((AABB)searchArea).forEach(pos -> {
            IFluidHandler handler;
            BlockEntity be = world.m_7702_(pos);
            if (be != null && be.getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent() && (handler = FluidHelper.getHandlerFromCap(pos, world, 0)) != null && (handler.getFluidInTank(0).isEmpty() || handler.getFluidInTank(0).getAmount() <= handler.getTankCapacity(0) - FLUID_MB_MAX_IN_BLOCK)) {
                handlers.add(handler);
            }
        });
        return handlers.stream();
    }

    private static List<BlockPos> getNearbyAirBlocks(Level world, AABB searchArea, Vec3 position) {
        ArrayList<BlockPos> airBlocks = new ArrayList<BlockPos>();
        int minX = (int)searchArea.f_82288_;
        int maxX = (int)searchArea.f_82291_;
        int minY = (int)searchArea.f_82289_;
        int maxY = (int)searchArea.f_82292_;
        int minZ = (int)searchArea.f_82290_;
        int maxZ = (int)searchArea.f_82293_;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    Block block = world.m_8055_(currentPos).m_60734_();
                    if (block != Blocks.f_50016_) continue;
                    airBlocks.add(currentPos);
                }
            }
        }
        airBlocks.sort(Comparator.comparingDouble(pos -> position.m_82557_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()))));
        return airBlocks;
    }

    @Nullable
    public static IFluidHandler getHandlerFromCap(BlockPos pos, Level level, int sideOrdinal) {
        BlockEntity be = level.m_7702_(pos);
        Direction side = sideOrdinal < 0 ? null : Direction.values()[sideOrdinal];
        return be != null && be.getCapability(ForgeCapabilities.FLUID_HANDLER, side).isPresent() && be.getCapability(ForgeCapabilities.FLUID_HANDLER, side).resolve().isPresent() ? (IFluidHandler)be.getCapability(ForgeCapabilities.FLUID_HANDLER, side).resolve().get() : null;
    }
}

