/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.entity;

import java.util.Comparator;
import java.util.List;
import net.mcreator.ars_technica.common.entity.Colorable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.object.Color;

public abstract class ArcaneProcessEntity
extends Entity
implements Colorable {
    private static int TICKS_TO_PROCESS_RATIO = 20;
    private static int TICKS_TO_RESET_RATIO = TICKS_TO_PROCESS_RATIO * 2;
    protected double distanceToItem = 1.0;
    protected int maxToProcess = 1;
    protected float speed = 2.0f;
    protected int amountProcessed = 0;
    protected final List<ItemEntity> processableEntities;
    protected ItemEntity currentItem;
    protected ItemEntity currentOutput;
    protected int tickCount;
    protected Color color;
    protected Level world;
    protected static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(ArcaneProcessEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(ArcaneProcessEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    private int getTicksToPress() {
        return Math.round((float)TICKS_TO_PROCESS_RATIO / this.speed);
    }

    private int getTicksToReset() {
        return Math.round((float)TICKS_TO_RESET_RATIO / this.speed);
    }

    protected void setSpeed(float speed) {
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(speed));
    }

    protected void setColor(Color color) {
        this.f_19804_.m_135381_(COLOR, (Object)color.getColor());
    }

    public ArcaneProcessEntity(EntityType<?> entityType, Vec3 position, Level world, int maxToProcess, float speed, Color color, List<ItemEntity> processableEntities) {
        super(entityType, world);
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.maxToProcess = maxToProcess;
        this.speed = speed;
        this.setSpeed(speed);
        this.setColor(color);
        this.processableEntities = processableEntities;
        this.world = world;
    }

    public ArcaneProcessEntity(EntityType<? extends ArcaneProcessEntity> entityType, Level world) {
        super(entityType, world);
        this.world = world;
        this.processableEntities = null;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(2.0f));
        this.f_19804_.m_135372_(COLOR, (Object)0);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (SPEED.equals(key)) {
            this.speed = ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
        }
        if (COLOR.equals(key)) {
            this.color = new Color(((Integer)this.f_19804_.m_135370_(COLOR)).intValue());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.currentItem == null || this.currentItem.m_213877_()) {
            this.findNextItem();
        }
        if (!(this.amountProcessed != this.maxToProcess && this.currentItem != null || this.world.f_46443_)) {
            this.m_146870_();
        }
        this.handleProcessLogic();
        if (this.tickCount >= this.getTicksToReset()) {
            if (this.currentItem != null && !this.currentItem.m_213877_()) {
                this.moveToItem();
            }
            this.tickCount = 0;
        }
        ++this.tickCount;
    }

    protected void growOutput(ItemEntity input, ItemStack outputStack) {
        if (this.currentOutput != null && this.currentOutput.m_32055_().m_41720_() == outputStack.m_41720_() && this.currentOutput.m_32055_().m_41613_() < this.currentOutput.m_32055_().m_41741_()) {
            ItemStack currentOutputItem = this.currentOutput.m_32055_();
            ItemStack newStack = currentOutputItem.m_255036_(currentOutputItem.m_41613_() + 1);
            this.currentOutput.m_146870_();
            this.currentOutput = new ItemEntity(this.world, input.m_20185_(), input.m_20186_(), input.m_20189_(), newStack);
            this.world.m_7967_((Entity)this.currentOutput);
        } else {
            this.currentOutput = new ItemEntity(this.world, input.m_20185_(), input.m_20186_(), input.m_20189_(), outputStack);
            this.world.m_7967_((Entity)this.currentOutput);
        }
    }

    protected void moveToItem() {
        this.m_146884_(this.currentItem.m_20182_().m_82520_(0.0, this.distanceToItem, 0.0));
    }

    private void findNextItem() {
        if (this.processableEntities == null) {
            return;
        }
        this.currentItem = this.processableEntities.stream().filter(x -> x != null && !x.m_213877_() && x.m_32055_().m_41613_() > 0).min(Comparator.comparingDouble(e -> e.m_20182_().m_82554_(this.m_20318_(1.0f)))).orElse(null);
    }

    private void handleProcessLogic() {
        if (this.currentItem != null && this.tickCount == this.getTicksToPress() && !this.world.m_5776_()) {
            if (this.currentItem.m_213877_()) {
                this.currentItem = null;
            } else {
                this.process(this.currentItem);
            }
        }
    }

    protected abstract void process(ItemEntity var1);

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("Speed")) {
            this.speed = compound.m_128457_("Speed");
            this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(this.speed));
        }
        if (compound.m_128441_("Color")) {
            this.color = new Color(compound.m_128451_("Color"));
            this.f_19804_.m_135381_(COLOR, (Object)this.color.getColor());
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_("Speed", this.speed);
        compound.m_128405_("Color", this.color.getColor());
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public double getAlpha() {
        return 1.0;
    }
}

