/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ars_technica.common.entity;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import java.util.List;
import java.util.Optional;
import net.mcreator.ars_technica.common.entity.ArcaneProcessEntity;
import net.mcreator.ars_technica.common.helpers.RecipeHelpers;
import net.mcreator.ars_technica.setup.EntityRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ArcanePolishEntity
extends ArcaneProcessEntity
implements GeoEntity {
    protected double distanceToItem = 0.5;
    AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public ArcanePolishEntity(Vec3 position, Level world, int maxAmountToPolish, float speed, Color color, List<ItemEntity> polishableEntities) {
        super((EntityType)EntityRegistry.ARCANE_POLISH_ENTITY.get(), position, world, maxAmountToPolish, speed, color, polishableEntities);
    }

    public ArcanePolishEntity(EntityType<ArcanePolishEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.tickCount == 1) {
            AllSoundEvents.SANDING_SHORT.playOnServer(this.world, (Vec3i)this.m_20183_(), 0.5f, 0.75f + this.speed / 8.0f);
        }
    }

    @Override
    protected void process(ItemEntity item) {
        this.polish(item);
    }

    private void polish(ItemEntity item) {
        ItemStack currentStack = item.m_32055_();
        if (currentStack.m_41613_() > 0) {
            Optional<SandPaperPolishingRecipe> polishingRecipe = RecipeHelpers.getPolishingRecipeForItemStack(currentStack, this.world);
            if (polishingRecipe.isEmpty()) {
                this.processableEntities.remove(this.currentItem);
                this.currentItem = null;
                return;
            }
            Vec3 currentPos = this.currentItem.m_20318_(1.0f);
            this.m_146884_(currentPos.m_82520_(Math.random() / 8.0, this.distanceToItem, Math.random() / 8.0));
            RegistryAccess registryAccess = this.world.m_9598_();
            SandPaperPolishingRecipe recipe = polishingRecipe.get();
            ItemStack polishedStack = recipe.m_8043_(registryAccess);
            polishedStack.m_41764_(1);
            this.growOutput(item, polishedStack);
            currentStack.m_41774_(1);
            ++this.amountProcessed;
            AllSoundEvents.CONTROLLER_PUT.playOnServer(this.world, (Vec3i)this.m_20183_(), 0.75f, 1.5f + this.speed / 16.0f);
        }
        if (currentStack.m_41613_() <= 0) {
            this.currentItem = null;
        }
    }

    @Override
    protected void moveToItem() {
        this.m_146884_(this.currentItem.m_20182_().m_82520_(0.0, this.distanceToItem, 0.0));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "polishController", 0, this::polishAnimationPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    private PlayState polishAnimationPredicate(AnimationState<?> event) {
        event.getController().setAnimation(RawAnimation.begin().thenPlay("polish"));
        event.getController().setAnimationSpeed((double)this.speed);
        return PlayState.CONTINUE;
    }
}

