/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.caster_tools;

import alexthw.ars_elemental.client.caster_tools.SpellHornRenderer;
import alexthw.ars_elemental.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpellHorn
extends Item
implements GeoItem,
ISpellModifierItem,
ICasterTool {
    public AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    RawAnimation spin = RawAnimation.begin().thenLoop("wand_gem_spin");

    public SpellHorn(Item.Properties properties) {
        super(properties);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 20, animationState -> animationState.setAndContinue(this.spin))});
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        pPlayer.m_6672_(pUsedHand);
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void m_5551_(@NotNull ItemStack stack, @NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, int remainingTicks) {
        float j = this.m_8105_(stack) - remainingTicks;
        if (j >= (float)this.getMinUseDuration() && pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            float aoeMult = 0.5f + j / (float)this.getMinUseDuration();
            if (pLevel instanceof ServerLevel) {
                ISpellCaster caster = this.getSpellCaster(stack);
                SpellResolver resolver = new SpellResolver(new SpellContext(pLevel, caster.getSpell(), pLivingEntity, (IWrappedCaster)new LivingCaster(pLivingEntity)));
                Predicate<Entity> filter = GlyphEffectUtil.getFilterPredicate(caster.getSpell(), e -> e instanceof LivingEntity);
                for (Entity l : pLevel.m_6249_((Entity)null, new AABB(player.m_20183_()).m_82400_((double)aoeMult), filter)) {
                    resolver.onResolveEffect(pLevel, (HitResult)new EntityHitResult(l));
                }
                resolver.expendMana();
            }
            if (j + 50.0f >= (float)this.getMaxUseDuration()) {
                player.m_7292_(new MobEffectInstance((MobEffect)ModPotions.SPELL_DAMAGE_EFFECT.get(), this.getMaxUseDuration() * 4));
            }
            SpellHorn.play(pLevel, player, aoeMult * 16.0f);
            player.m_36335_().m_41524_((Item)this, 200);
        }
    }

    public void m_5929_(@NotNull Level level, @NotNull LivingEntity player, @NotNull ItemStack stack, int count) {
        if (this.m_8105_(stack) - count > this.getMaxUseDuration()) {
            player.m_21253_();
        }
    }

    private static void play(Level level, Player player, float volume) {
        SoundEvent soundevent = (SoundEvent)SoundEvents.f_12355_.get();
        level.m_6269_(player, (Entity)player, soundevent, SoundSource.RECORDS, volume, 1.0f);
        level.m_214171_(GameEvent.f_223696_, player.m_20182_(), GameEvent.Context.m_223717_((Entity)player));
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 72000;
    }

    public int getMaxUseDuration() {
        return 200;
    }

    public int getMinUseDuration() {
        return 10;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.TOOT_HORN;
    }

    public boolean setSpell(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        ArrayList recipe = new ArrayList();
        caster.setSpell(spell);
        return true;
    }

    public SpellStats.Builder applyItemModifiers(ItemStack stack, SpellStats.Builder builder, AbstractSpellPart spellPart, HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellContext spellContext) {
        builder.addDurationModifier(1.0);
        return builder;
    }

    public boolean isScribedSpellValid(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return spell.recipe.stream().noneMatch(s -> s instanceof AbstractCastMethod);
    }

    public void sendInvalidMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.m_237115_((String)"ars_nouveau.wand.invalid"));
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new SpellHornRenderer();

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public void m_7373_(@NotNull ItemStack stack, @javax.annotation.Nullable Level worldIn, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        this.getInformation(stack, worldIn, tooltip2, flagIn);
        super.m_7373_(stack, worldIn, tooltip2, flagIn);
    }
}

