/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.services.Services;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class RibbitPlayMusicGoal
extends class_1352 {
    private final RibbitEntity ribbit;
    private final double speedModifier;
    private final int minRequiredPlayTicks;
    private final int maxRequiredPlayTicks;
    private int requiredPlayTicks;
    private class_11 path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;

    public RibbitPlayMusicGoal(RibbitEntity ribbit, double speedModifier, int minRequiredPlayTicks, int maxRequiredPlayTicks) {
        this.ribbit = ribbit;
        this.speedModifier = speedModifier;
        this.minRequiredPlayTicks = minRequiredPlayTicks;
        this.maxRequiredPlayTicks = maxRequiredPlayTicks;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.ribbit.method_37908().method_23886()) {
            return false;
        }
        this.ribbit.method_37908().method_18467(RibbitEntity.class, this.ribbit.method_5829().method_1009(64.0, 16.0, 64.0)).stream().filter(RibbitEntity::getPlayingInstrument).forEach(ribbit -> {
            if (ribbit.getMasterRibbit() != null) {
                this.ribbit.setMasterRibbit(ribbit.getMasterRibbit());
            }
        });
        if (this.ribbit.getMasterRibbit() != null && this.ribbit.getMasterRibbit().isBandFull()) {
            this.ribbit.setMasterRibbit(null);
            return false;
        }
        return !this.ribbit.isUmbrellaFalling() && !this.ribbit.method_29504();
    }

    public boolean method_6266() {
        return !this.ribbit.isUmbrellaFalling() && !this.ribbit.method_29504() && (this.ribbit.getPlayingInstrument() || this.ribbit.getMasterRibbit() == null || !this.ribbit.getMasterRibbit().isBandFull());
    }

    public void method_6269() {
        this.ribbit.setInstrument(RibbitInstrumentModule.NONE);
        if (this.ribbit.getMasterRibbit() != null) {
            float waterModifier = this.ribbit.method_5799() ? 2.0f : 1.0f;
            this.path = this.ribbit.method_5942().method_6349((class_1297)this.ribbit.getMasterRibbit(), 0);
            this.ribbit.method_5942().method_6334(this.path, this.speedModifier * (double)waterModifier);
        }
        if (this.ribbit.getMasterRibbit() == null) {
            this.ribbit.setMasterRibbit(this.ribbit);
        }
        this.requiredPlayTicks = this.ribbit.method_6051().method_43051(this.minRequiredPlayTicks, this.maxRequiredPlayTicks);
    }

    public void method_6270() {
        if (this.ribbit.getMasterRibbit() != null) {
            this.ribbit.getMasterRibbit().removeRibbitFromPlayingMusic(this.ribbit);
            this.ribbit.getMasterRibbit().removeBandMember(this.ribbit.getRibbitData().getInstrument());
        }
        if (this.ribbit.isMasterRibbit()) {
            this.ribbit.findNewMasterRibbit();
        }
        this.ribbit.setPlayingInstrument(false);
        this.ribbit.setTicksPlayingMusic(0);
        this.ribbit.setInstrument(RibbitInstrumentModule.NONE);
    }

    public boolean method_38846() {
        return true;
    }

    public boolean method_6267() {
        return this.ribbit.method_6065() != null || this.ribbit.method_40071() || this.ribbit.method_5809() || this.ribbit.getTicksPlayingMusic() > this.requiredPlayTicks;
    }

    public void method_6268() {
        if (this.ribbit.getMasterRibbit() == null || this.ribbit.getMasterRibbit().method_29504() || !this.ribbit.getMasterRibbit().getPlayingInstrument()) {
            this.ribbit.method_37908().method_18467(RibbitEntity.class, this.ribbit.method_5829().method_1009(64.0, 16.0, 64.0)).stream().filter(RibbitEntity::getPlayingInstrument).forEach(ribbit -> {
                if (ribbit.getMasterRibbit() != null) {
                    this.ribbit.setMasterRibbit(ribbit.getMasterRibbit());
                }
            });
            if (this.ribbit.getMasterRibbit() != null && this.ribbit.getMasterRibbit().isBandFull()) {
                this.ribbit.setMasterRibbit(null);
                return;
            }
            if (this.ribbit.getMasterRibbit() == null) {
                this.ribbit.setMasterRibbit(this.ribbit);
            }
        }
        RibbitEntity masterRibbit = this.ribbit.getMasterRibbit();
        this.ribbit.method_5988().method_6226((class_1297)masterRibbit, 30.0f, 30.0f);
        double d = this.ribbit.method_5649(masterRibbit.method_23317(), masterRibbit.method_23318(), masterRibbit.method_23321());
        this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
        float waterModifier = this.ribbit.method_5799() ? 2.0f : 1.0f;
        this.ribbit.method_5942().method_6344(this.speedModifier * (double)waterModifier);
        if (!this.ribbit.getPlayingInstrument() && this.ticksUntilNextPathRecalculation == 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || masterRibbit.method_5649(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.ribbit.method_6051().method_43057() < 0.05f)) {
            this.pathedTargetX = masterRibbit.method_23317();
            this.pathedTargetY = masterRibbit.method_23318();
            this.pathedTargetZ = masterRibbit.method_23321();
            this.ticksUntilNextPathRecalculation = 4 + this.ribbit.method_6051().method_43048(7);
            if (d > 1024.0) {
                this.ticksUntilNextPathRecalculation += 10;
            } else if (d > 256.0) {
                this.ticksUntilNextPathRecalculation += 5;
            }
            if (!this.ribbit.method_5942().method_6335((class_1297)masterRibbit, this.speedModifier * (double)waterModifier)) {
                this.ticksUntilNextPathRecalculation += 15;
            }
            this.ticksUntilNextPathRecalculation = this.method_38847(this.ticksUntilNextPathRecalculation);
        }
        if (!this.ribbit.getPlayingInstrument() && d <= 9.0 && !this.ribbit.method_5799()) {
            if (this.ribbit.getRibbitData().getInstrument() == RibbitInstrumentModule.NONE) {
                RibbitInstrument instrument = RibbitInstrumentModule.getRandomInstrument(masterRibbit.getBandMembers());
                if (instrument == null) {
                    return;
                }
                this.ribbit.setInstrument(instrument);
                this.ribbit.getMasterRibbit().addBandMember(this.ribbit.getRibbitData().getInstrument());
            }
            this.ribbit.method_5942().method_6340();
            this.ribbit.setPlayingInstrument(true);
            this.ribbit.setTicksPlayingMusic(0);
            Services.PLATFORM.onRibbitStartMusicGoal((class_3218)this.ribbit.method_37908(), this.ribbit, masterRibbit);
            masterRibbit.addRibbitToPlayingMusic(this.ribbit);
        }
        if (this.ribbit.getPlayingInstrument()) {
            this.ribbit.method_5942().method_6340();
            if (d > 9.0 || this.ribbit.method_5799()) {
                this.ribbit.setPlayingInstrument(false);
                masterRibbit.removeBandMember(this.ribbit.getRibbitData().getInstrument());
                this.ribbit.setInstrument(RibbitInstrumentModule.NONE);
                masterRibbit.removeRibbitFromPlayingMusic(this.ribbit);
                this.ribbit.setTicksPlayingMusic(0);
                return;
            }
            if (this.ribbit.equals((Object)masterRibbit)) {
                HashSet<class_1657> playersHearingMusic = new HashSet<class_1657>(this.ribbit.getPlayersHearingMusic());
                List playersInRange = this.ribbit.method_37908().method_8390(class_1657.class, this.ribbit.method_5829().method_1009(32.0, 32.0, 32.0), class_1301.field_6157);
                for (class_1657 player2 : playersInRange) {
                    if (playersHearingMusic.contains(player2)) continue;
                    playersHearingMusic.add(player2);
                    Services.PLATFORM.onPlayerEnterBandRange((class_3222)player2, (class_3218)this.ribbit.method_37908(), this.ribbit);
                }
                playersHearingMusic.removeIf(player -> {
                    if (player.method_31481() || !playersInRange.contains(player)) {
                        Services.PLATFORM.onPlayerExitBandRange((class_3222)player, (class_3218)this.ribbit.method_37908(), this.ribbit);
                        return true;
                    }
                    return false;
                });
                this.ribbit.setPlayersHearingMusic(playersHearingMusic);
            }
            this.ribbit.setTicksPlayingMusic(this.ribbit.getTicksPlayingMusic() + 1);
        }
    }
}

