/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.cicada.api.conversation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import nl.enjarai.cicada.Cicada;
import nl.enjarai.cicada.api.conversation.Conversation;
import nl.enjarai.cicada.api.conversation.Line;
import nl.enjarai.cicada.api.conversation.Logger;
import nl.enjarai.cicada.api.conversation.SimpleLine;
import nl.enjarai.cicada.api.conversation.WeightedConversation;
import nl.enjarai.cicada.api.conversation.conditions.LineCondition;
import nl.enjarai.cicada.api.conversation.yaml.YamlConversation;
import nl.enjarai.cicada.api.conversation.yaml.YamlConversationFile;
import nl.enjarai.cicada.api.conversation.yaml.YamlLine;
import nl.enjarai.cicada.api.util.CicadaEntrypoint;
import nl.enjarai.cicada.api.util.JsonSource;
import nl.enjarai.cicada.api.util.ProperLogger;
import nl.enjarai.cicada.api.util.YamlSource;
import nl.enjarai.cicada.api.util.random.RandomUtil;

public class ConversationManager
implements Logger {
    private static final ExecutorService THREAD_POOL = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("Cicada thread %d").setThreadFactory(Executors.defaultThreadFactory()).setDaemon(true).build());
    private final Map<JsonSource, Consumer<String>> jsonSources = new HashMap<JsonSource, Consumer<String>>();
    private final List<YamlSource> yamlSources = new ArrayList<YamlSource>();
    private final Map<String, Conversation> conversations = new HashMap<String, Conversation>();
    private final List<YamlConversation> yamlConversations = new ArrayList<YamlConversation>();

    public static ExecutorService getThreadPool() {
        return THREAD_POOL;
    }

    public void init() {
        FabricLoader.getInstance().getEntrypoints("cicada", CicadaEntrypoint.class).forEach(entrypoint -> entrypoint.registerConversations(this));
    }

    public void load() {
        this.getConversationsFuture(this.jsonSources);
        this.getYamlConversationsFuture(this.yamlSources);
        this.conversations.values().forEach(Conversation::complete);
    }

    public void run() {
        ArrayList options = new ArrayList();
        this.conversations.values().stream().filter(Conversation::shouldRun).forEach(c -> options.add(new WeightedConversation(c::run, c.getWeight())));
        this.yamlConversations.stream().filter(YamlConversation::allRequiredMods).forEach(c -> options.add(new WeightedConversation(() -> c.play(this), c.priority())));
        RandomUtil.chooseWeighted(options).ifPresent(c -> c.executor().run());
    }

    public void registerSource(JsonSource source, Consumer<String> logger) {
        this.jsonSources.put(source, logger);
    }

    public void registerSource(YamlSource source) {
        this.yamlSources.add(source);
    }

    @Deprecated
    public void registerUrlSource(String url, Consumer<String> logger) {
        this.registerSource(JsonSource.fromUrl(url), logger);
    }

    @Deprecated
    public void registerFileSource(Path path, Consumer<String> logger) {
        this.registerSource(JsonSource.fromFile(path), logger);
    }

    public Conversation getOrCreateConversation(String id) {
        Conversation conversation = this.conversations.get(id);
        if (conversation == null) {
            conversation = new Conversation(this);
            this.conversations.put(id, conversation);
        }
        return conversation;
    }

    protected void onLoadError(Exception e) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            Cicada.LOGGER.info("Failed to load conversation source", (Throwable)e);
        }
    }

    private void getConversationsFuture(Map<JsonSource, Consumer<String>> sources) {
        sources.forEach((key, value) -> key.getSafely(this::onLoadError).ifPresent(json -> {
            try {
                this.decodeSideJson((JsonObject)json, line -> {
                    if (line instanceof SimpleLine) {
                        SimpleLine simpleLine = (SimpleLine)line;
                        simpleLine.setSourceLogger((Consumer<String>)value);
                    }
                });
            }
            catch (Exception e) {
                this.onLoadError(e);
            }
        }));
    }

    private void getYamlConversationsFuture(List<YamlSource> sources) {
        sources.forEach(s -> {
            Optional<Map<Object, Object>> test = s.getSafely(this::onLoadError);
            test.ifPresent(yaml -> {
                try {
                    YamlConversationFile file = this.decodeConversationsYaml((Map<Object, Object>)yaml);
                    Collection<YamlConversation> convo = file.conversations().values();
                    this.yamlConversations.addAll(convo);
                }
                catch (Exception e) {
                    this.onLoadError(e);
                }
            });
        });
    }

    private void decodeSideJson(JsonObject json, Consumer<Line> lineModifier) {
        String modId = json.has("mod_id") ? json.get("mod_id").getAsString() : null;
        json.getAsJsonObject("conversations").entrySet().forEach(entry -> {
            Conversation conversation = this.getOrCreateConversation((String)entry.getKey());
            JsonObject conversationJson = ((JsonElement)entry.getValue()).getAsJsonObject();
            if (conversationJson.has("condition")) {
                conversation.addCondition((LineCondition)LineCondition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)conversationJson.get("condition")).getOrThrow(false, string -> {}));
            }
            if (conversationJson.has("priority")) {
                JsonObject priority = conversationJson.getAsJsonObject("priority");
                int convoPriority = priority.get("priority").getAsInt();
                int convoPriorityOverride = priority.has("override") ? priority.get("override").getAsInt() : 100;
                conversation.addPriority(convoPriority, convoPriorityOverride);
            }
            conversationJson.getAsJsonArray("lines").forEach(jsonElement -> {
                JsonObject lineJson = jsonElement.getAsJsonObject();
                SimpleLine line = (SimpleLine)SimpleLine.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)lineJson).getOrThrow(false, string -> {});
                line.setConversation(conversation);
                lineModifier.accept(line);
                conversation.addLine(line);
            });
            conversation.addParticipantCount(1);
            conversation.addParticipant(modId);
        });
    }

    private YamlConversationFile decodeConversationsYaml(Map<Object, Object> yaml) {
        ImmutableMap.Builder conversations = ImmutableMap.builder();
        for (Map.Entry conversation : ((Map)yaml.get("conversations")).entrySet()) {
            String key = (String)conversation.getKey();
            Integer priority = (Integer)((Map)conversation.getValue()).get("priority");
            List<YamlLine> lines = this.decodeYamlLines((List)((Map)conversation.getValue()).get("lines"));
            conversations.put((Object)key, (Object)new YamlConversation(lines, priority.intValue()));
        }
        return new YamlConversationFile((Map<String, YamlConversation>)conversations.build());
    }

    private List<YamlLine> decodeYamlLines(List<Map<String, Object>> lines) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Map<String, Object> line : lines) {
            if (line.containsKey("extend")) {
                result.add((Object)new YamlLine(null, null, this.decodeYamlLines((List)line.get("extend"))));
                continue;
            }
            String mod = (String)line.get("mod");
            String text = null;
            if (line.containsKey("text")) {
                text = (String)line.get("text");
            }
            result.add((Object)new YamlLine(mod, text, null));
        }
        return result.build();
    }

    @Override
    public void log(String mod, String message) {
        ProperLogger.getLogger(mod).info(message);
    }
}

