/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.gson.JsonObject;
import com.simibubi.create.foundation.ponder.PonderRegistry;
import com.simibubi.create.foundation.ponder.PonderStoryBoardEntry;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.infrastructure.ponder.PonderIndex;
import com.tterrag.registrate.AbstractRegistrate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1074;
import net.minecraft.class_2960;

public class PonderLocalization {
    static final Map<class_2960, String> SHARED = new HashMap<class_2960, String>();
    static final Map<class_2960, Couple<String>> TAG = new HashMap<class_2960, Couple<String>>();
    static final Map<class_2960, String> CHAPTER = new HashMap<class_2960, String>();
    static final Map<class_2960, Map<String, String>> SPECIFIC = new HashMap<class_2960, Map<String, String>>();
    public static final String LANG_PREFIX = "ponder.";
    private static boolean sceneLangGenerated = false;

    public static void registerShared(class_2960 key, String enUS) {
        SHARED.put(key, enUS);
    }

    public static void registerTag(class_2960 key, String enUS, String description) {
        TAG.put(key, Couple.create(enUS, description));
    }

    public static void registerChapter(class_2960 key, String enUS) {
        CHAPTER.put(key, enUS);
    }

    public static void registerSpecific(class_2960 sceneId, String key, String enUS) {
        SPECIFIC.computeIfAbsent(sceneId, $ -> new HashMap()).put(key, enUS);
    }

    protected static String langKeyForShared(class_2960 k) {
        return k.method_12836() + ".ponder.shared." + k.method_12832();
    }

    protected static String langKeyForTag(class_2960 k) {
        return k.method_12836() + ".ponder.tag." + k.method_12832();
    }

    protected static String langKeyForTagDescription(class_2960 k) {
        return k.method_12836() + ".ponder.tag." + k.method_12832() + ".description";
    }

    protected static String langKeyForChapter(class_2960 k) {
        return k.method_12836() + ".ponder.chapter." + k.method_12832();
    }

    protected static String langKeyForSpecific(class_2960 sceneId, String k) {
        return sceneId.method_12836() + ".ponder." + sceneId.method_12832() + "." + k;
    }

    public static String getShared(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return SHARED.containsKey(key) ? SHARED.get(key) : "unregistered shared entry: " + key;
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForShared(key), (Object[])new Object[0]);
    }

    public static String getTag(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return TAG.containsKey(key) ? (String)TAG.get(key).getFirst() : "unregistered tag entry: " + key;
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForTag(key), (Object[])new Object[0]);
    }

    public static String getTagDescription(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return TAG.containsKey(key) ? (String)TAG.get(key).getSecond() : "unregistered tag entry: " + key;
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForTagDescription(key), (Object[])new Object[0]);
    }

    public static String getChapter(class_2960 key) {
        if (PonderIndex.editingModeActive()) {
            return CHAPTER.containsKey(key) ? CHAPTER.get(key) : "unregistered chapter entry: " + key;
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForChapter(key), (Object[])new Object[0]);
    }

    public static String getSpecific(class_2960 sceneId, String k) {
        if (PonderIndex.editingModeActive()) {
            return SPECIFIC.get(sceneId).get(k);
        }
        return class_1074.method_4662((String)PonderLocalization.langKeyForSpecific(sceneId, k), (Object[])new Object[0]);
    }

    public static void generateSceneLang() {
        if (sceneLangGenerated) {
            return;
        }
        sceneLangGenerated = true;
        PonderRegistry.ALL.forEach((id, list) -> {
            for (int i = 0; i < list.size(); ++i) {
                PonderRegistry.compileScene(i, (PonderStoryBoardEntry)list.get(i), null);
            }
        });
    }

    public static void provideLang(String namespace, BiConsumer<String, String> consumer) {
        SHARED.forEach((k, v) -> {
            if (k.method_12836().equals(namespace)) {
                consumer.accept(PonderLocalization.langKeyForShared(k), (String)v);
            }
        });
        TAG.forEach((k, v) -> {
            if (k.method_12836().equals(namespace)) {
                consumer.accept(PonderLocalization.langKeyForTag(k), (String)v.getFirst());
                consumer.accept(PonderLocalization.langKeyForTagDescription(k), (String)v.getSecond());
            }
        });
        CHAPTER.forEach((k, v) -> {
            if (k.method_12836().equals(namespace)) {
                consumer.accept(PonderLocalization.langKeyForChapter(k), (String)v);
            }
        });
        SPECIFIC.entrySet().stream().filter(entry -> ((class_2960)entry.getKey()).method_12836().equals(namespace)).sorted(Map.Entry.comparingByKey()).forEach(entry -> ((Map)entry.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(subEntry -> consumer.accept(PonderLocalization.langKeyForSpecific((class_2960)entry.getKey(), (String)subEntry.getKey()), (String)subEntry.getValue())));
    }

    @Deprecated(forRemoval=true)
    public static void record(String namespace, JsonObject object) {
        PonderLocalization.provideLang(namespace, (arg_0, arg_1) -> ((JsonObject)object).addProperty(arg_0, arg_1));
    }

    public static void provideRegistrateLang(AbstractRegistrate<?> registrate) {
        PonderLocalization.generateSceneLang();
        PonderLocalization.provideLang(registrate.getModid(), (arg_0, arg_1) -> registrate.addRawLang(arg_0, arg_1));
    }
}

