/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Function;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import org.apache.commons.lang3.tuple.Pair;

public abstract class ValueBoxTransform {
    protected float scale = this.getScale();

    public abstract class_243 getLocalOffset(class_2680 var1);

    public abstract void rotate(class_2680 var1, class_4587 var2);

    public boolean testHit(class_2680 state, class_243 localHit) {
        class_243 offset = this.getLocalOffset(state);
        if (offset == null) {
            return false;
        }
        return localHit.method_1022(offset) < (double)(this.scale / 2.0f);
    }

    public void transform(class_2680 state, class_4587 ms) {
        class_243 position = this.getLocalOffset(state);
        if (position == null) {
            return;
        }
        ms.method_22904(position.field_1352, position.field_1351, position.field_1350);
        this.rotate(state, ms);
        ms.method_22905(this.scale, this.scale, this.scale);
    }

    public boolean shouldRender(class_2680 state) {
        return !state.method_26215() && this.getLocalOffset(state) != null;
    }

    public int getOverrideColor() {
        return -1;
    }

    protected class_243 rotateHorizontally(class_2680 state, class_243 vec) {
        float yRot = 0.0f;
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            yRot = AngleHelper.horizontalAngle((class_2350)state.method_11654((class_2769)class_2741.field_12525));
        }
        if (state.method_28498((class_2769)class_2741.field_12481)) {
            yRot = AngleHelper.horizontalAngle((class_2350)state.method_11654((class_2769)class_2741.field_12481));
        }
        return VecHelper.rotateCentered(vec, yRot, class_2350.class_2351.field_11052);
    }

    public float getScale() {
        return 0.5f;
    }

    public float getFontScale() {
        return 0.015625f;
    }

    public static abstract class Sided
    extends ValueBoxTransform {
        protected class_2350 direction = class_2350.field_11036;

        public Sided fromSide(class_2350 direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public class_243 getLocalOffset(class_2680 state) {
            class_243 location = this.getSouthLocation();
            location = VecHelper.rotateCentered(location, AngleHelper.horizontalAngle(this.getSide()), class_2350.class_2351.field_11052);
            location = VecHelper.rotateCentered(location, AngleHelper.verticalAngle(this.getSide()), class_2350.class_2351.field_11048);
            return location;
        }

        protected abstract class_243 getSouthLocation();

        @Override
        public void rotate(class_2680 state, class_4587 ms) {
            float yRot = AngleHelper.horizontalAngle(this.getSide()) + 180.0f;
            float xRot = this.getSide() == class_2350.field_11036 ? 90.0f : (this.getSide() == class_2350.field_11033 ? 270.0f : 0.0f);
            ((TransformStack)TransformStack.cast((class_4587)ms).rotateY((double)yRot)).rotateX((double)xRot);
        }

        @Override
        public boolean shouldRender(class_2680 state) {
            return super.shouldRender(state) && this.isSideActive(state, this.getSide());
        }

        @Override
        public boolean testHit(class_2680 state, class_243 localHit) {
            return this.isSideActive(state, this.getSide()) && super.testHit(state, localHit);
        }

        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            return true;
        }

        public class_2350 getSide() {
            return this.direction;
        }
    }

    public static abstract class Dual
    extends ValueBoxTransform {
        protected boolean first;

        public Dual(boolean first) {
            this.first = first;
        }

        public boolean isFirst() {
            return this.first;
        }

        public static Pair<ValueBoxTransform, ValueBoxTransform> makeSlots(Function<Boolean, ? extends Dual> factory) {
            return Pair.of((Object)factory.apply(true), (Object)factory.apply(false));
        }

        @Override
        public boolean testHit(class_2680 state, class_243 localHit) {
            class_243 offset = this.getLocalOffset(state);
            if (offset == null) {
                return false;
            }
            return localHit.method_1022(offset) < (double)(this.scale / 3.5f);
        }
    }
}

