/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.gantry;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.gantry.GantryShaftBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;

public class GantryShaftBlock
extends DirectionalKineticBlock
implements IBE<GantryShaftBlockEntity> {
    public static final class_2769<Part> PART = class_2754.method_11850((String)"part", Part.class);
    public static final class_2746 POWERED = class_2741.field_12484;
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515((class_2689.class_2690<class_2248, class_2680>)builder.method_11667(new class_2769[]{PART, POWERED}));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 ray) {
        class_1799 heldItem = player.method_5998(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!placementHelper.matchesItem(heldItem)) {
            return class_1269.field_5811;
        }
        return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (class_1747)heldItem.method_7909(), player, hand, ray);
    }

    public class_265 method_9530(class_2680 state, class_1922 p_220053_2_, class_2338 p_220053_3_, class_3726 p_220053_4_) {
        return AllShapes.EIGHT_VOXEL_POLE.get(((class_2350)state.method_11654((class_2769)FACING)).method_10166());
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighbour, class_1936 world, class_2338 pos, class_2338 neighbourPos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2350.class_2351 axis = facing.method_10166();
        if (direction.method_10166() != axis) {
            return state;
        }
        boolean connect = AllBlocks.GANTRY_SHAFT.has(neighbour) && neighbour.method_11654((class_2769)FACING) == facing;
        Part part = (Part)((Object)state.method_11654(PART));
        if (direction.method_10171() == facing.method_10171()) {
            if (connect) {
                if (part == Part.END) {
                    part = Part.MIDDLE;
                }
                if (part == Part.SINGLE) {
                    part = Part.START;
                }
            } else {
                if (part == Part.MIDDLE) {
                    part = Part.END;
                }
                if (part == Part.START) {
                    part = Part.SINGLE;
                }
            }
        } else if (connect) {
            if (part == Part.START) {
                part = Part.MIDDLE;
            }
            if (part == Part.SINGLE) {
                part = Part.END;
            }
        } else {
            if (part == Part.MIDDLE) {
                part = Part.START;
            }
            if (part == Part.END) {
                part = Part.SINGLE;
            }
        }
        return (class_2680)state.method_11657(PART, (Comparable)((Object)part));
    }

    public GantryShaftBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657(PART, (Comparable)((Object)Part.SINGLE)));
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 clickedState;
        class_2680 state = super.method_9605(context);
        class_2338 pos = context.method_8037();
        class_1937 world = context.method_8045();
        class_2350 face = context.method_8038();
        class_2680 neighbour = world.method_8320(pos.method_10093(((class_2350)state.method_11654((class_2769)FACING)).method_10153()));
        class_2680 class_26802 = clickedState = AllBlocks.GANTRY_SHAFT.has(neighbour) ? neighbour : world.method_8320(pos.method_10093(face.method_10153()));
        if (AllBlocks.GANTRY_SHAFT.has(clickedState) && ((class_2350)clickedState.method_11654((class_2769)FACING)).method_10166() == ((class_2350)state.method_11654((class_2769)FACING)).method_10166()) {
            class_2350 facing = (class_2350)clickedState.method_11654((class_2769)FACING);
            state = (class_2680)state.method_11657((class_2769)FACING, (Comparable)(context.method_8036() == null || !context.method_8036().method_5715() ? facing : facing.method_10153()));
        }
        return (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(this.shouldBePowered(state, world, pos)));
    }

    @Override
    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        class_1269 onWrenched = super.onWrenched(state, context);
        if (onWrenched.method_23665()) {
            class_2338 pos = context.method_8037();
            class_1937 world = context.method_8045();
            this.method_9612(world.method_8320(pos), world, pos, state.method_26204(), pos, false);
        }
        return onWrenched;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, worldIn, pos, oldState, isMoving);
        if (!worldIn.method_8608() && oldState.method_27852((class_2248)AllBlocks.GANTRY_SHAFT.get())) {
            class_2586 be;
            Part oldPart = (Part)((Object)oldState.method_11654(PART));
            Part part = (Part)((Object)state.method_11654(PART));
            if ((oldPart != Part.MIDDLE && part == Part.MIDDLE || oldPart == Part.SINGLE && part != Part.SINGLE) && (be = worldIn.method_8321(pos)) instanceof GantryShaftBlockEntity) {
                ((GantryShaftBlockEntity)be).checkAttachedCarriageBlocks();
            }
        }
    }

    public void method_9612(class_2680 state, class_1937 worldIn, class_2338 pos, class_2248 p_220069_4_, class_2338 p_220069_5_, boolean p_220069_6_) {
        if (worldIn.field_9236) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.method_11654((class_2769)POWERED);
        boolean shouldPower = worldIn.method_49803(pos);
        if (!previouslyPowered && !shouldPower && this.shouldBePowered(state, worldIn, pos)) {
            worldIn.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            return;
        }
        if (previouslyPowered == shouldPower) {
            return;
        }
        ArrayList<class_2338> toUpdate = new ArrayList<class_2338>();
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        class_2350.class_2351 axis = facing.method_10166();
        block0: for (class_2350 d : Iterate.directionsInAxis(axis)) {
            class_2680 currentState;
            class_2338 currentPos = pos.method_10093(d);
            while (worldIn.method_8477(currentPos) && (currentState = worldIn.method_8320(currentPos)).method_26204() instanceof GantryShaftBlock && currentState.method_11654((class_2769)FACING) == facing) {
                if (!shouldPower && ((Boolean)currentState.method_11654((class_2769)POWERED)).booleanValue() && worldIn.method_49803(currentPos)) {
                    return;
                }
                if ((Boolean)currentState.method_11654((class_2769)POWERED) == shouldPower) continue block0;
                toUpdate.add(currentPos);
                currentPos = currentPos.method_10093(d);
            }
        }
        toUpdate.add(pos);
        for (class_2338 blockPos : toUpdate) {
            class_2680 blockState = worldIn.method_8320(blockPos);
            class_2586 be = worldIn.method_8321(blockPos);
            if (be instanceof KineticBlockEntity) {
                ((KineticBlockEntity)be).detachKinetics();
            }
            if (!(blockState.method_26204() instanceof GantryShaftBlock)) continue;
            worldIn.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(shouldPower)), 2);
        }
    }

    protected boolean shouldBePowered(class_2680 state, class_1937 worldIn, class_2338 pos) {
        boolean shouldPower = worldIn.method_49803(pos);
        class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
        for (class_2350 d : Iterate.directionsInAxis(facing.method_10166())) {
            class_2680 neighbourState;
            class_2338 neighbourPos = pos.method_10093(d);
            if (!worldIn.method_8477(neighbourPos) || !((neighbourState = worldIn.method_8320(neighbourPos)).method_26204() instanceof GantryShaftBlock) || neighbourState.method_11654((class_2769)FACING) != facing) continue;
            shouldPower |= ((Boolean)neighbourState.method_11654((class_2769)POWERED)).booleanValue();
        }
        return shouldPower;
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return face.method_10166() == ((class_2350)state.method_11654((class_2769)FACING)).method_10166();
    }

    @Override
    public class_2350.class_2351 getRotationAxis(class_2680 state) {
        return ((class_2350)state.method_11654((class_2769)FACING)).method_10166();
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(class_2680 oldState, class_2680 newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.method_11654((class_2769)POWERED) == newState.method_11654((class_2769)POWERED);
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.35f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.25f;
    }

    public boolean method_9516(class_2680 state, class_1922 reader, class_2338 pos, class_10 type) {
        return false;
    }

    @Override
    public Class<GantryShaftBlockEntity> getBlockEntityClass() {
        return GantryShaftBlockEntity.class;
    }

    @Override
    public class_2591<? extends GantryShaftBlockEntity> getBlockEntityType() {
        return (class_2591)AllBlockEntityTypes.GANTRY_SHAFT.get();
    }

    public static enum Part implements class_3542
    {
        START,
        MIDDLE,
        END,
        SINGLE;


        public String method_15434() {
            return Lang.asId(this.name());
        }
    }

    public static class PlacementHelper
    extends PoleHelper<class_2350> {
        public PlacementHelper() {
            super(arg_0 -> AllBlocks.GANTRY_SHAFT.has(arg_0), s -> ((class_2350)s.method_11654((class_2769)DirectionalKineticBlock.FACING)).method_10166(), DirectionalKineticBlock.FACING);
        }

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return arg_0 -> AllBlocks.GANTRY_SHAFT.isIn(arg_0);
        }

        @Override
        public PlacementOffset getOffset(class_1657 player, class_1937 world, class_2680 state, class_2338 pos, class_3965 ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            offset.withTransform(offset.getTransform().andThen(s -> (class_2680)s.method_11657((class_2769)POWERED, (Comparable)((Boolean)state.method_11654((class_2769)POWERED)))));
            return offset;
        }
    }
}

