/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.base;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import com.simibubi.create.infrastructure.config.AllConfigs;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4538;

public interface IRotate
extends IWrenchable {
    public boolean hasShaftTowards(class_4538 var1, class_2338 var2, class_2680 var3, class_2350 var4);

    public class_2350.class_2351 getRotationAxis(class_2680 var1);

    default public SpeedLevel getMinimumRequiredSpeedLevel() {
        return SpeedLevel.NONE;
    }

    default public boolean hideStressImpact() {
        return false;
    }

    default public boolean showCapacityWithAnnotation() {
        return false;
    }

    public static enum SpeedLevel {
        NONE(class_124.field_1063, 0, 0),
        SLOW(class_124.field_1060, 0x22FF22, 10),
        MEDIUM(class_124.field_1075, 34047, 20),
        FAST(class_124.field_1076, 0xFF55FF, 30);

        private final class_124 textColor;
        private final int color;
        private final int particleSpeed;

        private SpeedLevel(class_124 textColor, int color, int particleSpeed) {
            this.textColor = textColor;
            this.color = color;
            this.particleSpeed = particleSpeed;
        }

        public class_124 getTextColor() {
            return this.textColor;
        }

        public int getColor() {
            return this.color;
        }

        public int getParticleSpeed() {
            return this.particleSpeed;
        }

        public float getSpeedValue() {
            switch (this) {
                case FAST: {
                    return ((Double)AllConfigs.server().kinetics.fastSpeed.get()).floatValue();
                }
                case MEDIUM: {
                    return ((Double)AllConfigs.server().kinetics.mediumSpeed.get()).floatValue();
                }
                case SLOW: {
                    return 1.0f;
                }
            }
            return 0.0f;
        }

        public static SpeedLevel of(float speed) {
            if ((double)(speed = Math.abs(speed)) >= (Double)AllConfigs.server().kinetics.fastSpeed.get()) {
                return FAST;
            }
            if ((double)speed >= (Double)AllConfigs.server().kinetics.mediumSpeed.get()) {
                return MEDIUM;
            }
            if (speed >= 1.0f) {
                return SLOW;
            }
            return NONE;
        }

        public static LangBuilder getFormattedSpeedText(float speed, boolean overstressed) {
            SpeedLevel speedLevel = SpeedLevel.of(speed);
            LangBuilder builder = Lang.text(TooltipHelper.makeProgressBar(3, speedLevel.ordinal()));
            builder.translate("tooltip.speedRequirement." + Lang.asId(speedLevel.name()), new Object[0]).space().text("(").add(Lang.number(Math.abs(speed))).space().translate("generic.unit.rpm", new Object[0]).text(")").space();
            if (overstressed) {
                builder.style(class_124.field_1063).style(class_124.field_1055);
            } else {
                builder.style(speedLevel.getTextColor());
            }
            return builder;
        }
    }

    public static enum StressImpact {
        LOW(class_124.field_1054, class_124.field_1060),
        MEDIUM(class_124.field_1065, class_124.field_1054),
        HIGH(class_124.field_1061, class_124.field_1065),
        OVERSTRESSED(class_124.field_1061, class_124.field_1061);

        private final class_124 absoluteColor;
        private final class_124 relativeColor;

        private StressImpact(class_124 absoluteColor, class_124 relativeColor) {
            this.absoluteColor = absoluteColor;
            this.relativeColor = relativeColor;
        }

        public class_124 getAbsoluteColor() {
            return this.absoluteColor;
        }

        public class_124 getRelativeColor() {
            return this.relativeColor;
        }

        public static StressImpact of(double stressPercent) {
            if (stressPercent > 1.0) {
                return OVERSTRESSED;
            }
            if (stressPercent > 0.75) {
                return HIGH;
            }
            if (stressPercent > 0.5) {
                return MEDIUM;
            }
            return LOW;
        }

        public static boolean isEnabled() {
            return (Boolean)AllConfigs.server().kinetics.disableStress.get() == false;
        }

        public static LangBuilder getFormattedStressText(double stressPercent) {
            StressImpact stressLevel = StressImpact.of(stressPercent);
            return Lang.text(TooltipHelper.makeProgressBar(3, Math.min(stressLevel.ordinal() + 1, 3))).translate("tooltip.stressImpact." + Lang.asId(stressLevel.name()), new Object[0]).text(String.format(" (%s%%) ", (int)(stressPercent * 100.0))).style(stressLevel.getRelativeColor());
        }
    }
}

