/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.actors.roller;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.simibubi.create.content.contraptions.actors.roller.RollerBlock;
import com.simibubi.create.content.contraptions.actors.roller.RollerMovementBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;

public class RollerBlockEntity
extends SmartBlockEntity {
    private float manuallyAnimatedSpeed;
    public FilteringBehaviour filtering;
    public ScrollOptionBehaviour<RollingMode> mode;
    private boolean dontPropagate = false;

    public RollerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour(this, new RollerValueBox(3));
        behaviours.add(this.filtering);
        this.mode = new ScrollOptionBehaviour<RollingMode>(RollingMode.class, (class_2561)Lang.translateDirect("contraptions.roller_mode", new Object[0]), this, new RollerValueBox(-3));
        behaviours.add(this.mode);
        this.filtering.setLabel(Lang.translateDirect("contraptions.mechanical_roller.pave_material", new Object[0]));
        this.filtering.withCallback(this::onFilterChanged);
        this.filtering.withPredicate(this::isValidMaterial);
        this.mode.withCallback(this::onModeChanged);
    }

    protected void onModeChanged(int mode) {
        this.shareValuesToAdjacent();
    }

    protected void onFilterChanged(class_1799 newFilter) {
        this.shareValuesToAdjacent();
    }

    protected boolean isValidMaterial(class_1799 newFilter) {
        if (newFilter.method_7960()) {
            return true;
        }
        class_2680 appliedState = RollerMovementBehaviour.getStateToPaveWith(newFilter);
        if (appliedState.method_26215()) {
            return false;
        }
        if (appliedState.method_26204() instanceof class_2343) {
            return false;
        }
        if (appliedState.method_26204() instanceof class_2510) {
            return false;
        }
        class_265 shape = appliedState.method_26218((class_1922)this.field_11863, this.field_11867);
        if (shape.method_1110() || !shape.method_1107().equals((Object)class_259.method_1077().method_1107())) {
            return false;
        }
        class_265 collisionShape = appliedState.method_26220((class_1922)this.field_11863, this.field_11867);
        return !collisionShape.method_1110();
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return new class_238(this.field_11867).method_1014(1.0);
    }

    public float getAnimatedSpeed() {
        return this.manuallyAnimatedSpeed;
    }

    public void setAnimatedSpeed(float speed) {
        this.manuallyAnimatedSpeed = speed;
    }

    public void searchForSharedValues() {
        class_2680 blockState = this.method_11010();
        class_2350 facing = blockState.method_28500((class_2769)RollerBlock.field_11177).orElse(class_2350.field_11035);
        for (int side : Iterate.positiveAndNegative) {
            class_2586 class_25862;
            class_2338 pos = this.field_11867.method_10079(facing.method_10170(), side);
            if (this.field_11863.method_8320(pos) != blockState || !((class_25862 = this.field_11863.method_8321(pos)) instanceof RollerBlockEntity)) continue;
            RollerBlockEntity otherRoller = (RollerBlockEntity)class_25862;
            this.acceptSharedValues(otherRoller.mode.getValue(), otherRoller.filtering.getFilter());
            this.shareValuesToAdjacent();
            break;
        }
    }

    protected void acceptSharedValues(int mode, class_1799 filter) {
        this.dontPropagate = true;
        this.filtering.setFilter(filter.method_7972());
        this.mode.setValue(mode);
        this.dontPropagate = false;
        this.notifyUpdate();
    }

    public void shareValuesToAdjacent() {
        if (this.dontPropagate || this.field_11863.method_8608()) {
            return;
        }
        class_2680 blockState = this.method_11010();
        class_2350 facing = blockState.method_28500((class_2769)RollerBlock.field_11177).orElse(class_2350.field_11035);
        for (int side : Iterate.positiveAndNegative) {
            class_2586 class_25862;
            class_2338 pos;
            for (int i = 1; i < 100 && this.field_11863.method_8320(pos = this.field_11867.method_10079(facing.method_10170(), side * i)) == blockState && (class_25862 = this.field_11863.method_8321(pos)) instanceof RollerBlockEntity; ++i) {
                RollerBlockEntity otherRoller = (RollerBlockEntity)class_25862;
                otherRoller.acceptSharedValues(this.mode.getValue(), this.filtering.getFilter());
            }
        }
    }

    private final class RollerValueBox
    extends ValueBoxTransform {
        private int hOffset;

        public RollerValueBox(int hOffset) {
            this.hOffset = hOffset;
        }

        @Override
        public void rotate(class_2680 state, class_4587 ms) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)RollerBlock.field_11177);
            float yRot = AngleHelper.horizontalAngle(facing) + 180.0f;
            ((TransformStack)TransformStack.cast((class_4587)ms).rotateY((double)yRot)).rotateX(90.0);
        }

        @Override
        public boolean testHit(class_2680 state, class_243 localHit) {
            class_243 offset = this.getLocalOffset(state);
            if (offset == null) {
                return false;
            }
            return localHit.method_1022(offset) < (double)(this.scale / 3.0f);
        }

        @Override
        public class_243 getLocalOffset(class_2680 state) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)RollerBlock.field_11177);
            float stateAngle = AngleHelper.horizontalAngle(facing) + 180.0f;
            return VecHelper.rotateCentered(VecHelper.voxelSpace(8 + this.hOffset, 15.5, 11.0), stateAngle, class_2350.class_2351.field_11052);
        }
    }

    static enum RollingMode implements INamedIconOptions
    {
        TUNNEL_PAVE(AllIcons.I_ROLLER_PAVE),
        STRAIGHT_FILL(AllIcons.I_ROLLER_FILL),
        WIDE_FILL(AllIcons.I_ROLLER_WIDE_FILL);

        private String translationKey;
        private AllIcons icon;

        private RollingMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "contraptions.roller_mode." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

