/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import fuzs.forgeconfigapiport.impl.core.CommonAbstractions;
import java.io.ByteArrayInputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.Callable;
import net.minecraft.class_3542;
import net.minecraftforge.fml.config.ConfigFileTypeHandler;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigSpec;
import org.jetbrains.annotations.ApiStatus;

public class ModConfig {
    private final Type type;
    private final IConfigSpec<?> spec;
    private final String fileName;
    private final String modId;
    private final ConfigFileTypeHandler configHandler;
    private CommentedConfig configData;
    private Callable<Void> saveHandler;

    @ApiStatus.Internal
    public ModConfig(Type type, IConfigSpec<?> spec, String modId, String fileName) {
        this.type = type;
        this.spec = spec;
        this.fileName = fileName;
        if (!CommonAbstractions.INSTANCE.isModLoaded(modId)) {
            throw new IllegalArgumentException("No mod with mod id %s".formatted(modId));
        }
        this.modId = modId;
        this.configHandler = ConfigFileTypeHandler.TOML;
        ConfigTracker.INSTANCE.trackConfig(this);
    }

    @ApiStatus.Internal
    public ModConfig(Type type, IConfigSpec<?> spec, String modId) {
        this(type, spec, modId, ModConfig.defaultConfigName(type, modId));
    }

    static String defaultConfigName(Type type, String modId) {
        return String.format("%s-%s.toml", modId, type.extension());
    }

    public Type getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public ConfigFileTypeHandler getHandler() {
        return this.configHandler;
    }

    public <T extends IConfigSpec<T>> IConfigSpec<T> getSpec() {
        return this.spec;
    }

    public String getModId() {
        return this.modId;
    }

    public CommentedConfig getConfigData() {
        return this.configData;
    }

    void setConfigData(CommentedConfig configData) {
        this.configData = configData;
        this.spec.acceptConfig(this.configData);
    }

    public void save() {
        ((CommentedFileConfig)this.configData).save();
    }

    public Path getFullPath() {
        return ((CommentedFileConfig)this.configData).getNioPath();
    }

    public void acceptSyncedConfig(byte[] bytes) {
        if (bytes != null) {
            this.setConfigData((CommentedConfig)TomlFormat.instance().createParser().parse(new ByteArrayInputStream(bytes)));
            CommonAbstractions.INSTANCE.fireConfigReloading(this.getModId(), this);
        } else {
            this.setConfigData(null);
            CommonAbstractions.INSTANCE.fireConfigUnloading(this.getModId(), this);
        }
    }

    public static enum Type implements class_3542
    {
        COMMON,
        CLIENT,
        SERVER;


        public String extension() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @ApiStatus.Internal
        public String method_15434() {
            return this.extension();
        }
    }
}

