/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl.network.config;

import fuzs.forgeconfigapiport.impl.ForgeConfigAPIPort;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3248;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class ConfigSync {
    public static final class_2960 SYNC_CONFIGS_CHANNEL = new class_2960("forgeconfigapiport", "sync_configs");
    public static final class_2960 ESTABLISH_MODDED_CONNECTION_CHANNEL = new class_2960("forgeconfigapiport", "modded_connection");

    private ConfigSync() {
    }

    public static List<Pair<String, class_2540>> onSyncConfigs() {
        Map<String, byte[]> configData = ConfigTracker.INSTANCE.configSets().get((Object)ModConfig.Type.SERVER).stream().collect(Collectors.toMap(ModConfig::getFileName, config -> {
            try {
                return Files.readAllBytes(config.getFullPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
        return configData.entrySet().stream().map(e -> {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10814((String)e.getKey());
            buf.method_10813((byte[])e.getValue());
            return Pair.of((Object)("Config " + (String)e.getKey()), (Object)buf);
        }).collect(Collectors.toList());
    }

    public static void onSyncConfigs(MinecraftServer server, class_3248 handler, boolean understood, class_2540 buf) {
        if (!understood) {
            return;
        }
        String fileName = buf.method_10800(Short.MAX_VALUE);
        ForgeConfigAPIPort.LOGGER.debug("Received acknowledgement for config sync for {} from client", (Object)fileName);
    }

    public static void onEstablishModdedConnection(MinecraftServer server, class_3248 handler, boolean understood, class_2540 buf) {
        ForgeConfigAPIPort.LOGGER.debug("Received acknowledgement for modded connection marker from client");
    }

    public static void unloadSyncedConfig() {
        ConfigTracker.INSTANCE.configSets().get((Object)ModConfig.Type.SERVER).forEach(config -> config.acceptSyncedConfig(null));
    }
}

