/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.registrate.providers.biomeModifier;

import com.dannbrown.deltaboxlib.registrate.AbstractDeltaboxRegistrate;
import com.dannbrown.deltaboxlib.registrate.providers.biomeModifier.BiomeModifierCodec;
import com.dannbrown.deltaboxlib.registrate.providers.biomeModifier.BiomeSpawnCodec;
import com.dannbrown.deltaboxlib.registrate.util.DeltaboxUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2405;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ3\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J3\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001d\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\n \u001c*\u0004\u0018\u00010\u001b0\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001eR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010 R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010!\u00a8\u0006\""}, d2={"Lcom/dannbrown/deltaboxlib/registrate/providers/biomeModifier/BiomeModifierProvider;", "Lnet/minecraft/class_2405;", "Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;", "registrate", "Lnet/minecraft/class_7784;", "packOutput", "<init>", "(Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;Lnet/minecraft/class_7784;)V", "", "getName", "()Ljava/lang/String;", "Lnet/minecraft/class_7403;", "cachedOutput", "Ljava/util/concurrent/CompletableFuture;", "run", "(Lnet/minecraft/class_7403;)Ljava/util/concurrent/CompletableFuture;", "Ljava/nio/file/Path;", "path", "Lcom/dannbrown/deltaboxlib/registrate/providers/biomeModifier/BiomeModifierCodec;", "biomeModifier", "modLoader", "saveBiomeModifierData", "(Lnet/minecraft/class_7403;Ljava/nio/file/Path;Lcom/dannbrown/deltaboxlib/registrate/providers/biomeModifier/BiomeModifierCodec;Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "Lcom/dannbrown/deltaboxlib/registrate/providers/biomeModifier/BiomeSpawnCodec;", "biomeSpawn", "saveBiomeSpawnData", "(Lnet/minecraft/class_7403;Ljava/nio/file/Path;Lcom/dannbrown/deltaboxlib/registrate/providers/biomeModifier/BiomeSpawnCodec;Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "Lnet/minecraft/class_7784$class_7489;", "kotlin.jvm.PlatformType", "forgeBiomeModifierPathProvider", "Lnet/minecraft/class_7784$class_7489;", "neoforgeBiomeModifierPathProvider", "Lnet/minecraft/class_7784;", "Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;", "deltaboxlib-2.1.1-common-1.20.1"})
@SourceDebugExtension(value={"SMAP\nBiomeModifierProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BiomeModifierProvider.kt\ncom/dannbrown/deltaboxlib/registrate/providers/biomeModifier/BiomeModifierProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,88:1\n37#2,2:89\n*S KotlinDebug\n*F\n+ 1 BiomeModifierProvider.kt\ncom/dannbrown/deltaboxlib/registrate/providers/biomeModifier/BiomeModifierProvider\n*L\n55#1:89,2\n*E\n"})
public final class BiomeModifierProvider
implements class_2405 {
    @NotNull
    private final AbstractDeltaboxRegistrate registrate;
    @NotNull
    private final class_7784 packOutput;
    private final class_7784.class_7489 forgeBiomeModifierPathProvider;
    private final class_7784.class_7489 neoforgeBiomeModifierPathProvider;

    public BiomeModifierProvider(@NotNull AbstractDeltaboxRegistrate registrate, @NotNull class_7784 packOutput) {
        Intrinsics.checkNotNullParameter((Object)registrate, (String)"registrate");
        Intrinsics.checkNotNullParameter((Object)packOutput, (String)"packOutput");
        this.registrate = registrate;
        this.packOutput = packOutput;
        this.forgeBiomeModifierPathProvider = this.packOutput.method_45973(class_7784.class_7490.field_39367, "forge/biome_modifier");
        this.neoforgeBiomeModifierPathProvider = this.packOutput.method_45973(class_7784.class_7490.field_39367, "neoforge/biome_modifier");
    }

    @NotNull
    public String method_10321() {
        return "Biome Modifiers and Spawns Datagen for: " + this.registrate.getModId();
    }

    @NotNull
    public CompletableFuture<?> method_10319(@NotNull class_7403 cachedOutput) {
        Intrinsics.checkNotNullParameter((Object)cachedOutput, (String)"cachedOutput");
        List futures = new ArrayList();
        for (Map.Entry<String, BiomeModifierCodec> entry2 : this.registrate.getBiomeModifierRegistry().getBiomeModifiers().entrySet()) {
            String modifierName = entry2.getKey();
            BiomeModifierCodec biomeModifier = entry2.getValue();
            Path forgeModifierPath = this.forgeBiomeModifierPathProvider.method_44107(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), modifierName));
            Path neoforgeModifierPath = this.neoforgeBiomeModifierPathProvider.method_44107(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), modifierName));
            Intrinsics.checkNotNull((Object)forgeModifierPath);
            futures.add(this.saveBiomeModifierData(cachedOutput, forgeModifierPath, biomeModifier, "forge"));
            Intrinsics.checkNotNull((Object)neoforgeModifierPath);
            futures.add(this.saveBiomeModifierData(cachedOutput, neoforgeModifierPath, biomeModifier, "neoforge"));
        }
        for (Map.Entry<String, Object> entry : this.registrate.getBiomeModifierRegistry().getBiomeSpawns().entrySet()) {
            String spawnName = entry.getKey();
            BiomeSpawnCodec biomeSpawn = (BiomeSpawnCodec)entry.getValue();
            Path forgeSpawnPath = this.forgeBiomeModifierPathProvider.method_44107(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), spawnName));
            Path neoforgeSpawnPath = this.neoforgeBiomeModifierPathProvider.method_44107(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), spawnName));
            Intrinsics.checkNotNull((Object)forgeSpawnPath);
            futures.add(this.saveBiomeSpawnData(cachedOutput, forgeSpawnPath, biomeSpawn, "forge"));
            Intrinsics.checkNotNull((Object)neoforgeSpawnPath);
            futures.add(this.saveBiomeSpawnData(cachedOutput, neoforgeSpawnPath, biomeSpawn, "neoforge"));
        }
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> completableFuture2 = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
        Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"allOf(...)");
        return completableFuture2;
    }

    private final CompletableFuture<?> saveBiomeModifierData(class_7403 cachedOutput, Path path, BiomeModifierCodec biomeModifier, String modLoader) {
        JsonObject jsonObject = BiomeModifierCodec.Companion.serializeToJson(biomeModifier, modLoader);
        CompletableFuture completableFuture2 = class_2405.method_10320((class_7403)cachedOutput, (JsonElement)((JsonElement)jsonObject), (Path)path);
        Intrinsics.checkNotNull((Object)completableFuture2);
        return completableFuture2;
    }

    private final CompletableFuture<?> saveBiomeSpawnData(class_7403 cachedOutput, Path path, BiomeSpawnCodec biomeSpawn, String modLoader) {
        JsonObject jsonObject = BiomeSpawnCodec.Companion.serializeToJson(biomeSpawn, modLoader);
        CompletableFuture completableFuture2 = class_2405.method_10320((class_7403)cachedOutput, (JsonElement)((JsonElement)jsonObject), (Path)path);
        Intrinsics.checkNotNull((Object)completableFuture2);
        return completableFuture2;
    }
}

