/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.registrate.network.fabric;

import com.dannbrown.deltaboxlib.registrate.network.NetworkChannelHandler;
import com.dannbrown.deltaboxlib.registrate.network.NetworkDirection;
import com.dannbrown.deltaboxlib.registrate.network.NetworkPacket;
import com.dannbrown.deltaboxlib.registrate.network.fabric.FabricClientNetwork;
import com.dannbrown.deltaboxlib.registrate.util.DeltaboxUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 -2\u00020\u0001:\u0002-.B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005JC\u0010\u0010\u001a\u00020\u000f\"\b\b\u0000\u0010\u0007*\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010!\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b!\u0010 J\u001f\u0010$\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010&\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b&\u0010\u0014J\u001b\u0010(\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b(\u0010)R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006/"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/network/fabric/NetworkChannelHandlerImpl;", "Lcom/dannbrown/deltaboxlib/registrate/network/NetworkChannelHandler;", "", "modId", "<init>", "(Ljava/lang/String;)V", "Lcom/dannbrown/deltaboxlib/registrate/network/NetworkPacket;", "M", "Lcom/dannbrown/deltaboxlib/registrate/network/NetworkDirection;", "direction", "Ljava/lang/Class;", "messageClass", "Lkotlin/Function1;", "Lnet/minecraft/class_2540;", "decoder", "", "register", "(Lcom/dannbrown/deltaboxlib/registrate/network/NetworkDirection;Ljava/lang/Class;Lkotlin/jvm/functions/Function1;)V", "networkPacket", "sendToAllClientPlayers", "(Lcom/dannbrown/deltaboxlib/registrate/network/NetworkPacket;)V", "Lnet/minecraft/class_1937;", "level", "Lnet/minecraft/class_2338;", "pos", "", "radius", "sendToAllClientPlayersInRange", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;DLcom/dannbrown/deltaboxlib/registrate/network/NetworkPacket;)V", "Lnet/minecraft/class_1297;", "target", "sendToAllClientPlayersTrackingEntity", "(Lnet/minecraft/class_1297;Lcom/dannbrown/deltaboxlib/registrate/network/NetworkPacket;)V", "sendToAllClientPlayersTrackingEntityAndSelf", "Lnet/minecraft/class_3222;", "serverPlayer", "sendToClientPlayer", "(Lnet/minecraft/class_3222;Lcom/dannbrown/deltaboxlib/registrate/network/NetworkPacket;)V", "sendToServer", "Lnet/minecraft/class_2596;", "toVanillaPacket", "(Lcom/dannbrown/deltaboxlib/registrate/network/NetworkPacket;)Lnet/minecraft/class_2596;", "", "id", "I", "Companion", "Wrapper", "deltaboxlib-2.1.1-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nNetworkChannelHandlerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkChannelHandlerImpl.kt\ncom/dannbrown/deltaboxlib/registrate/network/fabric/NetworkChannelHandlerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1855#2,2:116\n*S KotlinDebug\n*F\n+ 1 NetworkChannelHandlerImpl.kt\ncom/dannbrown/deltaboxlib/registrate/network/fabric/NetworkChannelHandlerImpl\n*L\n72#1:116,2\n*E\n"})
public final class NetworkChannelHandlerImpl
extends NetworkChannelHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int id;
    @NotNull
    private static final Map<Class<?>, class_2960> ID_MAP = new LinkedHashMap();

    public NetworkChannelHandlerImpl(@NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        super(modId);
    }

    @Override
    public <M extends NetworkPacket> void register(@NotNull NetworkDirection direction, @NotNull Class<M> messageClass, @NotNull Function1<? super class_2540, ? extends M> decoder) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter(messageClass, (String)"messageClass");
        Intrinsics.checkNotNullParameter(decoder, (String)"decoder");
        int n = this.id;
        this.id = n + 1;
        class_2960 res = new class_2960(this.getName(), String.valueOf(n));
        ID_MAP.put(messageClass, res);
        if (direction != NetworkDirection.PLAY_TO_CLIENT) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)res, (arg_0, arg_1, arg_2, arg_3, arg_4) -> NetworkChannelHandlerImpl.register$lambda$1(decoder, arg_0, arg_1, arg_2, arg_3, arg_4));
        }
        if (direction != NetworkDirection.PLAY_TO_SERVER && DeltaboxUtil.getSide().isClient()) {
            FabricClientNetwork.INSTANCE.register(res, decoder);
        }
    }

    @Override
    public void sendToClientPlayer(@NotNull class_3222 serverPlayer, @NotNull NetworkPacket networkPacket) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
        class_2540 buf = PacketByteBufs.create();
        Intrinsics.checkNotNull((Object)buf);
        networkPacket.writeToBuffer(buf);
        class_2960 class_29602 = ID_MAP.get(networkPacket.getClass());
        Intrinsics.checkNotNull((Object)class_29602);
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)class_29602, (class_2540)buf);
    }

    @Override
    public void sendToAllClientPlayers(@NotNull NetworkPacket networkPacket) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
            Object object = DeltaboxUtil.getCurrentServer();
            if (object == null || (object = object.method_3760()) == null || (object = object.method_14571()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                class_3222 it = (class_3222)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.sendToClientPlayer(it, networkPacket);
            }
        }
    }

    @Override
    public void sendToServer(@NotNull NetworkPacket networkPacket) {
        Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
        class_2540 buf = PacketByteBufs.create();
        Intrinsics.checkNotNull((Object)buf);
        networkPacket.writeToBuffer(buf);
        class_2960 class_29602 = ID_MAP.get(networkPacket.getClass());
        Intrinsics.checkNotNull((Object)class_29602);
        ClientPlayNetworking.send((class_2960)class_29602, (class_2540)buf);
    }

    @Override
    public void sendToAllClientPlayersInRange(@NotNull class_1937 level, @NotNull class_2338 pos, double radius, @NotNull NetworkPacket networkPacket) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
        MinecraftServer currentServer = DeltaboxUtil.getCurrentServer();
        if (!level.field_9236 && currentServer != null) {
            class_3324 players = currentServer.method_3760();
            players.method_14605(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), radius, level.method_27983(), this.toVanillaPacket(networkPacket));
        }
    }

    @Override
    public void sendToAllClientPlayersTrackingEntity(@NotNull class_1297 target, @NotNull NetworkPacket networkPacket) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
            class_1937 class_19372 = target.method_37908();
            class_3218 class_32182 = class_19372 instanceof class_3218 ? (class_3218)class_19372 : null;
            if (class_32182 == null || (class_32182 = class_32182.method_14178()) == null) break block0;
            class_32182.method_18754(target, this.toVanillaPacket(networkPacket));
        }
    }

    @Override
    public void sendToAllClientPlayersTrackingEntityAndSelf(@NotNull class_1297 target, @NotNull NetworkPacket networkPacket) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)networkPacket, (String)"networkPacket");
            class_1937 class_19372 = target.method_37908();
            class_3218 class_32182 = class_19372 instanceof class_3218 ? (class_3218)class_19372 : null;
            if (class_32182 == null) break block1;
            class_3218 serverLevel = class_32182;
            boolean bl = false;
            class_2596<?> packet = this.toVanillaPacket(networkPacket);
            serverLevel.method_14178().method_18754(target, packet);
            if (target instanceof class_3222) {
                this.sendToClientPlayer((class_3222)target, networkPacket);
            }
        }
    }

    private final class_2596<?> toVanillaPacket(NetworkPacket networkPacket) {
        class_2540 buf = PacketByteBufs.create();
        Intrinsics.checkNotNull((Object)buf);
        networkPacket.writeToBuffer(buf);
        class_2960 class_29602 = ID_MAP.get(networkPacket.getClass());
        Intrinsics.checkNotNull((Object)class_29602);
        class_2596 class_25962 = ServerPlayNetworking.createS2CPacket((class_2960)class_29602, (class_2540)buf);
        Intrinsics.checkNotNullExpressionValue((Object)class_25962, (String)"createS2CPacket(...)");
        return class_25962;
    }

    private static final void register$lambda$1$lambda$0(NetworkPacket $message, class_3222 $player, class_3244 $handler) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNull((Object)$player);
        $message.handle(new Wrapper((class_1657)$player, NetworkDirection.PLAY_TO_SERVER, $handler));
    }

    private static final void register$lambda$1(Function1 $decoder, MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNullParameter((Object)$decoder, (String)"$decoder");
        Intrinsics.checkNotNull((Object)buf);
        NetworkPacket message = (NetworkPacket)$decoder.invoke((Object)buf);
        server.execute(() -> NetworkChannelHandlerImpl.register$lambda$1$lambda$0(message, player, handler));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0007\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/network/fabric/NetworkChannelHandlerImpl$Companion;", "", "<init>", "()V", "", "Ljava/lang/Class;", "Lnet/minecraft/class_2960;", "ID_MAP", "Ljava/util/Map;", "deltaboxlib-2.1.1-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000f\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0014\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/dannbrown/deltaboxlib/registrate/network/fabric/NetworkChannelHandlerImpl$Wrapper;", "Lcom/dannbrown/deltaboxlib/registrate/network/NetworkChannelHandler$Context;", "Lnet/minecraft/class_1657;", "player", "Lcom/dannbrown/deltaboxlib/registrate/network/NetworkDirection;", "dir", "Lnet/minecraft/class_3244;", "packetListener", "<init>", "(Lnet/minecraft/class_1657;Lcom/dannbrown/deltaboxlib/registrate/network/NetworkDirection;Lnet/minecraft/class_3244;)V", "Lnet/minecraft/class_2561;", "reason", "", "disconnect", "(Lnet/minecraft/class_2561;)V", "Lcom/dannbrown/deltaboxlib/registrate/network/NetworkDirection;", "direction", "getDirection", "()Lcom/dannbrown/deltaboxlib/registrate/network/NetworkDirection;", "Lnet/minecraft/class_3244;", "Lnet/minecraft/class_1657;", "sender", "getSender", "()Lnet/minecraft/class_1657;", "deltaboxlib-2.1.1-fabric-1.20.1"})
    public static final class Wrapper
    implements NetworkChannelHandler.Context {
        @NotNull
        private final class_1657 player;
        @NotNull
        private final NetworkDirection dir;
        @Nullable
        private final class_3244 packetListener;
        @NotNull
        private final NetworkDirection direction;
        @NotNull
        private final class_1657 sender;

        public Wrapper(@NotNull class_1657 player, @NotNull NetworkDirection dir, @Nullable class_3244 packetListener) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)((Object)dir), (String)"dir");
            this.player = player;
            this.dir = dir;
            this.packetListener = packetListener;
            this.direction = this.dir;
            this.sender = this.player;
        }

        @Override
        @NotNull
        public NetworkDirection getDirection() {
            return this.direction;
        }

        @Override
        @NotNull
        public class_1657 getSender() {
            return this.sender;
        }

        @Override
        public void disconnect(@NotNull class_2561 reason) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                class_3244 class_32442 = this.packetListener;
                if (class_32442 == null) break block0;
                class_32442.method_14367(reason);
            }
        }
    }
}

