/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.fabric.registrate;

import com.dannbrown.deltaboxlib.content.item.DeltaboxSpawnEggItem;
import com.dannbrown.deltaboxlib.registrate.AbstractDeltaboxRegistrate;
import com.dannbrown.deltaboxlib.registrate.builders.BlockBuilder;
import com.dannbrown.deltaboxlib.registrate.builders.BlockEntityBuilder;
import com.dannbrown.deltaboxlib.registrate.builders.EntityTypeBuilder;
import com.dannbrown.deltaboxlib.registrate.builders.ItemBuilder;
import com.dannbrown.deltaboxlib.registrate.providers.biomeModifier.BiomeModifierCodec;
import com.dannbrown.deltaboxlib.registrate.providers.biomeModifier.BiomeSpawnCodec;
import com.dannbrown.deltaboxlib.registrate.registry.ParticleRegistry;
import com.dannbrown.deltaboxlib.registrate.util.AttributesUtil;
import com.dannbrown.deltaboxlib.registrate.util.DeltaboxUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.management.BadAttributeValueExpException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.particle.v1.FabricSpriteProvider;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_1163;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1926;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2357;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2893;
import net.minecraft.class_326;
import net.minecraft.class_5132;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5614;
import net.minecraft.class_5616;
import net.minecraft.class_5617;
import net.minecraft.class_707;
import net.minecraft.class_7752;
import net.minecraft.class_7923;
import net.minecraft.class_827;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u000b\u001a\u00020\n\"\b\b\u0000\u0010\u0007*\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u000f\u0010\u0011\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u000f\u0010\u0012\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u000f\u0010\u0013\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\u000f\u0010\u0014\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u000eJ\u000f\u0010\u0015\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u000eJ\u000f\u0010\u0016\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u000eJ\u000f\u0010\u0017\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u000eJ\u000f\u0010\u0018\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u000eJ\u000f\u0010\u0019\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u000eJ\u000f\u0010\u001a\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u000eJ\u000f\u0010\u001b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/dannbrown/deltaboxlib/fabric/registrate/RegistrateInitFabric;", "", "Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;", "registrate", "<init>", "(Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;)V", "Lnet/minecraft/class_2394;", "T", "Lcom/dannbrown/deltaboxlib/registrate/registry/ParticleRegistry$ParticleRegistration;", "registration", "", "handleParticleRegistration", "(Lcom/dannbrown/deltaboxlib/registrate/registry/ParticleRegistry$ParticleRegistration;)V", "init", "()V", "initClient", "registerBiomeColors", "registerBiomeModifiers", "registerBlockEntityRenderers", "registerCompostableBlocks", "registerCutoutRenders", "registerDispenserBehaviors", "registerEntityAttributes", "registerEntityRenderers", "registerFlammableBlocks", "registerModelLayers", "registerParticleRenders", "registerStrippableBlocks", "Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;", "getRegistrate", "()Lcom/dannbrown/deltaboxlib/registrate/AbstractDeltaboxRegistrate;", "deltaboxlib-2.1.1-fabric-1.20.1"})
@SourceDebugExtension(value={"SMAP\nRegistrateInitFabric.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistrateInitFabric.kt\ncom/dannbrown/deltaboxlib/fabric/registrate/RegistrateInitFabric\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,239:1\n1855#2,2:240\n766#2:244\n857#2,2:245\n1549#2:247\n1620#2,3:248\n215#3,2:242\n37#4,2:251\n*S KotlinDebug\n*F\n+ 1 RegistrateInitFabric.kt\ncom/dannbrown/deltaboxlib/fabric/registrate/RegistrateInitFabric\n*L\n100#1:240,2\n117#1:244\n117#1:245,2\n117#1:247\n117#1:248,3\n107#1:242,2\n118#1:251,2\n*E\n"})
public final class RegistrateInitFabric {
    @NotNull
    private final AbstractDeltaboxRegistrate registrate;

    public RegistrateInitFabric(@NotNull AbstractDeltaboxRegistrate registrate) {
        Intrinsics.checkNotNullParameter((Object)registrate, (String)"registrate");
        this.registrate = registrate;
    }

    @NotNull
    public final AbstractDeltaboxRegistrate getRegistrate() {
        return this.registrate;
    }

    public final void init() {
        this.registerFlammableBlocks();
        this.registerStrippableBlocks();
        this.registerCompostableBlocks();
        this.registerDispenserBehaviors();
        this.registerBiomeModifiers();
        this.registerEntityAttributes();
    }

    public final void initClient() {
        this.registerCutoutRenders();
        this.registerBiomeColors();
        this.registerParticleRenders();
        this.registerModelLayers();
        this.registerEntityRenderers();
        this.registerBlockEntityRenderers();
    }

    private final void registerFlammableBlocks() {
        for (BlockBuilder<? extends class_2248> block : this.registrate.getBlockRegistry().getEntries()) {
            if (block.getContext().getFlammabilityBurnChance() == 0 || block.getContext().getFlammabilitySpreadChance() == 0) continue;
            FlammableBlockRegistry.getDefaultInstance().add(block.getBlock().get(), block.getContext().getFlammabilityBurnChance(), block.getContext().getFlammabilitySpreadChance());
        }
    }

    private final void registerStrippableBlocks() {
        for (BlockBuilder<? extends class_2248> block : this.registrate.getBlockRegistry().getEntries()) {
            Supplier<class_2248> other;
            if (block.getContext().getStrippableOther() == null) continue;
            if (!other.get().method_9564().method_28498((class_2769)class_2741.field_12496)) {
                throw new BadAttributeValueExpException((Object)"Output stripped block should have 'axis' property!");
            }
            if (!block.getBlock().get().method_9564().method_28498((class_2769)class_2741.field_12496)) {
                throw new BadAttributeValueExpException((Object)"Input stripped block should have 'axis' property!");
            }
            StrippableBlockRegistry.register((class_2248)block.getBlock().get(), (class_2248)other.get());
        }
    }

    private final void registerCompostableBlocks() {
        float amount;
        for (BlockBuilder<? extends class_2248> blockBuilder : this.registrate.getBlockRegistry().getEntries()) {
            amount = blockBuilder.getContext().getCompostableAmount();
            if (amount <= 0.0f) continue;
            try {
                CompostingChanceRegistry.INSTANCE.add((class_1935)blockBuilder.getBlock().get().method_8389(), (Object)Float.valueOf(amount));
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to add block " + blockBuilder.getBlock().get().method_9518() + " to compostables"));
            }
        }
        for (ItemBuilder itemBuilder : this.registrate.getItemRegistry().getEntries()) {
            amount = itemBuilder.getCompostableAmount();
            if (amount <= 0.0f) continue;
            try {
                CompostingChanceRegistry.INSTANCE.add((class_1935)itemBuilder.getItem().get(), (Object)Float.valueOf(amount));
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to add block " + ((class_1792)itemBuilder.getItem().get()).method_7876() + " to compostables"));
            }
        }
    }

    private final void registerDispenserBehaviors() {
        Object element$iv;
        Object $this$forEach$iv = DeltaboxSpawnEggItem.Companion.getMOD_EGGS();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            DeltaboxSpawnEggItem egg = (DeltaboxSpawnEggItem)((Object)element$iv);
            boolean bl = false;
            class_2357 behavior = egg.createDispenseBehavior();
            boolean bl2 = false;
            class_2315.method_10009((class_1935)((class_1935)egg), (class_2357)behavior);
            DeltaboxSpawnEggItem.Companion.getTYPE_MAP().put(egg.getTypeSupplier().get(), egg);
        }
        $this$forEach$iv = this.registrate.getDispenserBehaviorRegistry().getRegistries();
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            Supplier t = (Supplier)object.getKey();
            class_2357 u = (class_2357)object.getValue();
            class_2315.method_10009((class_1935)((class_1935)t.get()), (class_2357)u);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerCutoutRenders() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        BlockBuilder it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = this.registrate.getBlockRegistry().getEntries();
        class_1921 class_19212 = class_1921.method_23581();
        BlockRenderLayerMap blockRenderLayerMap = BlockRenderLayerMap.INSTANCE;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (BlockBuilder)element$iv$iv;
            boolean bl = false;
            if (!it.getContext().getHasCutoutRender()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection<class_2248> collection = (List)destination$iv$iv;
        $this$filter$iv = collection;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (BlockBuilder)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((class_2248)it.getBlock().get());
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        class_2248[] class_2248Array = thisCollection$iv.toArray(new class_2248[0]);
        blockRenderLayerMap.putBlocks(class_19212, Arrays.copyOf(class_2248Array, class_2248Array.length));
    }

    private final void registerBiomeColors() {
        for (BlockBuilder<? extends class_2248> block : this.registrate.getBlockRegistry().getEntries()) {
            if (!block.getContext().getHasBiomeColors()) continue;
            try {
                Object[] objectArray = new class_2248[]{block.getBlock().get()};
                ColorProviderRegistry.BLOCK.register(RegistrateInitFabric::registerBiomeColors$lambda$5, objectArray);
                objectArray = new class_1935[]{block.getBlock().get().method_8389()};
                ColorProviderRegistry.ITEM.register(RegistrateInitFabric::registerBiomeColors$lambda$6, objectArray);
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to add block " + block.getBlock().get().method_9518() + " to compostables"));
            }
        }
    }

    private final void registerParticleRenders() {
        for (ParticleRegistry.ParticleRegistration<? extends class_2394> particle : this.registrate.getParticleRegistry().getParticles()) {
            this.handleParticleRegistration(particle);
        }
    }

    private final void registerModelLayers() {
        for (String entry : this.registrate.getBoatVariantRegistry().getBoatVariants()) {
            EntityModelLayerRegistry.registerModelLayer((class_5601)new class_5601(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), "boat/" + entry), "main"), class_554::method_31985);
            EntityModelLayerRegistry.registerModelLayer((class_5601)new class_5601(DeltaboxUtil.INSTANCE.resourceLocation(this.registrate.getModId(), "chest_boat/" + entry), "main"), class_7752::method_45708);
        }
        for (Map.Entry entry : this.registrate.getModelLayersRegistry().getModelLayers().entrySet()) {
            String path = (String)entry.getKey();
            Pair data = (Pair)entry.getValue();
            Supplier model = (Supplier)data.component1();
            Supplier modelLayer = (Supplier)data.component2();
            EntityModelLayerRegistry.registerModelLayer((class_5601)((class_5601)modelLayer.get()), () -> RegistrateInitFabric.registerModelLayers$lambda$7((Supplier)model));
        }
    }

    private final void registerEntityAttributes() {
        for (EntityTypeBuilder<? extends class_1297> entityBuilder : this.registrate.getEntityTypeRegistry().getEntries()) {
            if (entityBuilder.getAttributeBuilderFactory() == null) continue;
            try {
                class_1299<? extends class_1297> class_12992 = entityBuilder.getEntity().get();
                Intrinsics.checkNotNull(class_12992, (String)"null cannot be cast to non-null type net.minecraft.world.entity.EntityType<out net.minecraft.world.entity.LivingEntity>");
                Function<AttributesUtil, class_5132.class_5133> function = entityBuilder.getAttributeBuilderFactory();
                Intrinsics.checkNotNull(function);
                FabricDefaultAttributeRegistry.register(class_12992, (class_5132)function.apply(AttributesUtil.INSTANCE).method_26866());
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to register entity " + entityBuilder.getEntityId() + " attributs, it may not be a living entity"));
            }
        }
    }

    private final void registerEntityRenderers() {
        for (EntityTypeBuilder<? extends class_1297> entityBuilder : this.registrate.getEntityTypeRegistry().getEntries()) {
            if (entityBuilder.getEntityRenderer() == null) continue;
            EntityRendererRegistry.register(entityBuilder.getEntity().get(), (class_5617)new class_5617(entityBuilder){
                final /* synthetic */ EntityTypeBuilder<? extends class_1297> $entityBuilder;
                {
                    this.$entityBuilder = $entityBuilder;
                }

                public final class_897<? super class_1297> create(class_5617.class_5618 ctx) {
                    Intrinsics.checkNotNull((Object)ctx);
                    return this.$entityBuilder.getRenderer(ctx);
                }
            });
        }
    }

    private final void registerBlockEntityRenderers() {
        for (BlockEntityBuilder<? extends class_2586> entityBuilder : this.registrate.getBlockEntityRegistry().getEntries()) {
            if (entityBuilder.getBlockEntityRenderer() == null) continue;
            class_5616.method_32144(entityBuilder.getBlockEntity().get(), (class_5614)new class_5614(entityBuilder){
                final /* synthetic */ BlockEntityBuilder<? extends class_2586> $entityBuilder;
                {
                    this.$entityBuilder = $entityBuilder;
                }

                public final class_827<? super class_2586> create(class_5614.class_5615 ctx) {
                    Intrinsics.checkNotNull((Object)ctx);
                    return this.$entityBuilder.getRenderer(ctx);
                }
            });
        }
    }

    private final <T extends class_2394> void handleParticleRegistration(ParticleRegistry.ParticleRegistration<T> registration) {
        ParticleFactoryRegistry.getInstance().register((class_2396)registration.getType().get(), arg_0 -> RegistrateInitFabric.handleParticleRegistration$lambda$8(registration.getProvider(), arg_0));
    }

    private final void registerBiomeModifiers() {
        Predicate biomeSelector;
        Object biomeModifier;
        String modifierName;
        for (Map.Entry<String, BiomeModifierCodec> entry : this.registrate.getBiomeModifierRegistry().getBiomeModifiers().entrySet()) {
            modifierName = entry.getKey();
            biomeModifier = entry.getValue();
            biomeSelector = BiomeSelectors.tag(((BiomeModifierCodec)biomeModifier).getBiomeTag());
            BiomeModifications.addFeature((Predicate)biomeSelector, (class_2893.class_2895)((BiomeModifierCodec)biomeModifier).getStep(), ((BiomeModifierCodec)biomeModifier).getFeature());
        }
        for (Map.Entry<String, Object> entry : this.registrate.getBiomeModifierRegistry().getBiomeSpawns().entrySet()) {
            class_1299 entity;
            modifierName = entry.getKey();
            biomeModifier = (BiomeSpawnCodec)entry.getValue();
            biomeSelector = BiomeSelectors.tag(((BiomeSpawnCodec)biomeModifier).getBiomeTag());
            if ((class_1299)class_7923.field_41177.method_29107(((BiomeSpawnCodec)biomeModifier).getType()) == null) continue;
            BiomeModifications.addSpawn((Predicate)biomeSelector, (class_1311)entity.method_5891(), (class_1299)entity, (int)((BiomeSpawnCodec)biomeModifier).getWeight(), (int)((BiomeSpawnCodec)biomeModifier).getMinCount(), (int)((BiomeSpawnCodec)biomeModifier).getMaxCount());
        }
    }

    private static final int registerBiomeColors$lambda$5(class_2680 state, class_1920 level, class_2338 pos, int tint) {
        return level != null && pos != null ? class_1163.method_4966((class_1920)level, (class_2338)pos) : class_1926.method_8341();
    }

    private static final int registerBiomeColors$lambda$6(class_1799 stack, int layer) {
        class_326 provider;
        class_326 class_3262 = provider = (class_326)ColorProviderRegistry.ITEM.get((Object)class_2246.field_10214);
        return class_3262 != null ? class_3262.getColor(stack, layer) : -1;
    }

    private static final class_5607 registerModelLayers$lambda$7(Supplier $model) {
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        return (class_5607)$model.get();
    }

    private static final class_707 handleParticleRegistration$lambda$8(Function1 $tmp0, FabricSpriteProvider p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (class_707)$tmp0.invoke((Object)p0);
    }
}

