/*
 * Decompiled with CFR 0.152.
 */
package com.dannbrown.deltaboxlib.content.entity.boat;

import com.dannbrown.deltaboxlib.content.entity.boat.BaseBoatEntity;
import com.dannbrown.deltaboxlib.content.entity.boat.BaseChestBoatEntity;
import com.dannbrown.deltaboxlib.registrate.util.DeltaboxUtil;
import com.mojang.datafixers.util.Pair;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4595;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7752;
import net.minecraft.class_7755;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J9\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e0\u00112\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J)\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u001aJ?\u0010%\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020 2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010'R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010(R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010)R\u0014\u0010\u0005\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010)\u00a8\u0006+"}, d2={"Lcom/dannbrown/deltaboxlib/content/entity/boat/BaseBoatRenderer;", "Lnet/minecraft/class_897;", "Lnet/minecraft/class_1690;", "", "modId", "variant", "Lnet/minecraft/class_5617$class_5618;", "context", "", "isChestBoat", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_5617$class_5618;Z)V", "pContext", "pChestBoat", "Lnet/minecraft/class_4595;", "createBoatModel", "(Lnet/minecraft/class_5617$class_5618;Ljava/lang/String;Z)Lnet/minecraft/class_4595;", "Lcom/mojang/datafixers/util/Pair;", "Lnet/minecraft/class_2960;", "createModelWithLocation", "(Ljava/lang/String;Lnet/minecraft/class_5617$class_5618;Z)Lcom/mojang/datafixers/util/Pair;", "boat", "getModelWithLocation", "(Lnet/minecraft/class_1690;)Lcom/mojang/datafixers/util/Pair;", "getTextureLocation", "()Lnet/minecraft/class_2960;", "(Lnet/minecraft/class_1690;)Lnet/minecraft/class_2960;", "", "yaw", "partialTicks", "Lnet/minecraft/class_4587;", "poseStack", "Lnet/minecraft/class_4597;", "bufferSource", "", "packedLight", "", "render", "(Lnet/minecraft/class_1690;FFLnet/minecraft/class_4587;Lnet/minecraft/class_4597;I)V", "Lnet/minecraft/class_5617$class_5618;", "Z", "Ljava/lang/String;", "Companion", "deltaboxlib-2.1.1-common-1.20.1"})
public final class BaseBoatRenderer
extends class_897<class_1690> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String modId;
    @NotNull
    private final String variant;
    @NotNull
    private final class_5617.class_5618 context;
    private final boolean isChestBoat;

    public BaseBoatRenderer(@NotNull String modId, @NotNull String variant, @NotNull class_5617.class_5618 context, boolean isChestBoat) {
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.modId = modId;
        this.variant = variant;
        this.context = context;
        this.isChestBoat = isChestBoat;
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull class_1690 boat) {
        Intrinsics.checkNotNullParameter((Object)boat, (String)"boat");
        if (boat instanceof BaseBoatEntity) {
            String variant = ((BaseBoatEntity)boat).getVariant();
            return DeltaboxUtil.INSTANCE.resourceLocation(this.modId, "textures/entity/boat/" + variant + ".png");
        }
        if (boat instanceof BaseChestBoatEntity) {
            String variant = ((BaseChestBoatEntity)boat).getVariant();
            return DeltaboxUtil.INSTANCE.resourceLocation(this.modId, "textures/entity/chest_boat/" + variant + ".png");
        }
        return DeltaboxUtil.INSTANCE.resourceLocation(this.modId, this.isChestBoat ? "textures/entity/chest_boat/" + this.variant + ".png" : "textures/entity/boat/" + this.variant + ".png");
    }

    @NotNull
    public final class_2960 getTextureLocation() {
        return DeltaboxUtil.INSTANCE.resourceLocation(this.modId, this.isChestBoat ? "textures/entity/chest_boat/" + this.variant + ".png" : "textures/entity/boat/" + this.variant + ".png");
    }

    @Nullable
    public final Pair<class_2960, class_4595<class_1690>> getModelWithLocation(@NotNull class_1690 boat) {
        Intrinsics.checkNotNullParameter((Object)boat, (String)"boat");
        if (boat instanceof BaseBoatEntity) {
            String variant = ((BaseBoatEntity)boat).getVariant();
            return this.createModelWithLocation(variant, this.context, this.isChestBoat);
        }
        if (boat instanceof BaseChestBoatEntity) {
            String variant = ((BaseChestBoatEntity)boat).getVariant();
            return this.createModelWithLocation(variant, this.context, true);
        }
        return null;
    }

    private final Pair<class_2960, class_4595<class_1690>> createModelWithLocation(String variant, class_5617.class_5618 pContext, boolean pChestBoat) {
        class_2960 texture = this.getTextureLocation();
        class_4595<class_1690> model = this.createBoatModel(pContext, variant, pChestBoat);
        Pair pair = Pair.of((Object)texture, model);
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"of(...)");
        return pair;
    }

    private final class_4595<class_1690> createBoatModel(class_5617.class_5618 pContext, String variant, boolean pChestBoat) {
        class_5601 modelLayerLocation = pChestBoat ? Companion.createChestBoatModelName(this.modId, variant) : Companion.createBoatModelName(this.modId, variant);
        class_630 modelPart = pContext.method_32167(modelLayerLocation);
        return pChestBoat ? (class_4595)new class_7752(modelPart) : (class_4595)new class_554(modelPart);
    }

    public void render(@NotNull class_1690 boat, float yaw, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight) {
        float bubbleAngle;
        Intrinsics.checkNotNullParameter((Object)boat, (String)"boat");
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.375f, 0.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f - yaw));
        float damageTime = (float)boat.method_7533() - partialTicks;
        float damage = boat.method_7554() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (damageTime > 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)damageTime) * damageTime * damage / 10.0f * (float)boat.method_7543()));
        }
        if (!class_3532.method_15347((float)(bubbleAngle = boat.method_7547(partialTicks)), (float)0.0f)) {
            poseStack.method_22907(new Quaternionf().setAngleAxis(bubbleAngle * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<class_2960, class_4595<class_1690>> pair = this.getModelWithLocation(boat);
        if (pair == null) {
            return;
        }
        Pair<class_2960, class_4595<class_1690>> alt = pair;
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        ((class_4595)alt.getSecond()).method_2819((class_1297)boat, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = bufferSource.getBuffer(((class_4595)alt.getSecond()).method_23500((class_2960)alt.getFirst()));
        ((class_4595)alt.getSecond()).method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!boat.method_5869()) {
            class_4588 waterBuffer = bufferSource.getBuffer(class_1921.method_23589());
            if (alt.getSecond() instanceof class_7755) {
                Object object = alt.getSecond();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.client.model.WaterPatchModel");
                ((class_7755)object).method_22954().method_22698(poseStack, waterBuffer, packedLight, class_4608.field_21444);
            }
        }
        poseStack.method_22909();
        super.method_3936((class_1297)boat, yaw, partialTicks, poseStack, bufferSource, packedLight);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\tJ'\u0010\r\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/dannbrown/deltaboxlib/content/entity/boat/BaseBoatRenderer$Companion;", "", "<init>", "()V", "", "modId", "variant", "Lnet/minecraft/class_5601;", "createBoatModelName", "(Ljava/lang/String;Ljava/lang/String;)Lnet/minecraft/class_5601;", "createChestBoatModelName", "path", "model", "createLocation", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lnet/minecraft/class_5601;", "deltaboxlib-2.1.1-common-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final class_5601 createBoatModelName(@NotNull String modId, @NotNull String variant) {
            Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            return this.createLocation(modId, "boat/" + variant, "main");
        }

        @NotNull
        public final class_5601 createChestBoatModelName(@NotNull String modId, @NotNull String variant) {
            Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            return this.createLocation(modId, "chest_boat/" + variant, "main");
        }

        private final class_5601 createLocation(String modId, String path, String model) {
            return new class_5601(DeltaboxUtil.INSTANCE.resourceLocation(modId, path), model);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

