/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IStyleStack;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.common.book.Book;

public class SpanState
implements IStyleStack {
    public final GuiBook gui;
    public final Book book;
    private class_2583 baseStyle;
    private final Deque<SpanPartialState> stateStack = new ArrayDeque<SpanPartialState>();
    public class_5250 tooltip = BookTextParser.EMPTY_STRING_COMPONENT;
    public Supplier<Boolean> onClick = null;
    public List<Span> cluster = null;
    public boolean isExternalLink = false;
    public boolean endingExternal = false;
    public int lineBreaks = 0;
    public int spacingLeft = 0;
    public int spacingRight = 0;
    public final int spaceWidth;

    public SpanState(GuiBook gui, Book book, class_2583 baseStyle) {
        this.gui = gui;
        this.book = book;
        this.baseStyle = baseStyle;
        this.stateStack.push(new SpanPartialState(baseStyle, null));
        this.spaceWidth = class_310.method_1551().field_1772.method_27525((class_5348)class_2561.method_43470((String)" ").method_10862(baseStyle));
    }

    public class_2583 getBase() {
        return this.baseStyle;
    }

    public void changeBaseStyle(class_2583 newStyle) {
        this.baseStyle = newStyle;
        for (SpanPartialState state : this.stateStack) {
            state.replaceBase(newStyle);
            newStyle = state.getCurrentStyle();
        }
    }

    public void color(class_5251 color) {
        this.modifyStyle(s -> s.method_27703(color));
    }

    public void baseColor() {
        this.color(this.baseStyle.method_10973());
    }

    @Override
    public void modifyStyle(UnaryOperator<class_2583> f) {
        this.stateStack.peek().addModification(f);
    }

    @Override
    public void pushStyle(class_2583 style) {
        this.stateStack.push(new SpanPartialState(style.method_27702(this.peekStyle()), style));
    }

    @Override
    public class_2583 popStyle() {
        if (this.stateStack.size() <= 1) {
            throw new IllegalStateException("Underflow in style stack");
        }
        return this.stateStack.pop().getCurrentStyle();
    }

    @Override
    public void reset() {
        this.endingExternal = this.isExternalLink;
        this.stateStack.clear();
        this.stateStack.push(new SpanPartialState(this.baseStyle, null));
        this.cluster = null;
        this.tooltip = BookTextParser.EMPTY_STRING_COMPONENT;
        this.onClick = null;
        this.isExternalLink = false;
    }

    @Override
    public class_2583 peekStyle() {
        return this.stateStack.peek().getCurrentStyle();
    }

    private static class SpanPartialState {
        private class_2583 currentStyle;
        @Nullable
        private final class_2583 mergeStyle;
        @Nullable
        private List<UnaryOperator<class_2583>> transformations = null;

        public SpanPartialState(class_2583 currentStyle, class_2583 mergeStyle) {
            this.currentStyle = currentStyle;
            this.mergeStyle = mergeStyle;
        }

        public class_2583 getCurrentStyle() {
            return this.currentStyle;
        }

        public void addModification(UnaryOperator<class_2583> f) {
            if (this.transformations == null) {
                this.transformations = new LinkedList<UnaryOperator<class_2583>>();
            }
            this.transformations.add(f);
            this.currentStyle = (class_2583)f.apply(this.currentStyle);
        }

        public void replaceBase(class_2583 style) {
            if (this.mergeStyle != null) {
                style = this.mergeStyle.method_27702(style);
            }
            if (this.transformations != null) {
                for (UnaryOperator<class_2583> f : this.transformations) {
                    style = (class_2583)f.apply(style);
                }
            }
            this.currentStyle = style;
        }
    }
}

