/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.inline;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.interop.inline.InlinePatternData;
import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.MatchContext;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.api.matching.RegexMatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;

public class HexPatternMatcher
implements RegexMatcher {
    private static final class_2960 patternMatcherID = HexAPI.modLoc("pattern");
    private static final MatcherInfo patternMatcherInfo = MatcherInfo.fromId((class_2960)patternMatcherID);
    private static final Pattern PATTERN_PATTERN_REGEX = Pattern.compile("(?<escaped>\\\\?)(?:HexPattern)?[<(\\[{]\\s*(?<direction>[a-zA-Z_-]+)(?:\\s*(?<sizemod>[,!+:; ])\\s*(?<pattern>[aqwedsAQWEDS]+)?)\\s*[>)\\]}]", 2);
    public static HexPatternMatcher INSTANCE = new HexPatternMatcher();
    private static final Map<String, HexDir> dirMap = new HashMap<String, HexDir>();

    public Pattern getRegex() {
        return PATTERN_PATTERN_REGEX;
    }

    @NotNull
    public class_3545<InlineMatch, Integer> getMatchAndGroup(MatchResult regexMatch, MatchContext ctx) {
        String escaped = regexMatch.group(1);
        String dirString = regexMatch.group(2).toLowerCase().strip().replace("_", "");
        String sizeModString = regexMatch.group(3);
        String angleSigs = regexMatch.group(4);
        if (escaped == null) {
            return new class_3545((Object)new InlineMatch.TextMatch((class_2561)class_2561.method_43470((String)"")), (Object)1);
        }
        HexDir dir = dirMap.get(dirString);
        if (dir == null) {
            return new class_3545(null, (Object)0);
        }
        if (angleSigs == null) {
            angleSigs = "";
        }
        try {
            HexPattern pat = HexPattern.fromAngles(angleSigs.toLowerCase(), dir);
            InlinePatternData patData = new InlinePatternData(pat);
            class_2583 patDataStyle = patData.getExtraStyle();
            if (sizeModString != null && sizeModString.equals("+")) {
                patDataStyle = InlineAPI.INSTANCE.withSizeModifier(patDataStyle, 2.0);
            }
            if (sizeModString != null && sizeModString.equals("!")) {
                patDataStyle = InlineAPI.INSTANCE.withSizeModifier(patDataStyle, 1.5);
            }
            return new class_3545((Object)new InlineMatch.DataMatch((InlineData)patData, patDataStyle), (Object)0);
        }
        catch (Exception e) {
            return new class_3545(null, (Object)0);
        }
    }

    @Nullable
    public InlineMatch getMatch(MatchResult mr, MatchContext ctx) {
        return null;
    }

    public MatcherInfo getInfo() {
        return patternMatcherInfo;
    }

    public class_2960 getId() {
        return patternMatcherID;
    }

    static {
        dirMap.put("northwest", HexDir.NORTH_WEST);
        dirMap.put("west", HexDir.WEST);
        dirMap.put("southwest", HexDir.SOUTH_WEST);
        dirMap.put("southeast", HexDir.SOUTH_EAST);
        dirMap.put("east", HexDir.EAST);
        dirMap.put("northeast", HexDir.NORTH_EAST);
        dirMap.put("nw", HexDir.NORTH_WEST);
        dirMap.put("w", HexDir.WEST);
        dirMap.put("sw", HexDir.SOUTH_WEST);
        dirMap.put("se", HexDir.SOUTH_EAST);
        dirMap.put("e", HexDir.EAST);
        dirMap.put("ne", HexDir.NORTH_EAST);
    }
}

