/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.fabric.xplat;

import at.petrak.hexcasting.api.addldata.ADHexHolder;
import at.petrak.hexcasting.api.addldata.ADIotaHolder;
import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.addldata.ADVariantItem;
import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.castables.SpecialHandler;
import at.petrak.hexcasting.api.casting.eval.ResolvedPattern;
import at.petrak.hexcasting.api.casting.eval.sideeffects.EvalSound;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.eval.vm.ContinuationFrame;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.pigment.ColorProvider;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.AltioraAbility;
import at.petrak.hexcasting.api.player.FlightAbility;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.common.lib.HexRegistries;
import at.petrak.hexcasting.common.msgs.IMessage;
import at.petrak.hexcasting.fabric.cc.CCAltiora;
import at.petrak.hexcasting.fabric.cc.CCBrainswept;
import at.petrak.hexcasting.fabric.cc.CCFavoredPigment;
import at.petrak.hexcasting.fabric.cc.CCFlight;
import at.petrak.hexcasting.fabric.cc.CCPatterns;
import at.petrak.hexcasting.fabric.cc.CCSentinel;
import at.petrak.hexcasting.fabric.cc.CCStaffcastImage;
import at.petrak.hexcasting.fabric.cc.HexCardinalComponents;
import at.petrak.hexcasting.fabric.interop.trinkets.TrinketsApiInterop;
import at.petrak.hexcasting.fabric.recipe.FabricUnsealedIngredient;
import at.petrak.hexcasting.interop.pehkui.PehkuiInterop;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import at.petrak.hexcasting.xplat.IXplatTags;
import at.petrak.hexcasting.xplat.Platform;
import com.google.common.base.Suppliers;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Lifecycle;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1832;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2073;
import net.minecraft.class_223;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2348;
import net.minecraft.class_2350;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_8551;
import org.jetbrains.annotations.Nullable;
import virtuoel.pehkui.api.ScaleTypes;

public class FabricXplatImpl
implements IXplatAbstractions {
    private static final List<List<class_1799>> HARVEST_TOOLS_BY_LEVEL = List.of(FabricXplatImpl.stacks(class_1802.field_8647, class_1802.field_8406, class_1802.field_8167, class_1802.field_8876), FabricXplatImpl.stacks(class_1802.field_8387, class_1802.field_8062, class_1802.field_8431, class_1802.field_8776), FabricXplatImpl.stacks(class_1802.field_8403, class_1802.field_8475, class_1802.field_8609, class_1802.field_8699), FabricXplatImpl.stacks(class_1802.field_8377, class_1802.field_8556, class_1802.field_8527, class_1802.field_8250), FabricXplatImpl.stacks(class_1802.field_22024, class_1802.field_22025, class_1802.field_22026, class_1802.field_22023));
    private static final IXplatTags TAGS = new IXplatTags(){

        @Override
        public class_6862<class_1792> amethystDust() {
            return HexTags.Items.create(new class_2960("c", "amethyst_dusts"));
        }

        @Override
        public class_6862<class_1792> gems() {
            return HexTags.Items.create(new class_2960("c", "gems"));
        }
    };
    private static final Supplier<class_2378<ActionRegistryEntry>> ACTION_REGISTRY = Suppliers.memoize(() -> FabricRegistryBuilder.from((class_2385)new class_2370(HexRegistries.ACTION, Lifecycle.stable())).buildAndRegister());
    private static final Supplier<class_2378<SpecialHandler.Factory<?>>> SPECIAL_HANDLER_REGISTRY = Suppliers.memoize(() -> FabricRegistryBuilder.from((class_2385)new class_2370(HexRegistries.SPECIAL_HANDLER, Lifecycle.stable())).buildAndRegister());
    private static final Supplier<class_2378<IotaType<?>>> IOTA_TYPE_REGISTRY = Suppliers.memoize(() -> FabricRegistryBuilder.from((class_2385)new class_2348("hexcasting:null", HexRegistries.IOTA_TYPE, Lifecycle.stable(), false)).buildAndRegister());
    private static final Supplier<class_2378<Arithmetic>> ARITHMETIC_REGISTRY = Suppliers.memoize(() -> FabricRegistryBuilder.from((class_2385)new class_2370(HexRegistries.ARITHMETIC, Lifecycle.stable())).buildAndRegister());
    private static final Supplier<class_2378<ContinuationFrame.Type<?>>> CONTINUATION_TYPE_REGISTRY = Suppliers.memoize(() -> FabricRegistryBuilder.from((class_2385)new class_2348("hexcasting:end", HexRegistries.CONTINUATION_TYPE, Lifecycle.stable(), false)).buildAndRegister());
    private static final Supplier<class_2378<EvalSound>> EVAL_SOUNDS_REGISTRY = Suppliers.memoize(() -> FabricRegistryBuilder.from((class_2385)new class_2348("hexcasting:nothing", HexRegistries.EVAL_SOUND, Lifecycle.stable(), false)).buildAndRegister());
    private static PehkuiInterop.ApiAbstraction PEHKUI_API = null;

    @Override
    public Platform platform() {
        return Platform.FABRIC;
    }

    @Override
    public boolean isPhysicalClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    @Override
    public boolean isModPresent(String id) {
        return FabricLoader.getInstance().isModLoaded(id);
    }

    @Override
    public void initPlatformSpecific() {
        if (this.isModPresent("trinkets")) {
            TrinketsApiInterop.init();
        }
    }

    @Override
    public void sendPacketToPlayer(class_3222 target, IMessage packet) {
        ServerPlayNetworking.send((class_3222)target, (class_2960)packet.getFabricId(), (class_2540)packet.toBuf());
    }

    @Override
    public void sendPacketNear(class_243 pos, double radius, class_3218 dimension, IMessage packet) {
        this.sendPacketToPlayers(PlayerLookup.around((class_3218)dimension, (class_243)pos, (double)radius), packet);
    }

    @Override
    public void sendPacketTracking(class_1297 entity, IMessage packet) {
        this.sendPacketToPlayers(PlayerLookup.tracking((class_1297)entity), packet);
    }

    private void sendPacketToPlayers(Collection<class_3222> players, IMessage packet) {
        class_2596 pkt = ServerPlayNetworking.createS2CPacket((class_2960)packet.getFabricId(), (class_2540)packet.toBuf());
        for (class_3222 p : players) {
            p.field_13987.method_14364(pkt);
        }
    }

    @Override
    public class_2596<class_2602> toVanillaClientboundPacket(IMessage message) {
        return ServerPlayNetworking.createS2CPacket((class_2960)message.getFabricId(), (class_2540)message.toBuf());
    }

    @Override
    public void setBrainsweepAddlData(class_1308 mob) {
        CCBrainswept cc = (CCBrainswept)HexCardinalComponents.BRAINSWEPT.get((Object)mob);
        cc.setBrainswept(true);
    }

    @Override
    @Nullable
    public FrozenPigment setPigment(class_1657 target, @Nullable FrozenPigment pigment) {
        CCFavoredPigment cc = (CCFavoredPigment)HexCardinalComponents.FAVORED_PIGMENT.get((Object)target);
        FrozenPigment old = cc.getPigment();
        cc.setPigment(pigment);
        return old;
    }

    @Override
    public void setSentinel(class_1657 target, @Nullable Sentinel sentinel) {
        CCSentinel cc = (CCSentinel)HexCardinalComponents.SENTINEL.get((Object)target);
        cc.setSentinel(sentinel);
    }

    @Override
    public void setFlight(class_3222 target, FlightAbility flight) {
        CCFlight cc = (CCFlight)HexCardinalComponents.FLIGHT.get((Object)target);
        cc.setFlight(flight);
    }

    @Override
    public void setAltiora(class_1657 target, @Nullable AltioraAbility altiora) {
        CCAltiora cc = (CCAltiora)HexCardinalComponents.ALTIORA.get((Object)target);
        cc.setAltiora(altiora);
    }

    @Override
    public void setStaffcastImage(class_3222 target, CastingImage image) {
        CCStaffcastImage cc = (CCStaffcastImage)HexCardinalComponents.STAFFCAST_IMAGE.get((Object)target);
        cc.setImage(image);
    }

    @Override
    public void setPatterns(class_3222 target, List<ResolvedPattern> patterns) {
        CCPatterns cc = (CCPatterns)HexCardinalComponents.PATTERNS.get((Object)target);
        cc.setPatterns(patterns);
    }

    @Override
    public boolean isBrainswept(class_1308 mob) {
        CCBrainswept cc = (CCBrainswept)HexCardinalComponents.BRAINSWEPT.get((Object)mob);
        return cc.isBrainswept();
    }

    @Override
    @Nullable
    public FlightAbility getFlight(class_3222 player) {
        CCFlight cc = (CCFlight)HexCardinalComponents.FLIGHT.get((Object)player);
        return cc.getFlight();
    }

    @Override
    @Nullable
    public AltioraAbility getAltiora(class_1657 player) {
        CCAltiora cc = (CCAltiora)HexCardinalComponents.ALTIORA.get((Object)player);
        return cc.getAltiora();
    }

    @Override
    public FrozenPigment getPigment(class_1657 player) {
        CCFavoredPigment cc = (CCFavoredPigment)HexCardinalComponents.FAVORED_PIGMENT.get((Object)player);
        return cc.getPigment();
    }

    @Override
    public Sentinel getSentinel(class_1657 player) {
        CCSentinel cc = (CCSentinel)HexCardinalComponents.SENTINEL.get((Object)player);
        return cc.getSentinel();
    }

    @Override
    public CastingVM getStaffcastVM(class_3222 player, class_1268 hand) {
        CCStaffcastImage cc = (CCStaffcastImage)HexCardinalComponents.STAFFCAST_IMAGE.get((Object)player);
        return cc.getVM(hand);
    }

    @Override
    public List<ResolvedPattern> getPatternsSavedInUi(class_3222 player) {
        CCPatterns cc = (CCPatterns)HexCardinalComponents.PATTERNS.get((Object)player);
        return cc.getPatterns();
    }

    @Override
    public void clearCastingData(class_3222 player) {
        this.setStaffcastImage(player, null);
        this.setPatterns(player, List.of());
    }

    @Override
    @Nullable
    public ADMediaHolder findMediaHolder(class_1799 stack) {
        Optional cc = HexCardinalComponents.MEDIA_HOLDER.maybeGet((Object)stack);
        return cc.orElse(null);
    }

    @Override
    @Nullable
    public ADMediaHolder findMediaHolder(class_3222 player) {
        Optional cc = HexCardinalComponents.MEDIA_HOLDER.maybeGet((Object)player);
        return cc.orElse(null);
    }

    @Override
    @Nullable
    public ADIotaHolder findDataHolder(class_1799 stack) {
        Optional cc = HexCardinalComponents.IOTA_HOLDER.maybeGet((Object)stack);
        return cc.orElse(null);
    }

    @Override
    @Nullable
    public ADIotaHolder findDataHolder(class_1297 entity) {
        Optional cc = HexCardinalComponents.IOTA_HOLDER.maybeGet((Object)entity);
        return cc.orElse(null);
    }

    @Override
    @Nullable
    public ADHexHolder findHexHolder(class_1799 stack) {
        Optional cc = HexCardinalComponents.HEX_HOLDER.maybeGet((Object)stack);
        return cc.orElse(null);
    }

    @Override
    @Nullable
    public ADVariantItem findVariantHolder(class_1799 stack) {
        Optional cc = HexCardinalComponents.VARIANT_ITEM.maybeGet((Object)stack);
        return cc.orElse(null);
    }

    @Override
    public boolean isPigment(class_1799 stack) {
        return HexCardinalComponents.PIGMENT.isProvidedBy((Object)stack);
    }

    @Override
    public ColorProvider getColorProvider(FrozenPigment pigment) {
        Optional cc = HexCardinalComponents.PIGMENT.maybeGet((Object)pigment.item());
        return cc.map(col -> col.provideColor(pigment.owner())).orElse(ColorProvider.MISSING);
    }

    @Override
    public <T extends class_2586> class_2591<T> createBlockEntityType(BiFunction<class_2338, class_2680, T> func, class_2248 ... blocks) {
        return FabricBlockEntityTypeBuilder.create(func::apply, (class_2248[])blocks).build();
    }

    @Override
    public boolean tryPlaceFluid(class_1937 level, class_1268 hand, class_2338 pos, class_3611 fluid) {
        Storage target = (Storage)FluidStorage.SIDED.find(level, pos, (Object)class_2350.field_11036);
        if (target == null) {
            return false;
        }
        try (Transaction transaction = Transaction.openOuter();){
            long insertedAmount = target.insert((Object)FluidVariant.of((class_3611)fluid), 81000L, (TransactionContext)transaction);
            if (insertedAmount > 0L) {
                transaction.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean drainAllFluid(class_1937 level, class_2338 pos) {
        Storage target = (Storage)FluidStorage.SIDED.find(level, pos, (Object)class_2350.field_11036);
        if (target == null) {
            return false;
        }
        try (Transaction transaction = Transaction.openOuter();){
            boolean any = false;
            for (StorageView view : target) {
                long extracted = view.extract((Object)((FluidVariant)view.getResource()), view.getAmount(), (TransactionContext)transaction);
                if (extracted <= 0L) continue;
                any = true;
            }
            if (any) {
                transaction.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public class_1856 getUnsealedIngredient(class_1799 stack) {
        return FabricUnsealedIngredient.of(stack);
    }

    private static List<class_1799> stacks(class_1792 ... items) {
        return Stream.of(items).map(class_1799::new).toList();
    }

    @Override
    public boolean isCorrectTierForDrops(class_1832 tier, class_2680 bs) {
        if (!bs.method_29291()) {
            return true;
        }
        int level = HexConfig.server().opBreakHarvestLevelBecauseForgeThoughtItWasAGoodIdeaToImplementHarvestTiersUsingAnHonestToGodTopoSort();
        for (class_1799 tool : HARVEST_TOOLS_BY_LEVEL.get(level)) {
            if (!tool.method_7951(bs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_1792.class_1793 addEquipSlotFabric(class_1304 slot) {
        return new FabricItemSettings().equipmentSlot(s -> slot);
    }

    @Override
    public IXplatTags tags() {
        return TAGS;
    }

    @Override
    public class_5341.class_210 isShearsCondition() {
        return class_8551.method_51727((class_5341.class_210[])new class_5341.class_210[]{class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8977(new class_1935[]{class_1802.field_8868})), class_223.method_945((class_2073.class_2074)class_2073.class_2074.method_8973().method_8975(HexTags.Items.create(new class_2960("c", "shears"))))});
    }

    @Override
    public String getModName(String namespace) {
        if (namespace.equals("c")) {
            return "Common";
        }
        Optional container = FabricLoader.getInstance().getModContainer(namespace);
        if (container.isPresent()) {
            return ((ModContainer)container.get()).getMetadata().getName();
        }
        return namespace;
    }

    @Override
    public class_2378<ActionRegistryEntry> getActionRegistry() {
        return ACTION_REGISTRY.get();
    }

    @Override
    public class_2378<SpecialHandler.Factory<?>> getSpecialHandlerRegistry() {
        return SPECIAL_HANDLER_REGISTRY.get();
    }

    @Override
    public class_2378<IotaType<?>> getIotaTypeRegistry() {
        return IOTA_TYPE_REGISTRY.get();
    }

    @Override
    public class_2378<Arithmetic> getArithmeticRegistry() {
        return ARITHMETIC_REGISTRY.get();
    }

    @Override
    public class_2378<ContinuationFrame.Type<?>> getContinuationTypeRegistry() {
        return CONTINUATION_TYPE_REGISTRY.get();
    }

    @Override
    public class_2378<EvalSound> getEvalSoundRegistry() {
        return EVAL_SOUNDS_REGISTRY.get();
    }

    @Override
    public boolean isBreakingAllowed(class_3218 world, class_2338 pos, class_2680 state, @Nullable class_1657 player) {
        if (player == null) {
            player = FakePlayer.get((class_3218)world, (GameProfile)HEXCASTING);
        }
        return ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak((class_1937)world, player, pos, state, world.method_8321(pos));
    }

    @Override
    public boolean isPlacingAllowed(class_3218 world, class_2338 pos, class_1799 blockStack, @Nullable class_1657 player) {
        if (player == null) {
            player = FakePlayer.get((class_3218)world, (GameProfile)HEXCASTING);
        }
        class_1799 cached = player.method_6047();
        player.method_6122(class_1268.field_5808, blockStack.method_7972());
        class_1271 success2 = ((UseItemCallback)UseItemCallback.EVENT.invoker()).interact(player, (class_1937)world, class_1268.field_5808);
        player.method_6122(class_1268.field_5808, cached);
        return success2.method_5467() == class_1269.field_5811;
    }

    @Override
    public PehkuiInterop.ApiAbstraction getPehkuiApi() {
        if (!this.isModPresent("pehkui")) {
            throw new IllegalArgumentException("cannot get the pehkui api without pehkui");
        }
        if (PEHKUI_API == null) {
            PEHKUI_API = new PehkuiInterop.ApiAbstraction(){

                @Override
                public float getScale(class_1297 e) {
                    return ScaleTypes.BASE.getScaleData(e).getScale();
                }

                @Override
                public void setScale(class_1297 e, float scale) {
                    ScaleTypes.BASE.getScaleData(e).setScale(scale);
                }
            };
        }
        return PEHKUI_API;
    }
}

