/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.fabric.cc.adimpl;

import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.fabric.cc.HexCardinalComponents;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public abstract class CCMediaHolder
extends ItemComponent
implements ADMediaHolder {
    public CCMediaHolder(class_1799 stack) {
        super(stack, HexCardinalComponents.MEDIA_HOLDER);
    }

    public static class Static
    extends CCMediaHolder {
        private final Supplier<Long> baseWorth;
        private final int consumptionPriority;

        public Static(Supplier<Long> baseWorth, int consumptionPriority, class_1799 stack) {
            super(stack);
            this.baseWorth = baseWorth;
            this.consumptionPriority = consumptionPriority;
        }

        @Override
        public long getMedia() {
            return this.baseWorth.get() * (long)this.stack.method_7947();
        }

        @Override
        public long getMaxMedia() {
            return this.getMedia();
        }

        @Override
        public void setMedia(long media) {
        }

        @Override
        public boolean canRecharge() {
            return false;
        }

        @Override
        public boolean canProvide() {
            return true;
        }

        @Override
        public int getConsumptionPriority() {
            return this.consumptionPriority;
        }

        @Override
        public boolean canConstructBattery() {
            return true;
        }

        @Override
        public long withdrawMedia(long cost, boolean simulate) {
            long worth = this.baseWorth.get();
            if (cost < 0L) {
                cost = worth * (long)this.stack.method_7947();
            }
            double itemsRequired = (double)cost / (double)worth;
            int itemsUsed = Math.min((int)Math.ceil(itemsRequired), this.stack.method_7947());
            if (!simulate) {
                this.stack.method_7934(itemsUsed);
            }
            return (long)itemsUsed * worth;
        }
    }

    public static class ItemBased
    extends CCMediaHolder {
        private final MediaHolderItem mediaHolder;

        public ItemBased(class_1799 stack) {
            super(stack);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof MediaHolderItem)) {
                throw new IllegalStateException("item is not a media holder: " + stack);
            }
            MediaHolderItem media = (MediaHolderItem)class_17922;
            this.mediaHolder = media;
        }

        @Override
        public long getMedia() {
            return this.mediaHolder.getMedia(this.stack);
        }

        @Override
        public long getMaxMedia() {
            return this.mediaHolder.getMaxMedia(this.stack);
        }

        @Override
        public void setMedia(long media) {
            this.mediaHolder.setMedia(this.stack, media);
        }

        @Override
        public boolean canRecharge() {
            return this.mediaHolder.canRecharge(this.stack);
        }

        @Override
        public boolean canProvide() {
            return this.mediaHolder.canProvideMedia(this.stack);
        }

        @Override
        public int getConsumptionPriority() {
            return this.mediaHolder.getConsumptionPriority(this.stack);
        }

        @Override
        public boolean canConstructBattery() {
            return false;
        }

        @Override
        public long withdrawMedia(long cost, boolean simulate) {
            return this.mediaHolder.withdrawMedia(this.stack, cost, simulate);
        }

        @Override
        public long insertMedia(long amount, boolean simulate) {
            return this.mediaHolder.insertMedia(this.stack, amount, simulate);
        }
    }
}

