/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.items.ItemJewelerHammer;
import at.petrak.hexcasting.common.items.ItemLens;
import at.petrak.hexcasting.common.items.ItemLoreFragment;
import at.petrak.hexcasting.common.items.ItemStaff;
import at.petrak.hexcasting.common.items.magic.ItemArtifact;
import at.petrak.hexcasting.common.items.magic.ItemCreativeUnlocker;
import at.petrak.hexcasting.common.items.magic.ItemCypher;
import at.petrak.hexcasting.common.items.magic.ItemMediaBattery;
import at.petrak.hexcasting.common.items.magic.ItemTrinket;
import at.petrak.hexcasting.common.items.pigment.ItemAmethystAndCopperPigment;
import at.petrak.hexcasting.common.items.pigment.ItemDyePigment;
import at.petrak.hexcasting.common.items.pigment.ItemPridePigment;
import at.petrak.hexcasting.common.items.pigment.ItemUUIDPigment;
import at.petrak.hexcasting.common.items.storage.ItemAbacus;
import at.petrak.hexcasting.common.items.storage.ItemFocus;
import at.petrak.hexcasting.common.items.storage.ItemScroll;
import at.petrak.hexcasting.common.items.storage.ItemSlate;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import at.petrak.hexcasting.common.items.storage.ItemThoughtKnot;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexCreativeTabs;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Nullable;

public class HexItems {
    private static final Map<class_2960, class_1792> ITEMS = new LinkedHashMap<class_2960, class_1792>();
    private static final Map<class_1761, List<TabEntry>> ITEM_TABS = new LinkedHashMap<class_1761, List<TabEntry>>();
    public static final class_1792 AMETHYST_DUST = HexItems.make("amethyst_dust", new class_1792(HexItems.props()));
    public static final class_1792 CHARGED_AMETHYST = HexItems.make("charged_amethyst", new class_1792(HexItems.props()));
    public static final class_1792 QUENCHED_SHARD = HexItems.make("quenched_allay_shard", new class_1792(HexItems.props()));
    public static final ItemStaff STAFF_OAK = HexItems.make("staff/oak", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_SPRUCE = HexItems.make("staff/spruce", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_BIRCH = HexItems.make("staff/birch", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_JUNGLE = HexItems.make("staff/jungle", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_ACACIA = HexItems.make("staff/acacia", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_DARK_OAK = HexItems.make("staff/dark_oak", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_CRIMSON = HexItems.make("staff/crimson", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_WARPED = HexItems.make("staff/warped", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_MANGROVE = HexItems.make("staff/mangrove", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_CHERRY = HexItems.make("staff/cherry", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_BAMBOO = HexItems.make("staff/bamboo", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_EDIFIED = HexItems.make("staff/edified", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_QUENCHED = HexItems.make("staff/quenched", new ItemStaff(HexItems.unstackable()));
    public static final ItemStaff STAFF_MINDSPLICE = HexItems.make("staff/mindsplice", new ItemStaff(HexItems.unstackable()));
    public static final ItemLens SCRYING_LENS = HexItems.make("lens", new ItemLens(IXplatAbstractions.INSTANCE.addEquipSlotFabric(class_1304.field_6169).method_7889(1)));
    public static final ItemAbacus ABACUS = HexItems.make("abacus", new ItemAbacus(HexItems.unstackable()));
    public static final ItemThoughtKnot THOUGHT_KNOT = HexItems.make("thought_knot", new ItemThoughtKnot(HexItems.unstackable()));
    public static final ItemFocus FOCUS = HexItems.make("focus", new ItemFocus(HexItems.unstackable()));
    public static final ItemSpellbook SPELLBOOK = HexItems.make("spellbook", new ItemSpellbook(HexItems.unstackable()));
    public static final ItemCypher CYPHER = HexItems.make("cypher", new ItemCypher(HexItems.unstackable()));
    public static final ItemTrinket TRINKET = HexItems.make("trinket", new ItemTrinket(HexItems.unstackable().method_7894(class_1814.field_8907)));
    public static final ItemArtifact ARTIFACT = HexItems.make("artifact", new ItemArtifact(HexItems.unstackable().method_7894(class_1814.field_8903)));
    public static final ItemJewelerHammer JEWELER_HAMMER = HexItems.make("jeweler_hammer", new ItemJewelerHammer((class_1832)class_1834.field_8923, 0, -2.8f, HexItems.props().method_7889(1).method_7898(class_1834.field_8930.method_8025())));
    public static final ItemScroll SCROLL_SMOL = HexItems.make("scroll_small", new ItemScroll(HexItems.props(), 1));
    public static final ItemScroll SCROLL_MEDIUM = HexItems.make("scroll_medium", new ItemScroll(HexItems.props(), 2));
    public static final ItemScroll SCROLL_LARGE = HexItems.make("scroll", new ItemScroll(HexItems.props(), 3));
    public static final ItemSlate SLATE = HexItems.make("slate", new ItemSlate(HexBlocks.SLATE, HexItems.props()));
    public static final ItemMediaBattery BATTERY = HexItems.make("battery", new ItemMediaBattery(HexItems.unstackable()), null);
    public static final Supplier<class_1799> BATTERY_DUST_STACK = HexItems.addToTab(() -> ItemMediaBattery.withMedia(new class_1799((class_1935)BATTERY), 640000L, 640000L), HexCreativeTabs.HEX);
    public static final Supplier<class_1799> BATTERY_SHARD_STACK = HexItems.addToTab(() -> ItemMediaBattery.withMedia(new class_1799((class_1935)BATTERY), 3200000L, 3200000L), HexCreativeTabs.HEX);
    public static final Supplier<class_1799> BATTERY_CRYSTAL_STACK = HexItems.addToTab(() -> ItemMediaBattery.withMedia(new class_1799((class_1935)BATTERY), 6400000L, 6400000L), HexCreativeTabs.HEX);
    public static final Supplier<class_1799> BATTERY_QUENCHED_SHARD_STACK = HexItems.addToTab(() -> ItemMediaBattery.withMedia(new class_1799((class_1935)BATTERY), 19200000L, 19200000L), HexCreativeTabs.HEX);
    public static final Supplier<class_1799> BATTERY_QUENCHED_BLOCK_STACK = HexItems.addToTab(() -> ItemMediaBattery.withMedia(new class_1799((class_1935)BATTERY), 76800000L, 76800000L), HexCreativeTabs.HEX);
    public static final EnumMap<class_1767, ItemDyePigment> DYE_PIGMENTS = (EnumMap)class_156.method_656(() -> {
        EnumMap<class_1767, ItemDyePigment> out = new EnumMap<class_1767, ItemDyePigment>(class_1767.class);
        for (class_1767 dye : class_1767.values()) {
            out.put(dye, HexItems.make("dye_colorizer_" + dye.method_7792(), new ItemDyePigment(dye, HexItems.unstackable())));
        }
        return out;
    });
    public static final EnumMap<ItemPridePigment.Type, ItemPridePigment> PRIDE_PIGMENTS = (EnumMap)class_156.method_656(() -> {
        EnumMap<ItemPridePigment.Type, ItemPridePigment> out = new EnumMap<ItemPridePigment.Type, ItemPridePigment>(ItemPridePigment.Type.class);
        for (ItemPridePigment.Type politicsInMyVidya : ItemPridePigment.Type.values()) {
            out.put(politicsInMyVidya, HexItems.make("pride_colorizer_" + politicsInMyVidya.getName(), new ItemPridePigment(politicsInMyVidya, HexItems.unstackable())));
        }
        return out;
    });
    public static final class_1792 UUID_PIGMENT = HexItems.make("uuid_colorizer", new ItemUUIDPigment(HexItems.unstackable()));
    public static final class_1792 DEFAULT_PIGMENT = HexItems.make("default_colorizer", new ItemAmethystAndCopperPigment(HexItems.unstackable()));
    public static final class_1792 SUBMARINE_SANDWICH = HexItems.make("sub_sandwich", new class_1792(HexItems.props().method_19265(new class_4174.class_4175().method_19238(14).method_19237(1.2f).method_19242())));
    public static final ItemLoreFragment LORE_FRAGMENT = HexItems.make("lore_fragment", new ItemLoreFragment(HexItems.unstackable().method_7894(class_1814.field_8903)));
    public static final ItemCreativeUnlocker CREATIVE_UNLOCKER = HexItems.make("creative_unlocker", new ItemCreativeUnlocker(HexItems.unstackable().method_7894(class_1814.field_8904).method_19265(new class_4174.class_4175().method_19238(20).method_19237(1.0f).method_19240().method_19242())));

    public static void registerItems(BiConsumer<class_1792, class_2960> r) {
        for (Map.Entry<class_2960, class_1792> e : ITEMS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    public static void registerItemCreativeTab(class_1761.class_7704 r, class_1761 tab) {
        for (TabEntry item : ITEM_TABS.getOrDefault(tab, List.of())) {
            item.register(r);
        }
    }

    public static class_1792.class_1793 props() {
        return new class_1792.class_1793();
    }

    public static class_1792.class_1793 unstackable() {
        return HexItems.props().method_7889(1);
    }

    private static <T extends class_1792> T make(class_2960 id, T item, @Nullable class_1761 tab) {
        class_1792 old = ITEMS.put(id, item);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        if (tab != null) {
            ITEM_TABS.computeIfAbsent(tab, t -> new ArrayList()).add(new TabEntry.ItemEntry(item));
        }
        return item;
    }

    private static <T extends class_1792> T make(String id, T item, @Nullable class_1761 tab) {
        return HexItems.make(HexAPI.modLoc(id), item, tab);
    }

    private static <T extends class_1792> T make(String id, T item) {
        return HexItems.make(HexAPI.modLoc(id), item, HexCreativeTabs.HEX);
    }

    private static Supplier<class_1799> addToTab(Supplier<class_1799> stack, class_1761 tab) {
        com.google.common.base.Supplier memoised = Suppliers.memoize(stack::get);
        ITEM_TABS.computeIfAbsent(tab, t -> new ArrayList()).add(new TabEntry.StackEntry((Supplier<class_1799>)memoised));
        return memoised;
    }

    private static abstract class TabEntry {
        private TabEntry() {
        }

        abstract void register(class_1761.class_7704 var1);

        static class StackEntry
        extends TabEntry {
            private final Supplier<class_1799> stack;

            StackEntry(Supplier<class_1799> stack) {
                this.stack = stack;
            }

            @Override
            void register(class_1761.class_7704 r) {
                r.method_45420(this.stack.get());
            }
        }

        static class ItemEntry
        extends TabEntry {
            private final class_1792 item;

            ItemEntry(class_1792 item) {
                this.item = item;
            }

            @Override
            void register(class_1761.class_7704 r) {
                r.method_45421((class_1935)this.item);
            }
        }
    }
}

