/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.eval.ExecutionClientView;
import at.petrak.hexcasting.api.casting.eval.env.PackagedItemCastEnv;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.item.HexHolderItem;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.items.magic.ItemMediaHolder;
import at.petrak.hexcasting.common.msgs.MsgNewSpiralPatternsS2C;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import org.jetbrains.annotations.Nullable;

public abstract class ItemPackagedHex
extends ItemMediaHolder
implements HexHolderItem {
    public static final String TAG_PROGRAM = "patterns";
    public static final String TAG_PIGMENT = "pigment";
    public static final class_2960 HAS_PATTERNS_PRED = HexAPI.modLoc("has_patterns");

    public ItemPackagedHex(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    public abstract boolean breakAfterDepletion();

    public abstract int cooldown();

    @Override
    public boolean canRecharge(class_1799 stack) {
        return !this.breakAfterDepletion();
    }

    @Override
    public boolean canProvideMedia(class_1799 stack) {
        return false;
    }

    @Override
    public boolean hasHex(class_1799 stack) {
        return NBTHelper.hasList(stack, TAG_PROGRAM, (byte)10);
    }

    @Override
    @Nullable
    public List<Iota> getHex(class_1799 stack, class_3218 level) {
        class_2499 patsTag = NBTHelper.getList(stack, TAG_PROGRAM, 10);
        if (patsTag == null) {
            return null;
        }
        ArrayList<Iota> out = new ArrayList<Iota>();
        for (class_2520 patTag : patsTag) {
            class_2487 tag = NBTHelper.getAsCompound(patTag);
            out.add(IotaType.deserialize(tag, level));
        }
        return out;
    }

    @Override
    public void writeHex(class_1799 stack, List<Iota> program, @Nullable FrozenPigment pigment, long media) {
        class_2499 patsTag = new class_2499();
        for (Iota pat : program) {
            patsTag.add((Object)IotaType.serialize(pat));
        }
        NBTHelper.putList(stack, TAG_PROGRAM, patsTag);
        if (pigment != null) {
            NBTHelper.putCompound(stack, TAG_PIGMENT, pigment.serializeToNBT());
        }
        ItemPackagedHex.withMedia(stack, media, media);
    }

    @Override
    public void clearHex(class_1799 stack) {
        NBTHelper.remove(stack, TAG_PROGRAM);
        NBTHelper.remove(stack, TAG_PIGMENT);
        NBTHelper.remove(stack, "hexcasting:media");
        NBTHelper.remove(stack, "hexcasting:start_media");
    }

    @Override
    @Nullable
    public FrozenPigment getPigment(class_1799 stack) {
        class_2487 ctag = NBTHelper.getCompound(stack, TAG_PIGMENT);
        if (ctag == null) {
            return null;
        }
        return FrozenPigment.fromNBT(ctag);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 usedHand) {
        class_3414 sound;
        class_1799 stack = player.method_5998(usedHand);
        if (!this.hasHex(stack)) {
            return class_1271.method_22431((Object)stack);
        }
        if (world.field_9236) {
            return class_1271.method_22427((Object)stack);
        }
        List<Iota> instrs = this.getHex(stack, (class_3218)world);
        if (instrs == null) {
            return class_1271.method_22431((Object)stack);
        }
        class_3222 sPlayer = (class_3222)player;
        PackagedItemCastEnv ctx = new PackagedItemCastEnv(sPlayer, usedHand);
        CastingVM harness = CastingVM.empty(ctx);
        ExecutionClientView clientView = harness.queueExecuteAndWrapIotas(instrs, sPlayer.method_51469());
        List<HexPattern> patterns = instrs.stream().filter(i -> i instanceof PatternIota).map(i -> ((PatternIota)i).getPattern()).toList();
        MsgNewSpiralPatternsS2C packet = new MsgNewSpiralPatternsS2C(sPlayer.method_5667(), patterns, 140);
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(sPlayer, packet);
        IXplatAbstractions.INSTANCE.sendPacketTracking((class_1297)sPlayer, packet);
        boolean broken = this.breakAfterDepletion() && this.getMedia(stack) == 0L;
        class_3445 stat = broken ? class_3468.field_15383.method_14956((Object)this) : class_3468.field_15372.method_14956((Object)this);
        player.method_7259(stat);
        sPlayer.method_7357().method_7906((class_1792)this, this.cooldown());
        if (clientView.getResolutionType().getSuccess()) {
            new ParticleSpray(player.method_19538(), new class_243(0.0, 1.5, 0.0), 0.4, 1.0471975511965976, 30).sprayParticles(sPlayer.method_51469(), ctx.getPigment());
        }
        if ((sound = ctx.getSound().sound()) != null) {
            class_243 soundPos = sPlayer.method_19538();
            sPlayer.method_37908().method_43128(null, soundPos.field_1352, soundPos.field_1351, soundPos.field_1350, sound, class_3419.field_15248, 1.0f, 1.0f);
        }
        if (broken) {
            stack.method_7934(1);
            player.method_20236(usedHand);
            return class_1271.method_22428((Object)stack);
        }
        return class_1271.method_22427((Object)stack);
    }

    public class_1839 method_7853(class_1799 pStack) {
        return class_1839.field_8949;
    }
}

