/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.items.magic;

import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.utils.MathUtils;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.api.utils.NBTHelper;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public abstract class ItemMediaHolder
extends class_1792
implements MediaHolderItem {
    public static final String TAG_MEDIA = "hexcasting:media";
    public static final String TAG_MAX_MEDIA = "hexcasting:start_media";
    public static final class_5251 HEX_COLOR = class_5251.method_27717((int)11767539);
    private static final DecimalFormat PERCENTAGE = new DecimalFormat("####");
    private static final DecimalFormat DUST_AMOUNT;

    public ItemMediaHolder(class_1792.class_1793 pProperties) {
        super(pProperties);
    }

    public static class_1799 withMedia(class_1799 stack, long media, long maxMedia) {
        class_1792 item = stack.method_7909();
        if (item instanceof ItemMediaHolder) {
            NBTHelper.putLong(stack, TAG_MEDIA, media);
            NBTHelper.putLong(stack, TAG_MAX_MEDIA, maxMedia);
        }
        return stack;
    }

    @Override
    public long getMedia(class_1799 stack) {
        if (NBTHelper.hasInt(stack, TAG_MEDIA)) {
            return NBTHelper.getInt(stack, TAG_MEDIA);
        }
        return NBTHelper.getLong(stack, TAG_MEDIA);
    }

    @Override
    public long getMaxMedia(class_1799 stack) {
        if (NBTHelper.hasInt(stack, TAG_MAX_MEDIA)) {
            return NBTHelper.getInt(stack, TAG_MAX_MEDIA);
        }
        return NBTHelper.getLong(stack, TAG_MAX_MEDIA);
    }

    @Override
    public void setMedia(class_1799 stack, long media) {
        NBTHelper.putLong(stack, TAG_MEDIA, MathUtils.clamp(media, 0L, this.getMaxMedia(stack)));
    }

    public boolean method_31567(class_1799 pStack) {
        return this.getMaxMedia(pStack) > 0L;
    }

    public int method_31571(class_1799 pStack) {
        long media = this.getMedia(pStack);
        long maxMedia = this.getMaxMedia(pStack);
        return MediaHelper.mediaBarColor(media, maxMedia);
    }

    public int method_31569(class_1799 pStack) {
        long media = this.getMedia(pStack);
        long maxMedia = this.getMaxMedia(pStack);
        return MediaHelper.mediaBarWidth(media, maxMedia);
    }

    public boolean method_7846() {
        return false;
    }

    public void method_7851(class_1799 pStack, @Nullable class_1937 pLevel, List<class_2561> pTooltipComponents, class_1836 pIsAdvanced) {
        long maxMedia = this.getMaxMedia(pStack);
        if (maxMedia > 0L) {
            long media = this.getMedia(pStack);
            float fullness = this.getMediaFullness(pStack);
            class_5251 color = class_5251.method_27717((int)MediaHelper.mediaBarColor(media, maxMedia));
            class_5250 mediamount = class_2561.method_43470((String)DUST_AMOUNT.format((float)media / 10000.0f));
            class_5250 percentFull = class_2561.method_43470((String)(PERCENTAGE.format(100.0f * fullness) + "%"));
            class_5250 maxCapacity = class_2561.method_43469((String)"hexcasting.tooltip.media", (Object[])new Object[]{DUST_AMOUNT.format((float)maxMedia / 10000.0f)});
            mediamount.method_27694(style -> style.method_27703(HEX_COLOR));
            maxCapacity.method_27694(style -> style.method_27703(HEX_COLOR));
            percentFull.method_27694(style -> style.method_27703(color));
            pTooltipComponents.add((class_2561)class_2561.method_43469((String)"hexcasting.tooltip.media_amount.advanced", (Object[])new Object[]{mediamount, maxCapacity, percentFull}));
        }
        super.method_7851(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    static {
        PERCENTAGE.setRoundingMode(RoundingMode.DOWN);
        DUST_AMOUNT = new DecimalFormat("###,###.##");
    }
}

