/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.command;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.casting.PatternRegistryManifest;
import at.petrak.hexcasting.common.command.PatternResLocArgument;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.server.ScrungledPatternsSave;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public class ListPerWorldPatternsCommand {
    public static void add(LiteralArgumentBuilder<class_2168> cmd) {
        cmd.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"perWorldPatterns").requires(dp -> dp.method_9259(2))).then(class_2170.method_9247((String)"list").executes(ctx -> ListPerWorldPatternsCommand.list((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"give").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"patternName", (ArgumentType)PatternResLocArgument.id()).executes(ctx -> ListPerWorldPatternsCommand.giveOne((class_2168)ctx.getSource(), ListPerWorldPatternsCommand.getDefaultTarget((class_2168)ctx.getSource()), class_2232.method_9443((CommandContext)ctx, (String)"patternName"), PatternResLocArgument.getPattern((CommandContext<class_2168>)ctx, "patternName")))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ctx -> ListPerWorldPatternsCommand.giveOne((class_2168)ctx.getSource(), class_2186.method_9312((CommandContext)ctx, (String)"targets"), class_2232.method_9443((CommandContext)ctx, (String)"patternName"), PatternResLocArgument.getPattern((CommandContext<class_2168>)ctx, "patternName"))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"giveAll").executes(ctx -> ListPerWorldPatternsCommand.giveAll((class_2168)ctx.getSource(), ListPerWorldPatternsCommand.getDefaultTarget((class_2168)ctx.getSource())))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ctx -> ListPerWorldPatternsCommand.giveAll((class_2168)ctx.getSource(), class_2186.method_9312((CommandContext)ctx, (String)"targets"))))));
    }

    private static Collection<class_3222> getDefaultTarget(class_2168 source) {
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            return List.of(player);
        }
        return List.of();
    }

    private static int list(class_2168 source) {
        Set keys = IXplatAbstractions.INSTANCE.getActionRegistry().method_42021();
        List listing = keys.stream().sorted((a, b) -> ListPerWorldPatternsCommand.compareResLoc(a.method_29177(), b.method_29177())).toList();
        class_3218 ow = source.method_9225().method_8503().method_30002();
        source.method_9226(() -> class_2561.method_43471((String)"command.hexcasting.pats.listing"), false);
        for (class_5321 key : listing) {
            HexPattern pat = PatternRegistryManifest.getCanonicalStrokesPerWorld((class_5321<ActionRegistryEntry>)key, ow);
            source.method_9226(() -> class_2561.method_43470((String)key.method_29177().toString()).method_27693(": ").method_10852(new PatternIota(pat).display()), false);
        }
        return keys.size();
    }

    private static int giveAll(class_2168 source, Collection<class_3222> targets) {
        if (!targets.isEmpty()) {
            class_3218 ow = source.method_9225().method_8503().method_30002();
            ScrungledPatternsSave save = ScrungledPatternsSave.open(ow);
            class_2378<ActionRegistryEntry> regi = IXplatAbstractions.INSTANCE.getActionRegistry();
            int count = 0;
            for (Map.Entry entry : regi.method_29722()) {
                class_5321 key = (class_5321)entry.getKey();
                if (!HexUtils.isOfTag(regi, key, HexTags.Actions.PER_WORLD_PATTERN)) continue;
                Pair<String, ScrungledPatternsSave.PerWorldEntry> found = save.lookupReverse((class_5321<ActionRegistryEntry>)key);
                String signature = (String)found.getFirst();
                HexDir startDir = ((ScrungledPatternsSave.PerWorldEntry)found.getSecond()).canonicalStartDir();
                HexPattern pat = HexPattern.fromAngles(signature, startDir);
                class_2487 tag = new class_2487();
                tag.method_10582("op_id", key.method_29177().toString());
                tag.method_10566("pattern", (class_2520)pat.serializeToNBT());
                class_1799 stack = new class_1799((class_1935)HexItems.SCROLL_LARGE);
                stack.method_7980(tag);
                for (class_3222 player : targets) {
                    class_1542 stackEntity = player.method_7328(stack, false);
                    if (stackEntity != null) {
                        stackEntity.method_6975();
                        stackEntity.method_6981(player.method_5667());
                    }
                    ++count;
                }
            }
            int finalCount = count;
            source.method_9226(() -> class_2561.method_43469((String)"command.hexcasting.pats.all", (Object[])new Object[]{finalCount, targets.size() == 1 ? ((class_3222)targets.iterator().next()).method_5476() : Integer.valueOf(targets.size())}), true);
            return count;
        }
        return 0;
    }

    private static int giveOne(class_2168 source, Collection<class_3222> targets, class_2960 patternName, HexPattern pat) {
        if (!targets.isEmpty()) {
            class_2487 tag = new class_2487();
            tag.method_10582("op_id", patternName.toString());
            tag.method_10566("pattern", (class_2520)pat.serializeToNBT());
            class_1799 stack = new class_1799((class_1935)HexItems.SCROLL_LARGE);
            stack.method_7980(tag);
            source.method_9226(() -> class_2561.method_43469((String)"command.hexcasting.pats.specific.success", (Object[])new Object[]{stack.method_7954(), patternName, targets.size() == 1 ? ((class_3222)targets.iterator().next()).method_5476() : Integer.valueOf(targets.size())}), true);
            for (class_3222 player : targets) {
                class_1542 stackEntity = player.method_7328(stack, false);
                if (stackEntity == null) continue;
                stackEntity.method_6975();
                stackEntity.method_6981(player.method_5667());
            }
            return targets.size();
        }
        return 0;
    }

    private static int compareResLoc(class_2960 a, class_2960 b) {
        int ns = a.method_12836().compareTo(b.method_12836());
        if (ns != 0) {
            return ns;
        }
        return a.method_12832().compareTo(b.method_12832());
    }
}

