/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.FlightAbility;
import at.petrak.hexcasting.common.items.pigment.ItemDyePigment;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.lib.HexSounds;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1656;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\f\u001a\u00020\u000b2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "type", "<init>", "(Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;)V", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "", "argc", "I", "getArgc", "()I", "Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "getType", "()Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "Companion", "Spell", "Type", "hexcasting-fabric-1.20.1"})
public final class OpFlight
implements SpellAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    private final int argc;
    private static final double DIST_DANGER_THRESHOLD = 4.0;
    private static final double TIME_DANGER_THRESHOLD = 140.0;

    public OpFlight(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.type = type;
        this.argc = 2;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    @Override
    public int getArgc() {
        return this.argc;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        class_3222 target = OperatorUtils.getPlayer(args, 0, this.getArgc());
        double theArg = OperatorUtils.getPositiveDouble(args, 1, this.getArgc());
        env.assertEntityInRange((class_1297)target);
        long cost = MathKt.roundToLong((double)(switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1 -> theArg * (double)10000L;
            case 2 -> theArg * (double)50000L;
            default -> throw new NoWhenBranchMatchedException();
        }));
        RenderedSpell renderedSpell = new Spell(this.type, target, theArg);
        class_243 class_2432 = target.method_19538();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"target.position()");
        return new SpellAction.Result(renderedSpell, cost, CollectionsKt.listOf((Object)new ParticleSpray(class_2432, new class_243(0.0, 2.0, 0.0), 0.0, 0.1, 0, 16, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull class_2487 userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @JvmStatic
    public static final void tickAllPlayers(@NotNull class_3218 world) {
        Companion.tickAllPlayers(world);
    }

    @JvmStatic
    public static final void tickDownFlight(@NotNull class_3222 player) {
        Companion.tickDownFlight(player);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "", "<init>", "(Ljava/lang/String;I)V", "LimitRange", "LimitTime", "hexcasting-fabric-1.20.1"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LimitRange = new Type();
        public static final /* enum */ Type LimitTime = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.LimitRange, Type.LimitTime};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J.\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010 \u001a\u00020\u001fH\u00d6\u0001\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010$\u001a\u0004\b%\u0010\u0014R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010&\u001a\u0004\b'\u0010\u0010\u00a8\u0006("}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "type", "Lnet/minecraft/class_3222;", "target", "", "theArg", "<init>", "(Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;Lnet/minecraft/class_3222;D)V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "", "cast", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)V", "component1", "()Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "component2", "()Lnet/minecraft/class_3222;", "component3", "()D", "copy", "(Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;Lnet/minecraft/class_3222;D)Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Spell;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/class_3222;", "getTarget", "D", "getTheArg", "Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Type;", "getType", "hexcasting-fabric-1.20.1"})
    public static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Type type;
        @NotNull
        private final class_3222 target;
        private final double theArg;

        public Spell(@NotNull Type type, @NotNull class_3222 target, double theArg) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.type = type;
            this.target = target;
            this.theArg = theArg;
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        @NotNull
        public final class_3222 getTarget() {
            return this.target;
        }

        public final double getTheArg() {
            return this.theArg;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (this.target.method_31549().field_7478) {
                return;
            }
            class_5321 dim = this.target.method_37908().method_27983();
            class_243 origin = this.target.method_19538();
            FlightAbility flight = switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                case 1 -> new FlightAbility(-1, (class_5321<class_1937>)dim, origin, this.theArg);
                case 2 -> new FlightAbility(MathKt.roundToInt((double)(this.theArg * 20.0)), (class_5321<class_1937>)dim, origin, -1.0);
                default -> throw new NoWhenBranchMatchedException();
            };
            IXplatAbstractions.INSTANCE.setFlight(this.target, flight);
            this.target.method_31549().field_7478 = true;
            this.target.method_7355();
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }

        @NotNull
        public final Type component1() {
            return this.type;
        }

        @NotNull
        public final class_3222 component2() {
            return this.target;
        }

        public final double component3() {
            return this.theArg;
        }

        @NotNull
        public final Spell copy(@NotNull Type type, @NotNull class_3222 target, double theArg) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new Spell(type, target, theArg);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Type type, class_3222 class_32222, double d, int n, Object object) {
            if ((n & 1) != 0) {
                type = spell.type;
            }
            if ((n & 2) != 0) {
                class_32222 = spell.target;
            }
            if ((n & 4) != 0) {
                d = spell.theArg;
            }
            return spell.copy(type, class_32222, d);
        }

        @NotNull
        public String toString() {
            return "Spell(type=" + this.type + ", target=" + this.target + ", theArg=" + this.theArg + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.target.hashCode();
            result = result * 31 + Double.hashCode(this.theArg);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (this.type != spell.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.target, (Object)spell.target)) {
                return false;
            }
            return Double.compare(this.theArg, spell.theArg) == 0;
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                try {
                    nArray[Type.LimitRange.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Type.LimitTime.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\b8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpFlight$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lat/petrak/hexcasting/api/player/FlightAbility;", "flight", "", "getDanger", "(Lnet/minecraft/class_3222;Lat/petrak/hexcasting/api/player/FlightAbility;)D", "Lnet/minecraft/class_3218;", "world", "", "tickAllPlayers", "(Lnet/minecraft/class_3218;)V", "tickDownFlight", "(Lnet/minecraft/class_3222;)V", "DIST_DANGER_THRESHOLD", "D", "TIME_DANGER_THRESHOLD", "hexcasting-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void tickAllPlayers(@NotNull class_3218 world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            for (class_3222 player : world.method_18456()) {
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"player");
                this.tickDownFlight(player);
            }
        }

        @JvmStatic
        public final void tickDownFlight(@NotNull class_3222 player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            FlightAbility flight = IXplatAbstractions.INSTANCE.getFlight(player);
            if (flight != null) {
                double danger = this.getDanger(player, flight);
                if (danger >= 1.0) {
                    IXplatAbstractions.INSTANCE.setFlight(player, null);
                    if (!player.method_7337() && !player.method_7325()) {
                        class_1656 abilities = player.method_31549();
                        abilities.field_7479 = false;
                        abilities.field_7478 = false;
                        player.method_7355();
                    }
                    player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), HexSounds.FLIGHT_FINISH, class_3419.field_15248, 2.0f, 1.0f);
                    class_243 class_2432 = player.method_19538();
                    Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"player.position()");
                    ParticleSpray superDangerSpray = new ParticleSpray(class_2432, new class_243(0.0, 1.0, 0.0), Math.PI, 0.4, 20);
                    class_3218 class_32182 = player.method_51469();
                    Intrinsics.checkNotNullExpressionValue((Object)class_32182, (String)"player.serverLevel()");
                    ItemDyePigment itemDyePigment = HexItems.DYE_PIGMENTS.get(class_1767.field_7964);
                    Intrinsics.checkNotNull((Object)itemDyePigment);
                    superDangerSpray.sprayParticles(class_32182, new FrozenPigment(new class_1799((class_1935)itemDyePigment), class_156.field_25140));
                    class_3218 class_32183 = player.method_51469();
                    Intrinsics.checkNotNullExpressionValue((Object)class_32183, (String)"player.serverLevel()");
                    ItemDyePigment itemDyePigment2 = HexItems.DYE_PIGMENTS.get(class_1767.field_7963);
                    Intrinsics.checkNotNull((Object)itemDyePigment2);
                    superDangerSpray.sprayParticles(class_32183, new FrozenPigment(new class_1799((class_1935)itemDyePigment2), class_156.field_25140));
                } else {
                    if (!player.method_31549().field_7478) {
                        player.method_31549().field_7478 = true;
                        player.method_7355();
                    }
                    int time2 = flight.timeLeft() >= 0 ? flight.timeLeft() - 1 : flight.timeLeft();
                    IXplatAbstractions.INSTANCE.setFlight(player, new FlightAbility(time2, flight.dimension(), flight.origin(), flight.radius()));
                    int particleCount = 5;
                    int dangerParticleCount = MathKt.roundToInt((double)((double)particleCount * danger));
                    int okParticleCount = particleCount - dangerParticleCount;
                    int oneDangerParticleCount = class_3532.method_15384((double)((double)dangerParticleCount / 2.0));
                    FrozenPigment color = IXplatAbstractions.INSTANCE.getPigment((class_1657)player);
                    class_243 class_2433 = player.method_19538();
                    Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"player.position()");
                    ParticleSpray particleSpray = new ParticleSpray(class_2433, new class_243(0.0, -0.6, 0.0), 0.6, 0.9424777960769379, okParticleCount);
                    class_3218 class_32184 = player.method_51469();
                    Intrinsics.checkNotNullExpressionValue((Object)class_32184, (String)"player.serverLevel()");
                    Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color");
                    particleSpray.sprayParticles(class_32184, color);
                    class_243 class_2434 = player.method_19538();
                    Intrinsics.checkNotNullExpressionValue((Object)class_2434, (String)"player.position()");
                    ParticleSpray dangerSpray = new ParticleSpray(class_2434, new class_243(0.0, 1.0, 0.0), 0.3, 2.356194490192345, 0);
                    ParticleSpray particleSpray2 = ParticleSpray.copy$default(dangerSpray, null, null, 0.0, 0.0, oneDangerParticleCount, 15, null);
                    class_3218 class_32185 = player.method_51469();
                    Intrinsics.checkNotNullExpressionValue((Object)class_32185, (String)"player.serverLevel()");
                    ItemDyePigment itemDyePigment = HexItems.DYE_PIGMENTS.get(class_1767.field_7963);
                    Intrinsics.checkNotNull((Object)itemDyePigment);
                    particleSpray2.sprayParticles(class_32185, new FrozenPigment(new class_1799((class_1935)itemDyePigment), class_156.field_25140));
                    ParticleSpray particleSpray3 = ParticleSpray.copy$default(dangerSpray, null, null, 0.0, 0.0, oneDangerParticleCount, 15, null);
                    class_3218 class_32186 = player.method_51469();
                    Intrinsics.checkNotNullExpressionValue((Object)class_32186, (String)"player.serverLevel()");
                    ItemDyePigment itemDyePigment3 = HexItems.DYE_PIGMENTS.get(class_1767.field_7964);
                    Intrinsics.checkNotNull((Object)itemDyePigment3);
                    particleSpray3.sprayParticles(class_32186, new FrozenPigment(new class_1799((class_1935)itemDyePigment3), class_156.field_25140));
                    if ((double)player.method_37908().field_9229.method_43057() < 0.02) {
                        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), HexSounds.FLIGHT_AMBIENCE, class_3419.field_15248, 0.2f, 1.0f);
                    }
                    if (flight.radius() >= 0.0) {
                        class_243 spoofedOrigin = flight.origin().method_1031(0.0, 1.0, 0.0);
                        Intrinsics.checkNotNullExpressionValue((Object)spoofedOrigin, (String)"spoofedOrigin");
                        ParticleSpray particleSpray4 = new ParticleSpray(spoofedOrigin, new class_243(0.0, 1.0, 0.0), 0.5, 0.3141592653589793, 5);
                        class_3218 class_32187 = player.method_51469();
                        Intrinsics.checkNotNullExpressionValue((Object)class_32187, (String)"player.serverLevel()");
                        particleSpray4.sprayParticles(class_32187, color);
                        ParticleSpray particleSpray5 = new ParticleSpray(spoofedOrigin, new class_243(0.0, -1.0, 0.0), 1.5, 0.7853981633974483, 5);
                        class_3218 class_32188 = player.method_51469();
                        Intrinsics.checkNotNullExpressionValue((Object)class_32188, (String)"player.serverLevel()");
                        particleSpray5.sprayParticles(class_32188, color);
                    }
                }
            }
        }

        private final double getDanger(class_3222 player, FlightAbility flight) {
            double d;
            double radiusDanger;
            if (flight.radius() >= 0.0) {
                if (!Intrinsics.areEqual((Object)player.method_37908().method_27983(), flight.dimension())) {
                    v0 = 1.0;
                } else {
                    class_243 posXZ = new class_243(player.method_23317(), 0.0, player.method_23321());
                    class_243 originXZ = new class_243(flight.origin().field_1352, 0.0, flight.origin().field_1350);
                    double dist = posXZ.method_1022(originXZ);
                    double distFromEdge = flight.radius() - dist;
                    v0 = distFromEdge >= DIST_DANGER_THRESHOLD ? 0.0 : (dist > flight.radius() ? 1.0 : 1.0 - distFromEdge / DIST_DANGER_THRESHOLD);
                }
            } else {
                v0 = radiusDanger = 0.0;
            }
            if (flight.timeLeft() >= 0) {
                if ((double)flight.timeLeft() >= TIME_DANGER_THRESHOLD) {
                    d = 0.0;
                } else {
                    double timeDanger = TIME_DANGER_THRESHOLD - (double)flight.timeLeft();
                    d = timeDanger / TIME_DANGER_THRESHOLD;
                }
            } else {
                d = 0.0;
            }
            double timeDanger = d;
            return Math.max(radiusDanger, timeDanger);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.LimitRange.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.LimitTime.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

