/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.client.render.HexPatternLike;
import at.petrak.hexcasting.client.render.HexPatternPoints;
import at.petrak.hexcasting.client.render.PatternSettings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;

public class PatternTextureManager {
    public static boolean useTextures = true;
    public static int repaintIndex = 0;
    private static final ConcurrentMap<String, Map<String, class_2960>> patternTexturesToAdd = new ConcurrentHashMap<String, Map<String, class_2960>>();
    private static final Set<String> inProgressPatterns = new HashSet<String>();
    private static final ExecutorService executor = new ThreadPoolExecutor(0, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    private static final HashMap<String, Map<String, class_2960>> patternTextures = new HashMap();

    public static Optional<Map<String, class_2960>> getTextures(HexPatternLike patternlike, PatternSettings patSets, double seed, int resPerUnit) {
        String patCacheKey = patSets.getCacheKey(patternlike, seed) + "_" + resPerUnit;
        if (patternTexturesToAdd.containsKey(patCacheKey)) {
            Map patternTexture = (Map)patternTexturesToAdd.remove(patCacheKey);
            Map<String, class_2960> oldPatternTexture = patternTextures.put(patCacheKey, patternTexture);
            inProgressPatterns.remove(patCacheKey);
            if (oldPatternTexture != null) {
                for (class_2960 oldPatternTextureSingle : oldPatternTexture.values()) {
                    class_310.method_1551().method_1531().method_4619(oldPatternTextureSingle).close();
                }
            }
            return Optional.empty();
        }
        if (patternTextures.containsKey(patCacheKey)) {
            return Optional.of(patternTextures.get(patCacheKey));
        }
        if (!inProgressPatterns.contains(patCacheKey)) {
            inProgressPatterns.add(patCacheKey);
            executor.submit(() -> {
                Map<String, class_1043> slowTextures = PatternTextureManager.createTextures(patternlike, patSets, seed, resPerUnit);
                class_310.method_1551().execute(() -> PatternTextureManager.registerTextures(patCacheKey, slowTextures));
            });
        }
        return Optional.empty();
    }

    private static Map<String, class_1043> createTextures(HexPatternLike patternlike, PatternSettings patSets, double seed, int resPerUnit) {
        HexPatternPoints staticPoints = HexPatternPoints.getStaticPoints(patternlike, patSets, seed);
        List<class_241> zappyRenderSpace = staticPoints.scaleVecs((List<class_241>)staticPoints.zappyPoints);
        HashMap<String, class_1043> patTexts = new HashMap<String, class_1043>();
        class_1011 innerLines = PatternTextureManager.drawLines(zappyRenderSpace, staticPoints, (float)patSets.getInnerWidth(staticPoints.finalScale), resPerUnit);
        patTexts.put("inner", new class_1043(innerLines));
        class_1011 outerLines = PatternTextureManager.drawLines(zappyRenderSpace, staticPoints, (float)patSets.getOuterWidth(staticPoints.finalScale), resPerUnit);
        patTexts.put("outer", new class_1043(outerLines));
        return patTexts;
    }

    private static Map<String, class_2960> registerTextures(String patTextureKeyBase, Map<String, class_1043> dynamicTextures) {
        HashMap<String, class_2960> resLocs = new HashMap<String, class_2960>();
        for (Map.Entry<String, class_1043> textureEntry : dynamicTextures.entrySet()) {
            String name = "hex_pattern_texture_" + patTextureKeyBase + "_" + textureEntry.getKey() + "_" + repaintIndex + ".png";
            class_2960 resourceLocation = class_310.method_1551().method_1531().method_4617(name, textureEntry.getValue());
            resLocs.put(textureEntry.getKey(), resourceLocation);
        }
        patternTexturesToAdd.put(patTextureKeyBase, resLocs);
        return resLocs;
    }

    private static class_1011 drawLines(List<class_241> points, HexPatternPoints staticPoints, float unscaledLineWidth, int resPerUnit) {
        BufferedImage img = new BufferedImage((int)(staticPoints.fullWidth * (double)resPerUnit), (int)(staticPoints.fullHeight * (double)resPerUnit), 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(new Color(-1));
        g2d.setStroke(new BasicStroke(unscaledLineWidth * (float)resPerUnit, 1, 1));
        for (int i = 0; i < points.size() - 1; ++i) {
            class_3545<Integer, Integer> pointFrom = PatternTextureManager.getTextureCoordinates(points.get(i), staticPoints, resPerUnit);
            class_3545<Integer, Integer> pointTo = PatternTextureManager.getTextureCoordinates(points.get(i + 1), staticPoints, resPerUnit);
            g2d.drawLine((Integer)pointFrom.method_15442(), (Integer)pointFrom.method_15441(), (Integer)pointTo.method_15442(), (Integer)pointTo.method_15441());
        }
        g2d.dispose();
        class_1011 nativeImage = new class_1011(img.getWidth(), img.getHeight(), true);
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                nativeImage.method_4305(x, y, img.getRGB(x, y));
            }
        }
        return nativeImage;
    }

    private static class_3545<Integer, Integer> getTextureCoordinates(class_241 point, HexPatternPoints staticPoints, int resPerUnit) {
        int x = (int)(point.field_1343 * (float)resPerUnit);
        int y = (int)(point.field_1342 * (float)resPerUnit);
        return new class_3545((Object)x, (Object)y);
    }

    private static void drawHexagon(Graphics2D g2d, int x, int y, int radius) {
        int fracOfCircle = 6;
        Polygon hexagon = new Polygon();
        for (int i = 0; i < fracOfCircle; ++i) {
            double theta = (double)i / (double)fracOfCircle * Math.PI * 2.0;
            int hx = (int)((double)x + Math.cos(theta) * (double)radius);
            int hy = (int)((double)y + Math.sin(theta) * (double)radius);
            hexagon.addPoint(hx, hy);
        }
        g2d.fill(hexagon);
    }

    public static void repaint() {
        ++repaintIndex;
        patternTexturesToAdd.clear();
        patternTextures.clear();
    }
}

