/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.client.render.HexPatternLike;
import at.petrak.hexcasting.client.render.HexPatternPoints;
import at.petrak.hexcasting.client.render.PatternColors;
import at.petrak.hexcasting.client.render.PatternSettings;
import at.petrak.hexcasting.client.render.PatternTextureManager;
import at.petrak.hexcasting.client.render.RenderLib;
import at.petrak.hexcasting.client.render.VCDrawHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5944;

public class PatternRenderer {
    private static final float outerZ = 5.0E-4f;
    private static final float innerZ = 0.001f;

    public static void renderPattern(HexPattern pattern, class_4587 ps, PatternSettings patSets, PatternColors patColors, double seed, int resPerUnit) {
        PatternRenderer.renderPattern(pattern, ps, null, patSets, patColors, seed, resPerUnit);
    }

    public static void renderPattern(HexPattern pattern, class_4587 ps, @Nullable WorldlyBits worldlyBits, PatternSettings patSets, PatternColors patColors, double seed, int resPerUnit) {
        PatternRenderer.renderPattern(HexPatternLike.of(pattern), ps, worldlyBits, patSets, patColors, seed, resPerUnit);
    }

    public static void renderPattern(HexPatternLike patternlike, class_4587 ps, @Nullable WorldlyBits worldlyBits, PatternSettings patSets, PatternColors patColors, double seed, int resPerUnit) {
        boolean didRender;
        class_5944 oldShader = RenderSystem.getShader();
        HexPatternPoints staticPoints = HexPatternPoints.getStaticPoints(patternlike, patSets, seed);
        boolean shouldRenderDynamic = true;
        if (patSets.getSpeed() == 0.0f && PatternTextureManager.useTextures && patColors.innerStartColor() == patColors.innerEndColor() && patColors.outerStartColor() == patColors.outerEndColor() && (didRender = PatternRenderer.renderPatternTexture(patternlike, ps, worldlyBits, patSets, patColors, seed, resPerUnit))) {
            shouldRenderDynamic = false;
        }
        if (shouldRenderDynamic) {
            Object zappyPattern;
            if (patSets.getSpeed() == 0.0f) {
                zappyPattern = staticPoints.zappyPoints;
            } else {
                List<class_241> nonzappyLines = patternlike.getNonZappyPoints();
                Set<Integer> dupIndices = RenderLib.findDupIndices(nonzappyLines);
                zappyPattern = RenderLib.makeZappy(nonzappyLines, dupIndices, patSets.getHops(), patSets.getVariance(), patSets.getSpeed(), patSets.getFlowIrregular(), patSets.getReadabilityOffset(), patSets.getLastSegmentProp(), seed);
            }
            List<class_241> zappyRenderSpace = staticPoints.scaleVecs((List<class_241>)zappyPattern);
            if (class_5253.class_5254.method_27762((int)patColors.outerEndColor()) != 0 && class_5253.class_5254.method_27762((int)patColors.outerStartColor()) != 0) {
                RenderLib.drawLineSeq(ps.method_23760().method_23761(), zappyRenderSpace, (float)patSets.getOuterWidth(staticPoints.finalScale), patColors.outerStartColor(), patColors.outerEndColor(), VCDrawHelper.getHelper(worldlyBits, ps, 5.0E-4f));
            }
            if (class_5253.class_5254.method_27762((int)patColors.innerEndColor()) != 0 && class_5253.class_5254.method_27762((int)patColors.innerStartColor()) != 0) {
                RenderLib.drawLineSeq(ps.method_23760().method_23761(), zappyRenderSpace, (float)patSets.getInnerWidth(staticPoints.finalScale), patColors.innerStartColor(), patColors.innerEndColor(), VCDrawHelper.getHelper(worldlyBits, ps, 0.001f));
            }
        }
        float dotZ = 0.0011f;
        if (class_5253.class_5254.method_27762((int)patColors.startingDotColor()) != 0) {
            RenderLib.drawSpot(ps.method_23760().method_23761(), (class_241)staticPoints.dotsScaled.get(0), (float)patSets.getStartDotRadius(staticPoints.finalScale), patColors.startingDotColor(), VCDrawHelper.getHelper(worldlyBits, ps, dotZ));
        }
        if (class_5253.class_5254.method_27762((int)patColors.gridDotsColor()) != 0) {
            for (int i = 1; i < staticPoints.dotsScaled.size(); ++i) {
                class_241 gridDot = (class_241)staticPoints.dotsScaled.get(i);
                RenderLib.drawSpot(ps.method_23760().method_23761(), gridDot, (float)patSets.getGridDotsRadius(staticPoints.finalScale), patColors.gridDotsColor(), VCDrawHelper.getHelper(worldlyBits, ps, dotZ));
            }
        }
        RenderSystem.setShader(() -> oldShader);
    }

    private static boolean renderPatternTexture(HexPatternLike patternlike, class_4587 ps, @Nullable WorldlyBits worldlyBits, PatternSettings patSets, PatternColors patColors, double seed, int resPerUnit) {
        int cl;
        class_4588 vc;
        VCDrawHelper vcHelper;
        Optional<Map<String, class_2960>> maybeTextures = PatternTextureManager.getTextures(patternlike, patSets, seed, resPerUnit);
        if (maybeTextures.isEmpty()) {
            return false;
        }
        Map<String, class_2960> textures = maybeTextures.get();
        HexPatternPoints staticPoints = HexPatternPoints.getStaticPoints(patternlike, patSets, seed);
        if (class_5253.class_5254.method_27762((int)patColors.outerStartColor()) != 0) {
            vcHelper = VCDrawHelper.getHelper(worldlyBits, ps, 5.0E-4f, textures.get("outer"));
            vc = vcHelper.vcSetupAndSupply(class_293.class_5596.field_27382);
            cl = patColors.outerStartColor();
            vcHelper.vertex(vc, cl, new class_241(0.0f, 0.0f), new class_241(0.0f, 0.0f), ps.method_23760().method_23761());
            vcHelper.vertex(vc, cl, new class_241(0.0f, (float)staticPoints.fullHeight), new class_241(0.0f, 1.0f), ps.method_23760().method_23761());
            vcHelper.vertex(vc, cl, new class_241((float)staticPoints.fullWidth, (float)staticPoints.fullHeight), new class_241(1.0f, 1.0f), ps.method_23760().method_23761());
            vcHelper.vertex(vc, cl, new class_241((float)staticPoints.fullWidth, 0.0f), new class_241(1.0f, 0.0f), ps.method_23760().method_23761());
            vcHelper.vcEndDrawer(vc);
        }
        if (class_5253.class_5254.method_27762((int)patColors.innerStartColor()) != 0) {
            vcHelper = VCDrawHelper.getHelper(worldlyBits, ps, 0.001f, textures.get("inner"));
            vc = vcHelper.vcSetupAndSupply(class_293.class_5596.field_27382);
            cl = patColors.innerStartColor();
            vcHelper.vertex(vc, cl, new class_241(0.0f, 0.0f), new class_241(0.0f, 0.0f), ps.method_23760().method_23761());
            vcHelper.vertex(vc, cl, new class_241(0.0f, (float)staticPoints.fullHeight), new class_241(0.0f, 1.0f), ps.method_23760().method_23761());
            vcHelper.vertex(vc, cl, new class_241((float)staticPoints.fullWidth, (float)staticPoints.fullHeight), new class_241(1.0f, 1.0f), ps.method_23760().method_23761());
            vcHelper.vertex(vc, cl, new class_241((float)staticPoints.fullWidth, 0.0f), new class_241(1.0f, 0.0f), ps.method_23760().method_23761());
            vcHelper.vcEndDrawer(vc);
        }
        return true;
    }

    public static boolean shouldDoStrokeGradient() {
        return class_437.method_25441();
    }

    public record WorldlyBits(@Nullable class_4597 provider, Integer light, class_243 normal) {
    }
}

