/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.client.render.HexPatternLike;
import at.petrak.hexcasting.client.render.PatternSettings;
import at.petrak.hexcasting.client.render.RenderLib;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.class_241;

public class HexPatternPoints {
    public final ImmutableList<class_241> zappyPoints;
    public final ImmutableList<class_241> zappyPointsScaled;
    public final ImmutableList<class_241> dotsScaled;
    public final double rangeX;
    public final double rangeY;
    public final double finalScale;
    public final double fullWidth;
    public final double fullHeight;
    private double minX = Double.MAX_VALUE;
    private double minY = Double.MAX_VALUE;
    private final double offsetX;
    private final double offsetY;
    private static final ConcurrentMap<String, HexPatternPoints> CACHED_STATIC_POINTS = new ConcurrentHashMap<String, HexPatternPoints>();

    private HexPatternPoints(HexPatternLike patternlike, PatternSettings patSets, double seed) {
        List<class_241> dots = patternlike.getNonZappyPoints();
        List<class_241> zappyPoints = RenderLib.makeZappy(dots, patternlike.getDups(), patSets.getHops(), patSets.getVariance(), 0.0f, patSets.getFlowIrregular(), patSets.getReadabilityOffset(), patSets.getLastSegmentProp(), seed);
        this.zappyPoints = ImmutableList.copyOf(zappyPoints);
        double maxY = Double.MIN_VALUE;
        double maxX = Double.MIN_VALUE;
        for (class_241 point : zappyPoints) {
            this.minX = Math.min(this.minX, (double)point.field_1343);
            maxX = Math.max(maxX, (double)point.field_1343);
            this.minY = Math.min(this.minY, (double)point.field_1342);
            maxY = Math.max(maxY, (double)point.field_1342);
        }
        this.rangeX = maxX - this.minX;
        this.rangeY = maxY - this.minY;
        double baseScale = patSets.getBaseScale() / 1.5;
        double baseWidth = this.rangeX * baseScale;
        double baseHeight = this.rangeY * baseScale;
        double scale = Math.max(1.0, Math.max((patSets.getMinWidth() - patSets.getStrokeWidthGuess()) / baseWidth, (patSets.getMinHeight() - patSets.getStrokeWidthGuess()) / baseHeight));
        boolean vertFit = patSets.getVertAlignment().fit;
        boolean horFit = patSets.getHorAlignment().fit;
        if (vertFit) {
            scale = Math.min(scale, (patSets.getTargetHeight() - 2.0 * patSets.getVertPadding() - patSets.getStrokeWidthGuess()) / baseHeight);
        }
        if (horFit) {
            scale = Math.min(scale, (patSets.getTargetWidth() - 2.0 * patSets.getHorPadding() - patSets.getStrokeWidthGuess()) / baseWidth);
        }
        this.finalScale = baseScale * scale;
        double finalStroke = patSets.getStrokeWidth(this.finalScale);
        double inherentWidth = baseWidth * scale + 2.0 * patSets.getHorPadding() + finalStroke;
        double inherentHeight = baseHeight * scale + 2.0 * patSets.getVertPadding() + finalStroke;
        double widthDiff = Math.max(patSets.getTargetWidth() - inherentWidth, 0.0);
        double heightDiff = Math.max(patSets.getTargetHeight() - inherentHeight, 0.0);
        this.fullWidth = inherentWidth + widthDiff;
        this.fullHeight = inherentHeight + heightDiff;
        this.offsetX = (inherentWidth - baseWidth * scale) / 2.0 + widthDiff * (double)patSets.getHorAlignment().amtInFront / 2.0;
        this.offsetY = (inherentHeight - baseHeight * scale) / 2.0 + heightDiff * (double)patSets.getVertAlignment().amtInFront / 2.0;
        this.zappyPointsScaled = ImmutableList.copyOf(this.scaleVecs(zappyPoints));
        this.dotsScaled = ImmutableList.copyOf(this.scaleVecs(dots));
    }

    public class_241 scaleVec(class_241 point) {
        return new class_241((float)(((double)point.field_1343 - this.minX) * this.finalScale + this.offsetX), (float)(((double)point.field_1342 - this.minY) * this.finalScale + this.offsetY));
    }

    public List<class_241> scaleVecs(List<class_241> points) {
        ArrayList<class_241> scaledPoints = new ArrayList<class_241>();
        for (class_241 point : points) {
            scaledPoints.add(this.scaleVec(point));
        }
        return scaledPoints;
    }

    public static HexPatternPoints getStaticPoints(HexPatternLike patternlike, PatternSettings patSets, double seed) {
        String cacheKey = patSets.getCacheKey(patternlike, seed);
        return CACHED_STATIC_POINTS.computeIfAbsent(cacheKey, key -> new HexPatternPoints(patternlike, patSets, seed));
    }
}

