/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.item.IotaHolderItem;
import at.petrak.hexcasting.api.item.MediaHolderItem;
import at.petrak.hexcasting.api.item.VariantItem;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.client.entity.WallScrollRenderer;
import at.petrak.hexcasting.client.render.GaslightingTracker;
import at.petrak.hexcasting.client.render.ScryingLensOverlays;
import at.petrak.hexcasting.client.render.be.BlockEntityAkashicBookshelfRenderer;
import at.petrak.hexcasting.client.render.be.BlockEntityQuenchedAllayRenderer;
import at.petrak.hexcasting.client.render.be.BlockEntitySlateRenderer;
import at.petrak.hexcasting.common.blocks.BlockQuenchedAllay;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockEntityAkashicBookshelf;
import at.petrak.hexcasting.common.entities.HexEntities;
import at.petrak.hexcasting.common.items.ItemStaff;
import at.petrak.hexcasting.common.items.magic.ItemMediaBattery;
import at.petrak.hexcasting.common.items.magic.ItemPackagedHex;
import at.petrak.hexcasting.common.items.storage.ItemFocus;
import at.petrak.hexcasting.common.items.storage.ItemScroll;
import at.petrak.hexcasting.common.items.storage.ItemSlate;
import at.petrak.hexcasting.common.items.storage.ItemSpellbook;
import at.petrak.hexcasting.common.items.storage.ItemThoughtKnot;
import at.petrak.hexcasting.common.lib.HexBlockEntities;
import at.petrak.hexcasting.common.lib.HexBlocks;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_326;
import net.minecraft.class_3300;
import net.minecraft.class_5614;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class RegisterClientStuff {
    public static Map<class_2960, List<class_1087>> QUENCHED_ALLAY_VARIANTS = new HashMap<class_2960, List<class_1087>>();
    private static final Map<BlockQuenchedAllay, Boolean> QUENCHED_ALLAY_TYPES = Map.of(HexBlocks.QUENCHED_ALLAY, false, HexBlocks.QUENCHED_ALLAY_TILES, true, HexBlocks.QUENCHED_ALLAY_BRICKS, true, HexBlocks.QUENCHED_ALLAY_BRICKS_SMALL, true);

    public static void init() {
        RegisterClientStuff.registerSealableDataHolderOverrides(HexItems.FOCUS, stack -> HexItems.FOCUS.readIotaTag((class_1799)stack) != null, ItemFocus::isSealed);
        RegisterClientStuff.registerSealableDataHolderOverrides(HexItems.SPELLBOOK, stack -> HexItems.SPELLBOOK.readIotaTag((class_1799)stack) != null, ItemSpellbook::isSealed);
        RegisterClientStuff.registerVariantOverrides(HexItems.FOCUS, HexItems.FOCUS::getVariant);
        RegisterClientStuff.registerVariantOverrides(HexItems.SPELLBOOK, HexItems.SPELLBOOK::getVariant);
        RegisterClientStuff.registerVariantOverrides(HexItems.CYPHER, HexItems.CYPHER::getVariant);
        RegisterClientStuff.registerVariantOverrides(HexItems.TRINKET, HexItems.TRINKET::getVariant);
        RegisterClientStuff.registerVariantOverrides(HexItems.ARTIFACT, HexItems.ARTIFACT::getVariant);
        IClientXplatAbstractions.INSTANCE.registerItemProperty(HexItems.THOUGHT_KNOT, ItemThoughtKnot.WRITTEN_PRED, (stack, level, holder, holderID) -> {
            if (NBTHelper.contains(stack, "data")) {
                return 1.0f;
            }
            return 0.0f;
        });
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.CYPHER);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.TRINKET);
        RegisterClientStuff.registerPackagedSpellOverrides(HexItems.ARTIFACT);
        IClientXplatAbstractions x = IClientXplatAbstractions.INSTANCE;
        x.registerItemProperty(HexItems.BATTERY, ItemMediaBattery.MEDIA_PREDICATE, (stack, level, holder, holderID) -> {
            MediaHolderItem item = (MediaHolderItem)stack.method_7909();
            return item.getMediaFullness(stack);
        });
        x.registerItemProperty(HexItems.BATTERY, ItemMediaBattery.MAX_MEDIA_PREDICATE, (stack, level, holder, holderID) -> {
            ItemMediaBattery item = (ItemMediaBattery)stack.method_7909();
            long max = item.getMaxMedia(stack);
            return 1.049658f * (float)Math.log((float)max / 100000.0f + 9.06152f) - 2.1436f;
        });
        RegisterClientStuff.registerScrollOverrides(HexItems.SCROLL_SMOL);
        RegisterClientStuff.registerScrollOverrides(HexItems.SCROLL_MEDIUM);
        RegisterClientStuff.registerScrollOverrides(HexItems.SCROLL_LARGE);
        x.registerItemProperty((class_1792)HexItems.SLATE, ItemSlate.WRITTEN_PRED, (stack, level, holder, holderID) -> ItemSlate.hasPattern(stack) ? 1.0f : 0.0f);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_OAK);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_BIRCH);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_SPRUCE);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_JUNGLE);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_DARK_OAK);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_ACACIA);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_EDIFIED);
        RegisterClientStuff.registerWandOverrides(HexItems.STAFF_MINDSPLICE);
        RegisterClientStuff.registerGaslight4(HexItems.STAFF_QUENCHED);
        RegisterClientStuff.registerGaslight4(HexBlocks.QUENCHED_ALLAY.method_8389());
        RegisterClientStuff.registerGaslight4(HexBlocks.QUENCHED_ALLAY_TILES.method_8389());
        RegisterClientStuff.registerGaslight4(HexBlocks.QUENCHED_ALLAY_BRICKS.method_8389());
        RegisterClientStuff.registerGaslight4(HexBlocks.QUENCHED_ALLAY_BRICKS_SMALL.method_8389());
        RegisterClientStuff.registerGaslight4(HexItems.QUENCHED_SHARD);
        x.setRenderLayer(HexBlocks.CONJURED_LIGHT, class_1921.method_23581());
        x.setRenderLayer(HexBlocks.CONJURED_BLOCK, class_1921.method_23581());
        x.setRenderLayer((class_2248)HexBlocks.EDIFIED_DOOR, class_1921.method_23581());
        x.setRenderLayer((class_2248)HexBlocks.EDIFIED_TRAPDOOR, class_1921.method_23581());
        x.setRenderLayer(HexBlocks.AKASHIC_BOOKSHELF, class_1921.method_23581());
        x.setRenderLayer((class_2248)HexBlocks.SCONCE, class_1921.method_23581());
        x.setRenderLayer((class_2248)HexBlocks.AMETHYST_EDIFIED_LEAVES, class_1921.method_23579());
        x.setRenderLayer((class_2248)HexBlocks.AVENTURINE_EDIFIED_LEAVES, class_1921.method_23579());
        x.setRenderLayer((class_2248)HexBlocks.CITRINE_EDIFIED_LEAVES, class_1921.method_23579());
        x.setRenderLayer(HexBlocks.AKASHIC_RECORD, class_1921.method_23583());
        x.setRenderLayer(HexBlocks.QUENCHED_ALLAY, class_1921.method_23583());
        x.registerEntityRenderer(HexEntities.WALL_SCROLL, WallScrollRenderer::new);
        ScryingLensOverlays.addScryingLensStuff();
    }

    private static void registerGaslight4(class_1792 item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, GaslightingTracker.GASLIGHTING_PRED, (stack, level, holder, holderID) -> Math.abs(GaslightingTracker.getGaslightingAmount() % 4));
    }

    public static void registerColorProviders(BiConsumer<class_326, class_1792> itemColorRegistry, BiConsumer<class_322, class_2248> blockColorRegistry) {
        itemColorRegistry.accept(RegisterClientStuff.makeIotaStorageColorizer(HexItems.FOCUS::getColor), HexItems.FOCUS);
        itemColorRegistry.accept(RegisterClientStuff.makeIotaStorageColorizer(HexItems.SPELLBOOK::getColor), HexItems.SPELLBOOK);
        itemColorRegistry.accept(RegisterClientStuff.makeIotaStorageColorizer(HexItems.THOUGHT_KNOT::getColor), HexItems.THOUGHT_KNOT);
        blockColorRegistry.accept((bs, level, pos, idx) -> {
            if (!((Boolean)bs.method_11654((class_2769)BlockAkashicBookshelf.HAS_BOOKS)).booleanValue() || level == null || pos == null) {
                return -1;
            }
            class_2586 tile = level.method_8321(pos);
            if (!(tile instanceof BlockEntityAkashicBookshelf)) {
                return -1;
            }
            BlockEntityAkashicBookshelf beas = (BlockEntityAkashicBookshelf)tile;
            class_2487 iotaTag = beas.getIotaTag();
            if (iotaTag == null) {
                return -1;
            }
            return IotaType.getColor(iotaTag);
        }, HexBlocks.AKASHIC_BOOKSHELF);
    }

    public static class_326 makeIotaStorageColorizer(ToIntFunction<class_1799> getColor) {
        return (stack, idx) -> {
            if (idx == 1) {
                return getColor.applyAsInt(stack);
            }
            return -1;
        };
    }

    private static void registerSealableDataHolderOverrides(IotaHolderItem item, Predicate<class_1799> hasIota, Predicate<class_1799> isSealed) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty((class_1792)item, ItemFocus.OVERLAY_PRED, (stack, level, holder, holderID) -> {
            if (!hasIota.test(stack) && !NBTHelper.hasString(stack, "VisualOverride")) {
                return 0.0f;
            }
            if (!isSealed.test(stack)) {
                return 1.0f;
            }
            return 2.0f;
        });
    }

    private static void registerVariantOverrides(VariantItem item, Function<class_1799, Integer> variant) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty((class_1792)item, ItemFocus.VARIANT_PRED, (stack, level, holder, holderID) -> ((Integer)variant.apply(stack)).intValue());
    }

    private static void registerScrollOverrides(ItemScroll scroll) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(scroll, ItemScroll.ANCIENT_PREDICATE, (stack, level, holder, holderID) -> NBTHelper.hasString(stack, "op_id") ? 1.0f : 0.0f);
    }

    private static void registerPackagedSpellOverrides(ItemPackagedHex item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, ItemPackagedHex.HAS_PATTERNS_PRED, (stack, level, holder, holderID) -> item.hasHex(stack) ? 1.0f : 0.0f);
    }

    private static void registerWandOverrides(ItemStaff item) {
        IClientXplatAbstractions.INSTANCE.registerItemProperty(item, ItemStaff.FUNNY_LEVEL_PREDICATE, (stack, level, holder, holderID) -> {
            if (!stack.method_7938()) {
                return 0.0f;
            }
            String name = stack.method_7964().getString().toLowerCase(Locale.ROOT);
            if (name.contains("old")) {
                return 1.0f;
            }
            if (name.contains("cherry")) {
                return 2.0f;
            }
            return 0.0f;
        });
    }

    public static void registerBlockEntityRenderers(@NotNull BlockEntityRendererRegisterererer registerer) {
        registerer.registerBlockEntityRenderer(HexBlockEntities.SLATE_TILE, BlockEntitySlateRenderer::new);
        registerer.registerBlockEntityRenderer(HexBlockEntities.AKASHIC_BOOKSHELF_TILE, BlockEntityAkashicBookshelfRenderer::new);
        registerer.registerBlockEntityRenderer(HexBlockEntities.QUENCHED_ALLAY_TILE, BlockEntityQuenchedAllayRenderer::new);
        registerer.registerBlockEntityRenderer(HexBlockEntities.QUENCHED_ALLAY_TILES_TILE, BlockEntityQuenchedAllayRenderer::new);
        registerer.registerBlockEntityRenderer(HexBlockEntities.QUENCHED_ALLAY_BRICKS_TILE, BlockEntityQuenchedAllayRenderer::new);
        registerer.registerBlockEntityRenderer(HexBlockEntities.QUENCHED_ALLAY_BRICKS_SMALL_TILE, BlockEntityQuenchedAllayRenderer::new);
    }

    public static void onModelRegister(class_3300 recMan, Consumer<class_2960> extraModels) {
        for (Map.Entry<BlockQuenchedAllay, Boolean> type : QUENCHED_ALLAY_TYPES.entrySet()) {
            class_2960 blockLoc = class_7923.field_41175.method_10221((Object)type.getKey());
            Object locStart = "block/";
            if (type.getValue().booleanValue()) {
                locStart = (String)locStart + "deco/";
            }
            for (int i = 0; i < 4; ++i) {
                extraModels.accept(HexAPI.modLoc((String)locStart + blockLoc.method_12832() + "_" + i));
            }
        }
    }

    public static void onModelBake(class_1088 loader, Map<class_2960, class_1087> map) {
        for (Map.Entry<BlockQuenchedAllay, Boolean> type : QUENCHED_ALLAY_TYPES.entrySet()) {
            class_2960 blockLoc = class_7923.field_41175.method_10221((Object)type.getKey());
            Object locStart = "block/";
            if (type.getValue().booleanValue()) {
                locStart = (String)locStart + "deco/";
            }
            ArrayList<class_1087> list = new ArrayList<class_1087>();
            for (int i = 0; i < 4; ++i) {
                class_2960 variantLoc = HexAPI.modLoc((String)locStart + blockLoc.method_12832() + "_" + i);
                class_1087 model = map.get(variantLoc);
                list.add(model);
            }
            QUENCHED_ALLAY_VARIANTS.put(blockLoc, list);
        }
    }

    @FunctionalInterface
    public static interface BlockEntityRendererRegisterererer {
        public <T extends class_2586> void registerBlockEntityRenderer(class_2591<T> var1, class_5614<? super T> var2);
    }
}

