/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.math;

import at.petrak.hexcasting.api.casting.math.HexAngle;
import at.petrak.hexcasting.api.casting.math.HexCoord;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.api.utils.NBTBuilder;
import at.petrak.hexcasting.api.utils.NbtCompoundBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.class_241;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ*\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u000fJ\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\rJ!\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010!\u001a\u00020 H\u00d6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\b\b\u0002\u0010#\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b$\u0010%J\r\u0010'\u001a\u00020&\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010*\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0000\u00a2\u0006\u0004\b*\u0010+J#\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00122\u0006\u0010,\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b/\u0010\u000bJ\u0015\u00101\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u0002\u00a2\u0006\u0004\b1\u00102R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u00103\u001a\u0004\b4\u0010\u000fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00105\u001a\u0004\b6\u0010\r\u00a8\u00068"}, d2={"Lat/petrak/hexcasting/api/casting/math/HexPattern;", "", "Lat/petrak/hexcasting/api/casting/math/HexDir;", "startDir", "", "Lat/petrak/hexcasting/api/casting/math/HexAngle;", "angles", "<init>", "(Lat/petrak/hexcasting/api/casting/math/HexDir;Ljava/util/List;)V", "", "anglesSignature", "()Ljava/lang/String;", "component1", "()Lat/petrak/hexcasting/api/casting/math/HexDir;", "component2", "()Ljava/util/List;", "copy", "(Lat/petrak/hexcasting/api/casting/math/HexDir;Ljava/util/List;)Lat/petrak/hexcasting/api/casting/math/HexPattern;", "", "directions", "other", "", "equals", "(Ljava/lang/Object;)Z", "finalDir", "", "hexRadius", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "origin", "Lnet/minecraft/class_241;", "getCenter", "(FLat/petrak/hexcasting/api/casting/math/HexCoord;)Lnet/minecraft/class_241;", "", "hashCode", "()I", "start", "positions", "(Lat/petrak/hexcasting/api/casting/math/HexCoord;)Ljava/util/List;", "Lnet/minecraft/class_2487;", "serializeToNBT", "()Lnet/minecraft/class_2487;", "that", "sigsEqual", "(Lat/petrak/hexcasting/api/casting/math/HexPattern;)Z", "hexSize", "toLines", "(FLnet/minecraft/class_241;)Ljava/util/List;", "toString", "newDir", "tryAppendDir", "(Lat/petrak/hexcasting/api/casting/math/HexDir;)Z", "Ljava/util/List;", "getAngles", "Lat/petrak/hexcasting/api/casting/math/HexDir;", "getStartDir", "Companion", "hexcasting-fabric-1.20.1"})
public final class HexPattern {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HexDir startDir;
    @NotNull
    private final List<HexAngle> angles;
    @NotNull
    public static final String TAG_START_DIR = "start_dir";
    @NotNull
    public static final String TAG_ANGLES = "angles";
    @JvmField
    @NotNull
    public static final Codec<HexPattern> CODEC;

    public HexPattern(@NotNull HexDir startDir, @NotNull List<HexAngle> angles) {
        Intrinsics.checkNotNullParameter((Object)((Object)startDir), (String)"startDir");
        Intrinsics.checkNotNullParameter(angles, (String)TAG_ANGLES);
        this.startDir = startDir;
        this.angles = angles;
    }

    public /* synthetic */ HexPattern(HexDir hexDir, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = new ArrayList();
        }
        this(hexDir, list);
    }

    @NotNull
    public final HexDir getStartDir() {
        return this.startDir;
    }

    @NotNull
    public final List<HexAngle> getAngles() {
        return this.angles;
    }

    public final boolean tryAppendDir(@NotNull HexDir newDir) {
        Intrinsics.checkNotNullParameter((Object)((Object)newDir), (String)"newDir");
        Set linesSeen = new LinkedHashSet();
        HexDir compass = this.startDir;
        HexCoord cursor = HexCoord.Companion.getOrigin();
        for (HexAngle a : this.angles) {
            linesSeen.add(TuplesKt.to((Object)cursor, (Object)((Object)compass)));
            linesSeen.add(TuplesKt.to((Object)cursor.plus(compass), (Object)((Object)compass.rotatedBy(HexAngle.BACK))));
            cursor = cursor.plus(compass);
            compass = compass.times(a);
        }
        Pair potentialNewLine = TuplesKt.to((Object)(cursor = cursor.plus(compass)), (Object)((Object)newDir));
        if (linesSeen.contains(potentialNewLine)) {
            return false;
        }
        HexAngle nextAngle = newDir.minus(compass);
        if (nextAngle == HexAngle.BACK) {
            return false;
        }
        this.angles.add(nextAngle);
        return true;
    }

    @JvmOverloads
    @NotNull
    public final List<HexCoord> positions(@NotNull HexCoord start) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        ArrayList<HexCoord> out = new ArrayList<HexCoord>(this.angles.size() + 2);
        out.add(start);
        HexDir compass = this.startDir;
        HexCoord cursor = start;
        for (HexAngle a : this.angles) {
            cursor = cursor.plus(compass);
            out.add(cursor);
            compass = compass.times(a);
        }
        out.add(cursor.plus(compass));
        return out;
    }

    public static /* synthetic */ List positions$default(HexPattern hexPattern, HexCoord hexCoord, int n, Object object) {
        if ((n & 1) != 0) {
            hexCoord = HexCoord.Companion.getOrigin();
        }
        return hexPattern.positions(hexCoord);
    }

    @NotNull
    public final List<HexDir> directions() {
        ArrayList<HexDir> out = new ArrayList<HexDir>(this.angles.size() + 1);
        out.add(this.startDir);
        HexDir compass = this.startDir;
        for (HexAngle a : this.angles) {
            compass = compass.times(a);
            out.add(compass);
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HexDir finalDir() {
        void $this$fold$iv;
        Iterable iterable = this.angles;
        HexDir initial$iv = this.startDir;
        boolean $i$f$fold = false;
        HexDir accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void angle;
            HexAngle hexAngle = (HexAngle)((Object)element$iv);
            HexDir acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.times((HexAngle)angle);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final class_2487 serializeToNBT() {
        void $this$mapTo$iv$iv$iv;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        void nbt$iv;
        String $this$remAssign$iv;
        class_2487 class_24872;
        NBTBuilder this_$iv = NBTBuilder.INSTANCE;
        boolean $i$f$invoke = false;
        NBTBuilder this_$iv$iv = this_$iv;
        boolean $i$f$compound = false;
        class_2487 $this$serializeToNBT_u24lambda_u241 = class_24872 = NbtCompoundBuilder.constructor-impl(new class_2487());
        boolean bl = false;
        String string = TAG_START_DIR;
        int value$iv22 = this.startDir.ordinal();
        boolean bl2 = false;
        class_2481 class_24812 = class_2481.method_23233((byte)((byte)value$iv22));
        Intrinsics.checkNotNullExpressionValue((Object)class_24812, (String)"valueOf(value.toByte())");
        class_2520 value$iv22 = (class_2520)class_24812;
        boolean bl3 = false;
        $this$serializeToNBT_u24lambda_u241.method_10566($this$remAssign$iv, (class_2520)nbt$iv);
        $this$remAssign$iv = TAG_ANGLES;
        Iterable $this$map$iv = this.angles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void p0;
            HexAngle hexAngle = (HexAngle)((Object)item$iv$iv2);
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(p0.ordinal());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean bl5 = false;
        Iterable $this$map$iv$iv = (Iterable)value$iv22;
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void it$iv;
            Number number = (Number)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            boolean bl6 = false;
            collection.add(it$iv.byteValue());
        }
        List list = (List)destination$iv$iv$iv;
        value$iv22 = (class_2520)new class_2479(list);
        bl3 = false;
        $this$serializeToNBT_u24lambda_u241.method_10566($this$remAssign$iv, (class_2520)nbt$iv);
        return class_24872;
    }

    @NotNull
    public final String anglesSignature() {
        StringBuilder stringBuilder;
        StringBuilder $this$anglesSignature_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (HexAngle a : this.angles) {
            $this$anglesSignature_u24lambda_u242.append(switch (WhenMappings.$EnumSwitchMapping$0[a.ordinal()]) {
                case 1 -> "w";
                case 2 -> "e";
                case 3 -> "d";
                case 4 -> "s";
                case 5 -> "a";
                case 6 -> "q";
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @JvmOverloads
    @NotNull
    public final class_241 getCenter(float hexRadius, @NotNull HexCoord origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        class_241 class_2412 = class_241.field_1340;
        Intrinsics.checkNotNullExpressionValue((Object)class_2412, (String)"ZERO");
        class_241 originPx = HexUtils.coordToPx(origin, hexRadius, class_2412);
        List<class_241> points = this.toLines(hexRadius, originPx);
        return HexUtils.findCenter(points);
    }

    public static /* synthetic */ class_241 getCenter$default(HexPattern hexPattern, float f, HexCoord hexCoord, int n, Object object) {
        if ((n & 2) != 0) {
            hexCoord = HexCoord.Companion.getOrigin();
        }
        return hexPattern.getCenter(f, hexCoord);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<class_241> toLines(float hexSize, @NotNull class_241 origin) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Iterable $this$map$iv = HexPattern.positions$default(this, null, 1, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HexCoord hexCoord = (HexCoord)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HexUtils.coordToPx((HexCoord)it, hexSize, origin));
        }
        return (List)destination$iv$iv;
    }

    public final boolean sigsEqual(@NotNull HexPattern that) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return Intrinsics.areEqual(this.angles, that.angles);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u244.append("HexPattern[");
        $this$toString_u24lambda_u244.append((Object)this.startDir);
        $this$toString_u24lambda_u244.append(", ");
        $this$toString_u24lambda_u244.append(this.anglesSignature());
        $this$toString_u24lambda_u244.append("]");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final HexDir component1() {
        return this.startDir;
    }

    @NotNull
    public final List<HexAngle> component2() {
        return this.angles;
    }

    @NotNull
    public final HexPattern copy(@NotNull HexDir startDir, @NotNull List<HexAngle> angles) {
        Intrinsics.checkNotNullParameter((Object)((Object)startDir), (String)"startDir");
        Intrinsics.checkNotNullParameter(angles, (String)TAG_ANGLES);
        return new HexPattern(startDir, angles);
    }

    public static /* synthetic */ HexPattern copy$default(HexPattern hexPattern, HexDir hexDir, List list, int n, Object object) {
        if ((n & 1) != 0) {
            hexDir = hexPattern.startDir;
        }
        if ((n & 2) != 0) {
            list = hexPattern.angles;
        }
        return hexPattern.copy(hexDir, list);
    }

    public int hashCode() {
        int result = this.startDir.hashCode();
        result = result * 31 + ((Object)this.angles).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HexPattern)) {
            return false;
        }
        HexPattern hexPattern = (HexPattern)other;
        if (this.startDir != hexPattern.startDir) {
            return false;
        }
        return Intrinsics.areEqual(this.angles, hexPattern.angles);
    }

    @JvmOverloads
    @NotNull
    public final List<HexCoord> positions() {
        return HexPattern.positions$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final class_241 getCenter(float hexRadius) {
        return HexPattern.getCenter$default(this, hexRadius, null, 2, null);
    }

    private static final HexDir CODEC$lambda$6$lambda$5(KProperty1 $tmp0, HexPattern p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (HexDir)((Object)((Function1)$tmp0).invoke((Object)p0));
    }

    private static final App CODEC$lambda$6(RecordCodecBuilder.Instance instance) {
        return instance.group((App)Codec.STRING.fieldOf(TAG_START_DIR).forGetter(HexPattern::anglesSignature), (App)HexDir.Companion.getCODEC().fieldOf(TAG_ANGLES).forGetter(arg_0 -> HexPattern.CODEC$lambda$6$lambda$5((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, Companion::fromAngles);
    }

    @JvmStatic
    public static final boolean isPattern(@NotNull class_2487 tag) {
        return Companion.isPattern(tag);
    }

    @JvmStatic
    @NotNull
    public static final HexPattern fromNBT(@NotNull class_2487 tag) {
        return Companion.fromNBT(tag);
    }

    @JvmStatic
    @NotNull
    public static final HexPattern fromAngles(@NotNull String signature, @NotNull HexDir startDir) {
        return Companion.fromAngles(signature, startDir);
    }

    static {
        Codec codec = RecordCodecBuilder.create(HexPattern::CODEC$lambda$6);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create({instance -> inst\u2026n::fromAngles)\n        })");
        CODEC = codec;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00128\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lat/petrak/hexcasting/api/casting/math/HexPattern$Companion;", "", "<init>", "()V", "", "signature", "Lat/petrak/hexcasting/api/casting/math/HexDir;", "startDir", "Lat/petrak/hexcasting/api/casting/math/HexPattern;", "fromAngles", "(Ljava/lang/String;Lat/petrak/hexcasting/api/casting/math/HexDir;)Lat/petrak/hexcasting/api/casting/math/HexPattern;", "Lnet/minecraft/class_2487;", "tag", "fromNBT", "(Lnet/minecraft/class_2487;)Lat/petrak/hexcasting/api/casting/math/HexPattern;", "", "isPattern", "(Lnet/minecraft/class_2487;)Z", "Lcom/mojang/serialization/Codec;", "CODEC", "Lcom/mojang/serialization/Codec;", "TAG_ANGLES", "Ljava/lang/String;", "TAG_START_DIR", "hexcasting-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isPattern(@NotNull class_2487 tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            return tag.method_10573(HexPattern.TAG_START_DIR, 99) && tag.method_10573(HexPattern.TAG_ANGLES, 7);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final HexPattern fromNBT(@NotNull class_2487 tag) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            HexDir startDir = (HexDir)HexUtils.getSafe$default((Enum[])HexDir.values(), tag.method_10571(HexPattern.TAG_START_DIR), null, 2, null);
            byte[] byArray = tag.method_10547(HexPattern.TAG_ANGLES);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"tag.getByteArray(TAG_ANGLES)");
            byte[] byArray2 = byArray;
            HexAngle[] hexAngleArray = HexAngle.values();
            boolean $i$f$map = false;
            void var7_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void p0;
                void item$iv$iv;
                void var13_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((HexAngle)HexUtils.getSafe$default((Enum[])hexAngleArray, (byte)p0, null, 2, null));
            }
            List angles = (List)destination$iv$iv;
            return new HexPattern(startDir, CollectionsKt.toMutableList((Collection)angles));
        }

        @JvmStatic
        @NotNull
        public final HexPattern fromAngles(@NotNull String signature, @NotNull HexDir startDir) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)((Object)startDir), (String)"startDir");
            HexPattern out = new HexPattern(startDir, null, 2, null);
            HexDir compass = startDir;
            int n = signature.length();
            for (int i = 0; i < n; ++i) {
                HexAngle hexAngle;
                int idx = i;
                char c = signature.charAt(i);
                char c2 = c;
                if (c2 == 'w') {
                    hexAngle = HexAngle.FORWARD;
                } else if (c2 == 'e') {
                    hexAngle = HexAngle.RIGHT;
                } else if (c2 == 'd') {
                    hexAngle = HexAngle.RIGHT_BACK;
                } else if (c2 == 's') {
                    hexAngle = HexAngle.BACK;
                } else if (c2 == 'a') {
                    hexAngle = HexAngle.LEFT_BACK;
                } else if (c2 == 'q') {
                    hexAngle = HexAngle.LEFT;
                } else {
                    throw new IllegalArgumentException("Cannot match " + c + " at idx " + idx + " to a direction");
                }
                HexAngle angle = hexAngle;
                compass = compass.times(angle);
                boolean success2 = out.tryAppendDir(compass);
                if (success2) continue;
                throw new IllegalStateException("Adding the angle " + c + " at index " + idx + " made the pattern invalid by looping back on itself");
            }
            return out;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HexAngle.values().length];
            try {
                nArray[HexAngle.FORWARD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HexAngle.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HexAngle.RIGHT_BACK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HexAngle.BACK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HexAngle.LEFT_BACK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HexAngle.LEFT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

