/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.math;

import at.petrak.hexcasting.api.casting.math.HexDir;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\r\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\bJ\u0017\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0016\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u000eJ\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001b\u0010\u000eJ\u0018\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0017H\u0086\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001dJ\u001b\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00000\u001f2\u0006\u0010\u001e\u001a\u00020\u0002\u00a2\u0006\u0004\b \u0010!J\r\u0010\"\u001a\u00020\u0002\u00a2\u0006\u0004\b\"\u0010\bJ\u0015\u0010#\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000\u00a2\u0006\u0004\b#\u0010\u000eJ\u0015\u0010#\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0017\u00a2\u0006\u0004\b#\u0010\u001dJ\u0010\u0010%\u001a\u00020$H\u00d6\u0001\u00a2\u0006\u0004\b%\u0010&R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010'\u001a\u0004\b(\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010'\u001a\u0004\b)\u0010\b\u00a8\u0006,"}, d2={"Lat/petrak/hexcasting/api/casting/math/HexCoord;", "", "", "q", "r", "<init>", "(II)V", "component1", "()I", "component2", "copy", "(II)Lat/petrak/hexcasting/api/casting/math/HexCoord;", "x", "delta", "(Lat/petrak/hexcasting/api/casting/math/HexCoord;)Lat/petrak/hexcasting/api/casting/math/HexCoord;", "distanceTo", "(Lat/petrak/hexcasting/api/casting/math/HexCoord;)I", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "neighbor", "Lat/petrak/hexcasting/api/casting/math/HexDir;", "immediateDelta", "(Lat/petrak/hexcasting/api/casting/math/HexCoord;)Lat/petrak/hexcasting/api/casting/math/HexDir;", "minus", "plus", "d", "(Lat/petrak/hexcasting/api/casting/math/HexDir;)Lat/petrak/hexcasting/api/casting/math/HexCoord;", "radius", "", "rangeAround", "(I)Ljava/util/Iterator;", "s", "shiftedBy", "", "toString", "()Ljava/lang/String;", "I", "getQ", "getR", "Companion", "RingIter", "hexcasting-fabric-1.20.1"})
public final class HexCoord {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int q;
    private final int r;
    @NotNull
    private static final HexCoord Origin = new HexCoord(0, 0);

    public HexCoord(int q, int r) {
        this.q = q;
        this.r = r;
    }

    public final int getQ() {
        return this.q;
    }

    public final int getR() {
        return this.r;
    }

    public final int s() {
        return -this.q - this.r;
    }

    @NotNull
    public final HexCoord shiftedBy(@NotNull HexCoord x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return new HexCoord(this.q + x.q, this.r + x.r);
    }

    @NotNull
    public final HexCoord shiftedBy(@NotNull HexDir d) {
        Intrinsics.checkNotNullParameter((Object)((Object)d), (String)"d");
        return this.shiftedBy(d.asDelta());
    }

    @NotNull
    public final HexCoord delta(@NotNull HexCoord x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return new HexCoord(this.q - x.q, this.r - x.r);
    }

    @NotNull
    public final HexCoord plus(@NotNull HexCoord x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return this.shiftedBy(x);
    }

    @NotNull
    public final HexCoord plus(@NotNull HexDir d) {
        Intrinsics.checkNotNullParameter((Object)((Object)d), (String)"d");
        return this.shiftedBy(d);
    }

    @NotNull
    public final HexCoord minus(@NotNull HexCoord x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return this.delta(x);
    }

    public final int distanceTo(@NotNull HexCoord x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return (Math.abs(this.q - x.q) + Math.abs(this.q + this.r - x.q - x.r) + Math.abs(this.r - x.r)) / 2;
    }

    @NotNull
    public final Iterator<HexCoord> rangeAround(int radius) {
        return new RingIter(this, radius);
    }

    @Nullable
    public final HexDir immediateDelta(@NotNull HexCoord neighbor) {
        Intrinsics.checkNotNullParameter((Object)neighbor, (String)"neighbor");
        HexCoord hexCoord = neighbor.minus(this);
        return Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(1, 0)) ? HexDir.EAST : (Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(0, 1)) ? HexDir.SOUTH_EAST : (Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(-1, 1)) ? HexDir.SOUTH_WEST : (Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(-1, 0)) ? HexDir.WEST : (Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(0, -1)) ? HexDir.NORTH_WEST : (Intrinsics.areEqual((Object)hexCoord, (Object)new HexCoord(1, -1)) ? HexDir.NORTH_EAST : null)))));
    }

    public final int component1() {
        return this.q;
    }

    public final int component2() {
        return this.r;
    }

    @NotNull
    public final HexCoord copy(int q, int r) {
        return new HexCoord(q, r);
    }

    public static /* synthetic */ HexCoord copy$default(HexCoord hexCoord, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = hexCoord.q;
        }
        if ((n3 & 2) != 0) {
            n2 = hexCoord.r;
        }
        return hexCoord.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "HexCoord(q=" + this.q + ", r=" + this.r + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.q);
        result = result * 31 + Integer.hashCode(this.r);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HexCoord)) {
            return false;
        }
        HexCoord hexCoord = (HexCoord)other;
        if (this.q != hexCoord.q) {
            return false;
        }
        return this.r == hexCoord.r;
    }

    @NotNull
    public static final HexCoord getOrigin() {
        return Companion.getOrigin();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\t\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\fR\"\u0010\u000f\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\"\u0010\u0015\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lat/petrak/hexcasting/api/casting/math/HexCoord$RingIter;", "", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "center", "", "radius", "<init>", "(Lat/petrak/hexcasting/api/casting/math/HexCoord;I)V", "", "hasNext", "()Z", "next", "()Lat/petrak/hexcasting/api/casting/math/HexCoord;", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "getCenter", "q", "I", "getQ", "()I", "setQ", "(I)V", "r", "getR", "setR", "getRadius", "hexcasting-fabric-1.20.1"})
    private static final class RingIter
    implements Iterator<HexCoord>,
    KMappedMarker {
        @NotNull
        private final HexCoord center;
        private final int radius;
        private int q;
        private int r;

        public RingIter(@NotNull HexCoord center, int radius) {
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            this.center = center;
            this.radius = radius;
            this.q = -this.radius;
            this.r = Math.max(-this.radius, 0);
        }

        @NotNull
        public final HexCoord getCenter() {
            return this.center;
        }

        public final int getRadius() {
            return this.radius;
        }

        public final int getQ() {
            return this.q;
        }

        public final void setQ(int n) {
            this.q = n;
        }

        public final int getR() {
            return this.r;
        }

        public final void setR(int n) {
            this.r = n;
        }

        @Override
        public boolean hasNext() {
            return this.r <= this.radius + Math.min(0, -this.q) || this.q < this.radius;
        }

        @Override
        @NotNull
        public HexCoord next() {
            if (this.r > this.radius + Math.min(0, -this.q)) {
                int n = this.q;
                this.q = n + 1;
                this.r = -this.radius + Math.max(0, -this.q);
            }
            HexCoord out = new HexCoord(this.center.getQ() + this.q, this.center.getR() + this.r);
            int n = this.r;
            this.r = n + 1;
            return out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lat/petrak/hexcasting/api/casting/math/HexCoord$Companion;", "", "<init>", "()V", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "Origin", "Lat/petrak/hexcasting/api/casting/math/HexCoord;", "getOrigin", "()Lat/petrak/hexcasting/api/casting/math/HexCoord;", "getOrigin$annotations", "hexcasting-fabric-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HexCoord getOrigin() {
            return Origin;
        }

        @JvmStatic
        public static /* synthetic */ void getOrigin$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

