/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval.env;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.PatternShapeMatch;
import at.petrak.hexcasting.api.casting.circles.BlockEntityAbstractImpetus;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.MishapEnvironment;
import at.petrak.hexcasting.api.casting.eval.env.CircleMishapEnv;
import at.petrak.hexcasting.api.casting.eval.sideeffects.OperatorSideEffect;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapDisallowedSpell;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.Sentinel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class CircleCastEnv
extends CastingEnvironment {
    protected final CircleExecutionState execState;

    public CircleCastEnv(class_3218 world, CircleExecutionState execState) {
        super(world);
        this.execState = execState;
    }

    @Override
    @Nullable
    public class_1309 getCastingEntity() {
        return this.execState.getCaster(this.world);
    }

    @Override
    @Nullable
    public class_3222 getCaster() {
        return this.execState.getCaster(this.world);
    }

    @Nullable
    public BlockEntityAbstractImpetus getImpetus() {
        class_2586 entity = this.world.method_8321(this.execState.impetusPos);
        if (entity instanceof BlockEntityAbstractImpetus) {
            return (BlockEntityAbstractImpetus)entity;
        }
        return null;
    }

    public CircleExecutionState circleState() {
        return this.execState;
    }

    @Override
    public MishapEnvironment getMishapEnvironment() {
        return new CircleMishapEnv(this.world, this.execState);
    }

    @Override
    public void precheckAction(PatternShapeMatch match) throws Mishap {
        super.precheckAction(match);
        class_2960 key = this.actionKey(match);
        if (!HexConfig.server().isActionAllowedInCircles(key)) {
            throw new MishapDisallowedSpell("disallowed_circle");
        }
    }

    @Override
    public void postExecution(CastResult result) {
        BlockEntityAbstractImpetus imp;
        super.postExecution(result);
        class_3414 sound = result.getSound().sound();
        if (sound != null) {
            class_2338 soundPos = this.execState.currentPos;
            this.world.method_8396(null, soundPos, sound, class_3419.field_15248, 1.0f, 1.0f);
        }
        if ((imp = this.getImpetus()) != null) {
            for (OperatorSideEffect sideEffect : result.getSideEffects()) {
                OperatorSideEffect.DoMishap doMishap;
                class_2561 msg;
                if (!(sideEffect instanceof OperatorSideEffect.DoMishap) || (msg = (doMishap = (OperatorSideEffect.DoMishap)sideEffect).getMishap().errorMessageWithName(this, doMishap.getErrorCtx())) == null) continue;
                imp.postMishap(msg);
            }
        }
    }

    @Override
    public class_243 mishapSprayPos() {
        return class_243.method_24953((class_2382)this.execState.currentPos);
    }

    @Override
    public long extractMediaEnvironment(long cost, boolean simulate) {
        BlockEntityAbstractImpetus entity = this.getImpetus();
        if (entity == null) {
            return cost;
        }
        long mediaAvailable = entity.getMedia();
        if (mediaAvailable < 0L) {
            return 0L;
        }
        long mediaToTake = Math.min(cost, mediaAvailable);
        cost -= mediaToTake;
        if (!simulate) {
            entity.setMedia(mediaAvailable - mediaToTake);
        }
        return cost;
    }

    @Override
    public boolean isVecInRangeEnvironment(class_243 vec) {
        class_3222 caster = this.execState.getCaster(this.world);
        if (caster != null) {
            if (vec.method_1025(caster.method_19538()) <= (double)(caster.method_17682() * caster.method_17682())) {
                return true;
            }
            Sentinel sentinel = HexAPI.instance().getSentinel(caster);
            if (sentinel != null && sentinel.extendsRange() && caster.method_37908().method_27983() == sentinel.dimension() && vec.method_1025(sentinel.position()) <= 256.00000000001) {
                return true;
            }
        }
        return this.execState.bounds.method_1006(vec);
    }

    @Override
    public boolean isEnlightened() {
        if (this.getCastingEntity() == null) {
            return true;
        }
        return super.isEnlightened();
    }

    @Override
    public boolean hasEditPermissionsAtEnvironment(class_2338 pos) {
        return true;
    }

    @Override
    public class_1268 getCastingHand() {
        return class_1268.field_5808;
    }

    @Override
    protected List<class_1799> getUsableStacks(CastingEnvironment.StackDiscoveryMode mode) {
        if (this.getCaster() != null) {
            return this.getUsableStacksForPlayer(mode, null, this.getCaster());
        }
        return new ArrayList<class_1799>();
    }

    @Override
    protected List<CastingEnvironment.HeldItemInfo> getPrimaryStacks() {
        if (this.getCaster() != null) {
            return this.getPrimaryStacksForPlayer(class_1268.field_5810, this.getCaster());
        }
        return List.of();
    }

    @Override
    public boolean replaceItem(Predicate<class_1799> stackOk, class_1799 replaceWith, @Nullable class_1268 hand) {
        if (this.getCaster() != null) {
            return this.replaceItemForPlayer(stackOk, replaceWith, hand, this.getCaster());
        }
        return false;
    }

    @Override
    public FrozenPigment getPigment() {
        BlockEntityAbstractImpetus impetus = this.getImpetus();
        if (impetus == null) {
            return FrozenPigment.DEFAULT.get();
        }
        return impetus.getPigment();
    }

    @Override
    @Nullable
    public FrozenPigment setPigment(@Nullable FrozenPigment pigment) {
        BlockEntityAbstractImpetus impetus = this.getImpetus();
        if (impetus == null) {
            return null;
        }
        return impetus.setPigment(pigment);
    }

    @Override
    public void produceParticles(ParticleSpray particles, FrozenPigment pigment) {
        particles.sprayParticles(this.world, pigment);
    }

    @Override
    public void printMessage(class_2561 message) {
        BlockEntityAbstractImpetus impetus = this.getImpetus();
        if (impetus == null) {
            return;
        }
        impetus.postPrint(message);
    }
}

